/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Arrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

final class BytesBinaryDVAtomicFieldData
implements AtomicFieldData {
    private final BinaryDocValues values;

    BytesBinaryDVAtomicFieldData(BinaryDocValues values) {
        this.values = values;
    }

    public long ramBytesUsed() {
        return -1L;
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        return new SortedBinaryDocValues(){
            int count;
            BytesRefBuilder[] refs = new BytesRefBuilder[0];
            final ByteArrayDataInput in = new ByteArrayDataInput();

            @Override
            public void setDocument(int docId) {
                BytesRef bytes = BytesBinaryDVAtomicFieldData.this.values.get(docId);
                this.in.reset(bytes.bytes, bytes.offset, bytes.length);
                if (bytes.length == 0) {
                    this.count = 0;
                } else {
                    this.count = this.in.readVInt();
                    if (this.count > this.refs.length) {
                        int previousLength = this.refs.length;
                        this.refs = Arrays.copyOf(this.refs, ArrayUtil.oversize((int)this.count, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
                        for (int i = previousLength; i < this.refs.length; ++i) {
                            this.refs[i] = new BytesRefBuilder();
                        }
                    }
                    for (int i = 0; i < this.count; ++i) {
                        int length = this.in.readVInt();
                        BytesRefBuilder scratch = this.refs[i];
                        scratch.grow(length);
                        this.in.readBytes(scratch.bytes(), 0, length);
                        scratch.setLength(length);
                    }
                }
            }

            @Override
            public int count() {
                return this.count;
            }

            @Override
            public BytesRef valueAt(int index) {
                return this.refs[index].get();
            }
        };
    }

    @Override
    public ScriptDocValues getScriptValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

