/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.LoggerInfoStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineAlreadyStartedException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.engine.internal.DeleteVersionValue;
import org.elasticsearch.index.engine.internal.LiveVersionMap;
import org.elasticsearch.index.engine.internal.VersionValue;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.merge.policy.ElasticsearchMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.search.nested.IncludeNestedDocsQuery;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.indices.warmer.InternalIndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalEngine
extends AbstractIndexShardComponent
implements Engine {
    private volatile boolean failEngineOnCorruption;
    private volatile ByteSizeValue indexingBufferSize;
    private volatile int indexConcurrency;
    private volatile boolean compoundOnFlush = true;
    private volatile boolean checksumOnMerge = true;
    private long gcDeletesInMillis;
    private volatile long lastDeleteVersionPruneTimeMSec;
    private volatile boolean enableGcDeletes = true;
    private volatile String codecName;
    private final boolean optimizeAutoGenerateId;
    private final ThreadPool threadPool;
    private final ShardIndexingService indexingService;
    private final IndexSettingsService indexSettingsService;
    @Nullable
    private final InternalIndicesWarmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final AnalysisService analysisService;
    private final SimilarityService similarityService;
    private final CodecService codecService;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final InternalLock readLock = new InternalLock(this.rwl.readLock());
    private final InternalLock writeLock = new InternalLock(this.rwl.writeLock());
    private volatile IndexWriter indexWriter;
    private final SearcherFactory searcherFactory = new SearchFactory();
    private volatile SearcherManager searcherManager;
    private volatile boolean closed = false;
    private volatile boolean dirty = false;
    private volatile boolean possibleMergeNeeded = false;
    private final AtomicBoolean optimizeMutex = new AtomicBoolean();
    private volatile boolean flushNeeded = false;
    private final AtomicInteger flushing = new AtomicInteger();
    private final Lock flushLock = new ReentrantLock();
    private final RecoveryCounter onGoingRecoveries = new RecoveryCounter();
    private final LiveVersionMap versionMap;
    private final Object[] dirtyLocks;
    private final Object refreshMutex = new Object();
    private final ApplySettings applySettings = new ApplySettings();
    private volatile boolean failOnMergeFailure;
    private Throwable failedEngine = null;
    private final Lock failEngineLock = new ReentrantLock();
    private final CopyOnWriteArrayList<Engine.FailedEngineListener> failedEngineListeners = new CopyOnWriteArrayList();
    private final AtomicLong translogIdGenerator = new AtomicLong();
    private final AtomicBoolean versionMapRefreshPending = new AtomicBoolean();
    private SegmentInfos lastCommittedSegmentInfos;
    private IndexThrottle throttle;
    public static final String INDEX_INDEX_CONCURRENCY = "index.index_concurrency";
    public static final String INDEX_COMPOUND_ON_FLUSH = "index.compound_on_flush";
    public static final String INDEX_CHECKSUM_ON_MERGE = "index.checksum_on_merge";
    public static final String INDEX_GC_DELETES = "index.gc_deletes";
    public static final String INDEX_FAIL_ON_MERGE_FAILURE = "index.fail_on_merge_failure";
    public static final String INDEX_FAIL_ON_CORRUPTION = "index.fail_on_corruption";

    @Inject
    public InternalEngine(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexSettingsService indexSettingsService, ShardIndexingService indexingService, @Nullable IndicesWarmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, Translog translog, MergePolicyProvider mergePolicyProvider, MergeSchedulerProvider mergeScheduler, AnalysisService analysisService, SimilarityService similarityService, CodecService codecService) throws EngineException {
        super(shardId, indexSettings);
        Preconditions.checkNotNull(store, "Store must be provided to the engine");
        Preconditions.checkNotNull(deletionPolicy, "Snapshot deletion policy must be provided to the engine");
        Preconditions.checkNotNull(translog, "Translog must be provided to the engine");
        this.gcDeletesInMillis = indexSettings.getAsTime(INDEX_GC_DELETES, TimeValue.timeValueSeconds(60L)).millis();
        this.indexingBufferSize = this.componentSettings.getAsBytesSize("index_buffer_size", new ByteSizeValue(64L, ByteSizeUnit.MB));
        this.codecName = indexSettings.get("index.codec", "default");
        this.threadPool = threadPool;
        this.lastDeleteVersionPruneTimeMSec = threadPool.estimatedTimeInMillis();
        this.indexSettingsService = indexSettingsService;
        this.indexingService = indexingService;
        this.warmer = (InternalIndicesWarmer)warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.translog = translog;
        this.mergePolicyProvider = mergePolicyProvider;
        this.mergeScheduler = mergeScheduler;
        this.analysisService = analysisService;
        this.similarityService = similarityService;
        this.codecService = codecService;
        this.compoundOnFlush = indexSettings.getAsBoolean(INDEX_COMPOUND_ON_FLUSH, (Boolean)this.compoundOnFlush);
        this.checksumOnMerge = indexSettings.getAsBoolean(INDEX_CHECKSUM_ON_MERGE, (Boolean)this.checksumOnMerge);
        this.indexConcurrency = indexSettings.getAsInt(INDEX_INDEX_CONCURRENCY, (Integer)Math.max(8, (int)((double)EsExecutors.boundedNumberOfProcessors(indexSettings) * 0.65)));
        this.versionMap = new LiveVersionMap();
        this.dirtyLocks = new Object[this.indexConcurrency * 50];
        for (int i = 0; i < this.dirtyLocks.length; ++i) {
            this.dirtyLocks[i] = new Object();
        }
        this.optimizeAutoGenerateId = indexSettings.getAsBoolean("index.optimize_auto_generated_id", (Boolean)true);
        this.indexSettingsService.addListener(this.applySettings);
        this.failEngineOnCorruption = indexSettings.getAsBoolean(INDEX_FAIL_ON_CORRUPTION, (Boolean)true);
        this.failOnMergeFailure = indexSettings.getAsBoolean(INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)true);
        if (this.failOnMergeFailure) {
            this.mergeScheduler.addFailureListener(new FailEngineOnMergeFailure());
        }
        store.incRef();
    }

    @Override
    public void updateIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        ByteSizeValue preValue = this.indexingBufferSize;
        try (InternalLock _ = this.readLock.acquire();){
            this.indexingBufferSize = indexingBufferSize;
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter != null) {
                indexWriter.getConfig().setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            }
        }
        if (preValue.bytes() != indexingBufferSize.bytes()) {
            if (indexingBufferSize == Engine.INACTIVE_SHARD_INDEXING_BUFFER && preValue != Engine.INACTIVE_SHARD_INDEXING_BUFFER) {
                this.logger.debug("updating index_buffer_size from [{}] to (inactive) [{}]", preValue, indexingBufferSize);
                try {
                    this.flush(new Engine.Flush().type(Engine.Flush.Type.COMMIT));
                }
                catch (EngineClosedException e) {
                }
                catch (FlushNotAllowedEngineException e) {
                }
                catch (Throwable e) {
                    this.logger.warn("failed to flush after setting shard to inactive", e, new Object[0]);
                }
            } else {
                this.logger.debug("updating index_buffer_size from [{}] to [{}]", preValue, indexingBufferSize);
            }
        }
    }

    @Override
    public void addFailedEngineListener(Engine.FailedEngineListener listener) {
        this.failedEngineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void start() throws EngineException {
        this.store.incRef();
        try (InternalLock _ = this.writeLock.acquire();){
            if (this.indexWriter != null) {
                throw new EngineAlreadyStartedException(this.shardId);
            }
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("starting engine", new Object[0]);
            }
            try {
                this.indexWriter = this.createWriter();
                this.mergeScheduler.removeListener(this.throttle);
                this.throttle = new IndexThrottle(this.mergeScheduler, this.logger, this.indexingService);
                this.mergeScheduler.addListener(this.throttle);
            }
            catch (IOException e) {
                this.maybeFailEngine(e, "start");
                if (this.indexWriter != null) {
                    try {
                        IndexWriter pending = this.indexWriter;
                        this.indexWriter = null;
                        pending.rollback();
                    }
                    catch (IOException e1) {
                        e.addSuppressed(e1);
                    }
                }
                throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)e);
            }
            try {
                if (Lucene.indexExists(this.store.directory())) {
                    Map commitUserData = Lucene.readSegmentInfos(this.store.directory()).getUserData();
                    if (commitUserData.containsKey("translog_id")) {
                        this.translogIdGenerator.set(Long.parseLong((String)commitUserData.get("translog_id")));
                    } else {
                        this.translogIdGenerator.set(System.currentTimeMillis());
                        this.indexWriter.setCommitData(Collections.singletonMap("translog_id", Long.toString(this.translogIdGenerator.get())));
                        this.indexWriter.commit();
                    }
                } else {
                    this.translogIdGenerator.set(System.currentTimeMillis());
                    this.indexWriter.setCommitData(Collections.singletonMap("translog_id", Long.toString(this.translogIdGenerator.get())));
                    this.indexWriter.commit();
                }
                this.translog.newTranslog(this.translogIdGenerator.get());
                this.searcherManager = this.buildSearchManager(this.indexWriter);
                this.versionMap.setManager((ReferenceManager)this.searcherManager);
                this.readLastCommittedSegmentsInfo();
            }
            catch (IOException e) {
                block34: {
                    this.maybeFailEngine(e, "start");
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException e1) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexWriter});
                        break block34;
                        catch (Throwable throwable) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexWriter});
                            throw throwable;
                        }
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexWriter});
                }
                throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", (Throwable)e);
            }
        }
        finally {
            this.store.decRef();
        }
    }

    private void readLastCommittedSegmentsInfo() throws IOException {
        this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
    }

    @Override
    public TimeValue defaultRefreshInterval() {
        return new TimeValue(1L, TimeUnit.SECONDS);
    }

    public ByteSizeValue indexingBufferSize() {
        return this.indexingBufferSize;
    }

    @Override
    public void enableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        try (InternalLock _ = this.readLock.acquire();){
            Versions.DocIdAndVersion docIdAndVersion;
            VersionValue versionValue;
            if (get.realtime() && (versionValue = this.versionMap.getUnderLock(get.uid().bytes())) != null) {
                if (versionValue.delete()) {
                    Engine.GetResult getResult = Engine.GetResult.NOT_EXISTS;
                    return getResult;
                }
                if (get.versionType().isVersionConflictForReads(versionValue.version(), get.version())) {
                    Uid uid = Uid.createUid(get.uid().text());
                    throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), versionValue.version(), get.version());
                }
                if (!get.loadSource()) {
                    Engine.GetResult uid = new Engine.GetResult(true, versionValue.version(), null);
                    return uid;
                }
                Translog.Operation op = this.translog.read(versionValue.translogLocation());
                if (op != null) {
                    Engine.GetResult x2 = new Engine.GetResult(true, versionValue.version(), op.getSource());
                    return x2;
                }
            }
            Engine.Searcher searcher = this.acquireSearcher("get");
            try {
                docIdAndVersion = Versions.loadDocIdAndVersion(searcher.reader(), get.uid());
            }
            catch (Throwable e) {
                Releasables.closeWhileHandlingException(searcher);
                throw new EngineException(this.shardId(), "Couldn't resolve version", e);
            }
            if (docIdAndVersion != null && get.versionType().isVersionConflictForReads(docIdAndVersion.version, get.version())) {
                Releasables.close(searcher);
                Uid uid = Uid.createUid(get.uid().text());
                throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), docIdAndVersion.version, get.version());
            }
            if (docIdAndVersion != null) {
                Engine.GetResult getResult = new Engine.GetResult(searcher, docIdAndVersion);
                return getResult;
            }
            Releasables.close(searcher);
            Engine.GetResult getResult = Engine.GetResult.NOT_EXISTS;
            return getResult;
        }
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        try (InternalLock _ = this.readLock.acquire();){
            IndexWriter writer = this.currentIndexWriter();
            try (Releasable r = this.throttle.acquireThrottle();){
                this.innerCreate(create, writer);
            }
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException | IllegalStateException | OutOfMemoryError t) {
            this.maybeFailEngine(t, "create");
            throw new CreateFailedEngineException(this.shardId, create, t);
        }
        this.checkVersionMapRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create, IndexWriter writer) throws IOException {
        if (this.optimizeAutoGenerateId && create.autoGeneratedId() && !create.canHaveDuplicates()) {
            this.innerCreateNoLock(create, writer, -1L, null);
        } else {
            Object object = this.dirtyLock(create.uid());
            synchronized (object) {
                VersionValue versionValue = this.versionMap.getUnderLock(create.uid().bytes());
                long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
                this.innerCreateNoLock(create, writer, currentVersion, versionValue);
            }
        }
    }

    private void innerCreateNoLock(Engine.Create create, IndexWriter writer, long currentVersion, VersionValue versionValue) throws IOException {
        long expectedVersion = create.version();
        if (create.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                return;
            }
            throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
        }
        long updatedVersion = create.versionType().updateVersion(currentVersion, expectedVersion);
        boolean doUpdate = false;
        if (versionValue != null && !versionValue.delete() || versionValue == null && currentVersion != -1L) {
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                return;
            }
            if (create.origin() == Engine.Operation.Origin.REPLICA) {
                doUpdate = true;
            } else {
                assert (create.origin() == Engine.Operation.Origin.PRIMARY);
                throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
            }
        }
        create.updateVersion(updatedVersion);
        if (doUpdate) {
            if (create.docs().size() > 1) {
                writer.updateDocuments(create.uid(), create.docs(), create.analyzer());
            } else {
                writer.updateDocument(create.uid(), (Iterable)create.docs().get(0), create.analyzer());
            }
        } else if (create.docs().size() > 1) {
            writer.addDocuments(create.docs(), create.analyzer());
        } else {
            writer.addDocument((Iterable)create.docs().get(0), create.analyzer());
        }
        Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
        this.versionMap.putUnderLock(create.uid().bytes(), new VersionValue(updatedVersion, translogLocation));
        this.indexingService.postCreateUnderLock(create);
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        try (InternalLock _ = this.readLock.acquire();){
            IndexWriter writer = this.currentIndexWriter();
            try (Releasable r = this.throttle.acquireThrottle();){
                this.innerIndex(index, writer);
            }
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException | IllegalStateException | OutOfMemoryError t) {
            this.maybeFailEngine(t, "index");
            throw new IndexFailedEngineException(this.shardId, index, t);
        }
        this.checkVersionMapRefresh();
    }

    private void checkVersionMapRefresh() {
        if ((double)this.versionMap.ramBytesUsedForRefresh() > 0.25 * (double)this.indexingBufferSize.bytes() && !this.versionMapRefreshPending.getAndSet(true)) {
            try {
                if (this.closed) {
                    return;
                }
                this.threadPool.executor("refresh").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InternalEngine.this.refresh(new Engine.Refresh("version_table_full"));
                        }
                        catch (EngineClosedException engineClosedException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException esRejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerIndex(Engine.Index index, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            VersionValue versionValue = this.versionMap.getUnderLock(index.uid().bytes());
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            long expectedVersion = index.version();
            if (index.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
                if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
            }
            long updatedVersion = index.versionType().updateVersion(currentVersion, expectedVersion);
            index.updateVersion(updatedVersion);
            if (currentVersion == -1L) {
                index.created(true);
                if (index.docs().size() > 1) {
                    writer.addDocuments(index.docs(), index.analyzer());
                } else {
                    writer.addDocument((Iterable)index.docs().get(0), index.analyzer());
                }
            } else {
                if (versionValue != null) {
                    index.created(versionValue.delete());
                }
                if (index.docs().size() > 1) {
                    writer.updateDocuments(index.uid(), index.docs(), index.analyzer());
                } else {
                    writer.updateDocument(index.uid(), (Iterable)index.docs().get(0), index.analyzer());
                }
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
            this.versionMap.putUnderLock(index.uid().bytes(), new VersionValue(updatedVersion, translogLocation));
            this.indexingService.postIndexUnderLock(index);
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        try (InternalLock _ = this.readLock.acquire();){
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerDelete(delete, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException | IllegalStateException | OutOfMemoryError t) {
            this.maybeFailEngine(t, "delete");
            throw new DeleteFailedEngineException(this.shardId, delete, t);
        }
        this.maybePruneDeletedTombstones();
    }

    private void maybePruneDeletedTombstones() {
        if (this.enableGcDeletes && (double)(this.threadPool.estimatedTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.gcDeletesInMillis * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(delete.uid());
        synchronized (object) {
            boolean found;
            VersionValue versionValue = this.versionMap.getUnderLock(delete.uid().bytes());
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            long expectedVersion = delete.version();
            if (delete.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
                if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, expectedVersion);
            }
            long updatedVersion = delete.versionType().updateVersion(currentVersion, expectedVersion);
            if (currentVersion == -1L) {
                found = false;
            } else if (versionValue != null && versionValue.delete()) {
                found = false;
            } else {
                writer.deleteDocuments(new Term[]{delete.uid()});
                found = true;
            }
            delete.updateVersion(updatedVersion, found);
            Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
            this.versionMap.putUnderLock(delete.uid().bytes(), new DeleteVersionValue(updatedVersion, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postDeleteUnderLock(delete);
        }
    }

    @Override
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        try (InternalLock _ = this.readLock.acquire();){
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId);
            }
            Query query = delete.nested() && delete.aliasFilter() != null ? new IncludeNestedDocsQuery((Query)new XFilteredQuery(delete.query(), delete.aliasFilter()), delete.parentFilter()) : (delete.nested() ? new IncludeNestedDocsQuery(delete.query(), delete.parentFilter()) : (delete.aliasFilter() != null ? new XFilteredQuery(delete.query(), delete.aliasFilter()) : delete.query()));
            writer.deleteDocuments(new Query[]{query});
            this.translog.add(new Translog.DeleteByQuery(delete));
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (Throwable t) {
            this.maybeFailEngine(t, "delete_by_query");
            throw new DeleteByQueryFailedEngineException(this.shardId, delete, t);
        }
        this.refresh(new Engine.Refresh("delete_by_query").force(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Engine.Searcher acquireSearcher(String source) throws EngineException {
        boolean success = false;
        this.store.incRef();
        try {
            Engine.Searcher searcher;
            block26: {
                SearcherManager manager = this.searcherManager;
                if (manager == null) {
                    this.ensureOpen();
                    try (InternalLock _ = this.readLock.acquire();){
                        manager = this.searcherManager;
                        assert (manager != null) : "SearcherManager is null but shouldn't";
                    }
                }
                IndexSearcher searcher2 = (IndexSearcher)manager.acquire();
                try {
                    Engine.Searcher retVal = this.newSearcher(source, searcher2, manager);
                    success = true;
                    searcher = retVal;
                    if (success) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        if (!success) {
                            manager.release((Object)searcher2);
                        }
                        throw throwable;
                    }
                    catch (EngineClosedException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        this.ensureOpen();
                        this.logger.error("failed to acquire searcher, source {}", ex, source);
                        throw new EngineException(this.shardId, "failed to acquire searcher, source " + source, ex);
                    }
                }
                manager.release((Object)searcher2);
            }
            return searcher;
        }
        finally {
            if (!success) {
                this.store.decRef();
            }
        }
    }

    protected Engine.Searcher newSearcher(String source, IndexSearcher searcher, SearcherManager manager) {
        return new EngineSearcher(source, searcher, manager);
    }

    @Override
    public boolean refreshNeeded() {
        if (this.store.tryIncRef()) {
            try {
                boolean bl = this.dirty || !this.searcherManager.isSearcherCurrent();
                return bl;
            }
            catch (IOException e) {
                this.logger.error("failed to access searcher manager", e, new Object[0]);
                this.failEngine("failed to access searcher manager", e);
                throw new EngineException(this.shardId, "failed to access searcher manager", (Throwable)e);
            }
            finally {
                this.store.decRef();
            }
        }
        return false;
    }

    @Override
    public boolean possibleMergeNeeded() {
        IndexWriter writer = this.indexWriter;
        if (writer == null) {
            return false;
        }
        return this.possibleMergeNeeded || writer.hasPendingMerges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Engine.Refresh refresh) throws EngineException {
        if (this.indexWriter == null) {
            throw new EngineClosedException(this.shardId);
        }
        try (InternalLock _ = this.readLock.acquire();){
            this.ensureOpen();
            Object object = this.refreshMutex;
            synchronized (object) {
                if (this.refreshNeeded() || refresh.force()) {
                    this.dirty = false;
                    boolean refreshed = this.searcherManager.maybeRefresh();
                    assert (refreshed) : "failed to refresh even though refreshMutex was acquired";
                }
            }
        }
        catch (AlreadyClosedException e) {
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Throwable t) {
            this.failEngine("refresh failed", t);
            throw new RefreshFailedEngineException(this.shardId, t);
        }
        this.maybePruneDeletedTombstones();
        this.versionMapRefreshPending.set(false);
    }

    @Override
    public void flush(Engine.Flush flush) throws EngineException {
        this.ensureOpen();
        if ((flush.type() == Engine.Flush.Type.NEW_WRITER || flush.type() == Engine.Flush.Type.COMMIT_TRANSLOG) && this.onGoingRecoveries.get() > 0) {
            throw new FlushNotAllowedEngineException(this.shardId, "recovery is in progress, flush [" + (Object)((Object)flush.type()) + "] is not allowed");
        }
        int currentFlushing = this.flushing.incrementAndGet();
        if (currentFlushing > 1 && !flush.waitIfOngoing()) {
            this.flushing.decrementAndGet();
            throw new FlushNotAllowedEngineException(this.shardId, "already flushing...");
        }
        this.flushLock.lock();
        try {
            Throwable throwable;
            InternalLock _;
            block77: {
                IndexWriter indexWriter;
                if (flush.type() == Engine.Flush.Type.NEW_WRITER) {
                    _ = this.writeLock.acquire();
                    throwable = null;
                    try {
                        if (this.onGoingRecoveries.get() > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        this.dirty = false;
                        try {
                            long translogId = this.translog.currentId();
                            this.indexWriter.setCommitData(Collections.singletonMap("translog_id", Long.toString(translogId)));
                            this.indexWriter.commit();
                            this.indexWriter.rollback();
                            this.indexWriter = this.createWriter();
                            this.mergeScheduler.removeListener(this.throttle);
                            this.throttle = new IndexThrottle(this.mergeScheduler, this.logger, this.indexingService);
                            this.mergeScheduler.addListener(this.throttle);
                            if (this.flushNeeded || flush.force()) {
                                this.flushNeeded = false;
                                translogId = this.translogIdGenerator.incrementAndGet();
                                this.indexWriter.setCommitData(Collections.singletonMap("translog_id", Long.toString(translogId)));
                                this.indexWriter.commit();
                                this.translog.newTranslog(translogId);
                            }
                            SearcherManager current = this.searcherManager;
                            this.searcherManager = this.buildSearchManager(this.indexWriter);
                            this.versionMap.setManager((ReferenceManager)this.searcherManager);
                            try {
                                IOUtils.close((Closeable[])new Closeable[]{current});
                            }
                            catch (Throwable t) {
                                this.logger.warn("Failed to close current SearcherManager", t, new Object[0]);
                            }
                            this.maybePruneDeletedTombstones();
                            break block77;
                        }
                        catch (Throwable t) {
                            throw new FlushFailedEngineException(this.shardId, t);
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (_ != null) {
                            if (throwable != null) {
                                try {
                                    _.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                _.close();
                            }
                        }
                    }
                }
                if (flush.type() == Engine.Flush.Type.COMMIT_TRANSLOG) {
                    block78: {
                        _ = this.readLock.acquire();
                        throwable = null;
                        try {
                            indexWriter = this.currentIndexWriter();
                            if (this.onGoingRecoveries.get() > 0) {
                                throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                            }
                            if (!this.flushNeeded && !flush.force()) break block78;
                            this.flushNeeded = false;
                            try {
                                long translogId = this.translogIdGenerator.incrementAndGet();
                                this.translog.newTransientTranslog(translogId);
                                indexWriter.setCommitData(Collections.singletonMap("translog_id", Long.toString(translogId)));
                                indexWriter.commit();
                                this.refresh(new Engine.Refresh("version_table_flush").force(true));
                                this.translog.makeTransientCurrent();
                            }
                            catch (Throwable e) {
                                this.translog.revertTransient();
                                throw new FlushFailedEngineException(this.shardId, e);
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (_ != null) {
                                if (throwable != null) {
                                    try {
                                        _.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    _.close();
                                }
                            }
                        }
                    }
                    if (this.enableGcDeletes) {
                        this.pruneDeletedTombstones();
                    }
                } else if (flush.type() == Engine.Flush.Type.COMMIT) {
                    _ = this.readLock.acquire();
                    throwable = null;
                    try {
                        indexWriter = this.currentIndexWriter();
                        try {
                            long translogId = this.translog.currentId();
                            indexWriter.setCommitData(Collections.singletonMap("translog_id", Long.toString(translogId)));
                            indexWriter.commit();
                        }
                        catch (Throwable e) {
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (_ != null) {
                            if (throwable != null) {
                                try {
                                    _.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                _.close();
                            }
                        }
                    }
                    if (this.enableGcDeletes) {
                        this.pruneDeletedTombstones();
                    }
                } else {
                    throw new ElasticsearchIllegalStateException("flush type [" + (Object)((Object)flush.type()) + "] not supported");
                }
            }
            try {
                _ = this.readLock.acquire();
                throwable = null;
                try {
                    this.ensureOpen();
                    this.readLastCommittedSegmentsInfo();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (_ != null) {
                        if (throwable != null) {
                            try {
                                _.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            _.close();
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!this.closed) {
                    this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                    if (Lucene.isCorruptionException(e)) {
                        throw new FlushFailedEngineException(this.shardId, e);
                    }
                }
            }
        }
        catch (FlushFailedEngineException ex) {
            this.maybeFailEngine(ex, "flush");
            throw ex;
        }
        finally {
            this.flushLock.unlock();
            this.flushing.decrementAndGet();
        }
    }

    private void ensureOpen() {
        if (this.indexWriter == null) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
    }

    private IndexWriter currentIndexWriter() {
        IndexWriter writer = this.indexWriter;
        if (writer == null) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeletedTombstones() {
        long timeMSec = this.threadPool.estimatedTimeInMillis();
        for (Map.Entry<BytesRef, VersionValue> entry : this.versionMap.getAllTombstones()) {
            BytesRef uid = entry.getKey();
            Object object = this.dirtyLock(uid);
            synchronized (object) {
                VersionValue versionValue = this.versionMap.getTombstoneUnderLock(uid);
                if (versionValue != null && timeMSec - versionValue.time() > this.gcDeletesInMillis) {
                    this.versionMap.removeTombstoneUnderLock(uid);
                }
            }
        }
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    @Override
    public void maybeMerge() throws EngineException {
        if (!this.possibleMergeNeeded()) {
            return;
        }
        this.possibleMergeNeeded = false;
        try (InternalLock _ = this.readLock.acquire();){
            this.currentIndexWriter().maybeMerge();
        }
        catch (Throwable t) {
            this.maybeFailEngine(t, "maybe_merge");
            throw new OptimizeFailedEngineException(this.shardId, t);
        }
    }

    private void waitForMerges(boolean flushAfter) {
        try {
            this.currentIndexWriter().waitForMerges();
        }
        catch (IOException e) {
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        if (flushAfter) {
            this.flush(new Engine.Flush().force(true).waitIfOngoing(true));
        }
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws EngineException {
        if (this.optimizeMutex.compareAndSet(false, true)) {
            try (InternalLock _ = this.readLock.acquire();){
                IndexWriter writer = this.currentIndexWriter();
                MergePolicy mp = writer.getConfig().getMergePolicy();
                assert (mp instanceof ElasticsearchMergePolicy) : "MergePolicy is " + mp.getClass().getName();
                if (optimize.upgrade()) {
                    ((ElasticsearchMergePolicy)mp).setUpgradeInProgress(true);
                }
                if (optimize.onlyExpungeDeletes()) {
                    writer.forceMergeDeletes(false);
                } else if (optimize.maxNumSegments() <= 0) {
                    writer.maybeMerge();
                    this.possibleMergeNeeded = false;
                } else {
                    writer.forceMerge(optimize.maxNumSegments(), false);
                }
            }
            catch (Throwable t) {
                this.maybeFailEngine(t, "optimize");
                throw new OptimizeFailedEngineException(this.shardId, t);
            }
            finally {
                this.optimizeMutex.set(false);
            }
        }
        if (optimize.waitForMerge()) {
            this.waitForMerges(optimize.flush());
        } else if (optimize.flush()) {
            this.threadPool.executor("optimize").execute(new AbstractRunnable(){

                @Override
                public void run() {
                    try {
                        InternalEngine.this.waitForMerges(true);
                    }
                    catch (Exception e) {
                        InternalEngine.this.logger.error("Exception while waiting for merges asynchronously after optimize", e, new Object[0]);
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        this.flush(new Engine.Flush().type(Engine.Flush.Type.COMMIT).waitIfOngoing(true));
        try (InternalLock _ = this.readLock.acquire();){
            this.ensureOpen();
            SnapshotIndexCommit snapshotIndexCommit = this.deletionPolicy.snapshot();
            return snapshotIndexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        Translog.Snapshot phase2Snapshot;
        SnapshotIndexCommit phase1Snapshot;
        try (InternalLock _ = this.writeLock.acquire();){
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            this.onGoingRecoveries.startRecovery();
        }
        try {
            phase1Snapshot = this.deletionPolicy.snapshot();
        }
        catch (Throwable e) {
            this.maybeFailEngine(e, "recovery");
            Releasables.closeWhileHandlingException(this.onGoingRecoveries);
            throw new RecoveryEngineException(this.shardId, 1, "Snapshot failed", e);
        }
        try {
            recoveryHandler.phase1(phase1Snapshot);
        }
        catch (Throwable e) {
            this.maybeFailEngine(e, "recovery phase 1");
            Releasables.closeWhileHandlingException(this.onGoingRecoveries, phase1Snapshot);
            throw new RecoveryEngineException(this.shardId, 1, "Execution failed", this.wrapIfClosed(e));
        }
        try {
            phase2Snapshot = this.translog.snapshot();
        }
        catch (Throwable e) {
            this.maybeFailEngine(e, "snapshot recovery");
            Releasables.closeWhileHandlingException(this.onGoingRecoveries, phase1Snapshot);
            throw new RecoveryEngineException(this.shardId, 2, "Snapshot failed", this.wrapIfClosed(e));
        }
        try {
            recoveryHandler.phase2(phase2Snapshot);
        }
        catch (Throwable e) {
            this.maybeFailEngine(e, "recovery phase 2");
            Releasables.closeWhileHandlingException(this.onGoingRecoveries, phase1Snapshot, phase2Snapshot);
            throw new RecoveryEngineException(this.shardId, 2, "Execution failed", this.wrapIfClosed(e));
        }
        this.writeLock.acquire();
        Translog.Snapshot phase3Snapshot = null;
        boolean success = false;
        try {
            phase3Snapshot = this.translog.snapshot(phase2Snapshot);
            recoveryHandler.phase3(phase3Snapshot);
            success = true;
        }
        catch (Throwable e) {
            try {
                this.maybeFailEngine(e, "recovery phase 3");
                throw new RecoveryEngineException(this.shardId, 3, "Execution failed", this.wrapIfClosed(e));
            }
            catch (Throwable throwable) {
                Releasables.close(success, this.onGoingRecoveries, this.writeLock, phase1Snapshot, phase2Snapshot, phase3Snapshot);
                throw throwable;
            }
        }
        Releasables.close(success, this.onGoingRecoveries, this.writeLock, phase1Snapshot, phase2Snapshot, phase3Snapshot);
    }

    private boolean maybeFailEngine(Throwable t, String source) {
        if (Lucene.isCorruptionException(t)) {
            if (this.failEngineOnCorruption) {
                this.failEngine("corrupt file detected source: [" + source + "]", t);
                return true;
            }
            this.logger.warn("corrupt file detected source: [{}] but [{}] is set to [{}]", t, source, INDEX_FAIL_ON_CORRUPTION, this.failEngineOnCorruption);
        } else if (ExceptionsHelper.isOOM(t)) {
            this.failEngine("out of memory", t);
            return true;
        }
        return false;
    }

    private Throwable wrapIfClosed(Throwable t) {
        if (this.closed) {
            return new EngineClosedException(this.shardId, t);
        }
        return t;
    }

    private static long getReaderRamBytesUsed(AtomicReaderContext reader) {
        SegmentReader segmentReader = SegmentReaderUtils.segmentReader(reader.reader());
        return segmentReader.ramBytesUsed();
    }

    /*
     * Exception decompiling
     */
    @Override
    public SegmentsStats segmentsStats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Segment> segments() {
        try (InternalLock _ = this.readLock.acquire();){
            Segment segment;
            this.ensureOpen();
            HashMap<String, Segment> segments = new HashMap<String, Segment>();
            try (Engine.Searcher searcher = this.acquireSearcher("segments");){
                for (AtomicReaderContext reader : searcher.reader().leaves()) {
                    assert (reader.reader() instanceof SegmentReader);
                    SegmentCommitInfo info = SegmentReaderUtils.segmentReader(reader.reader()).getSegmentInfo();
                    assert (!segments.containsKey(info.info.name));
                    segment = new Segment(info.info.name);
                    segment.search = true;
                    segment.docCount = reader.reader().numDocs();
                    segment.delDocCount = reader.reader().numDeletedDocs();
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace("failed to get size for [{}]", e, info.info.name);
                    }
                    segment.memoryInBytes = InternalEngine.getReaderRamBytesUsed(reader);
                    segments.put(info.info.name, segment);
                }
            }
            if (this.lastCommittedSegmentInfos != null) {
                SegmentInfos infos = this.lastCommittedSegmentInfos;
                for (SegmentCommitInfo info : infos) {
                    segment = (Segment)segments.get(info.info.name);
                    if (segment == null) {
                        segment = new Segment(info.info.name);
                        segment.search = false;
                        segment.committed = true;
                        segment.docCount = info.info.getDocCount();
                        segment.delDocCount = info.getDelCount();
                        segment.version = info.info.getVersion();
                        segment.compound = info.info.getUseCompoundFile();
                        try {
                            segment.sizeInBytes = info.sizeInBytes();
                        }
                        catch (IOException e) {
                            this.logger.trace("failed to get size for [{}]", e, info.info.name);
                        }
                        segments.put(info.info.name, segment);
                        continue;
                    }
                    segment.committed = true;
                }
            }
            Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
            Arrays.sort(segmentsArr, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return (int)(o1.getGeneration() - o2.getGeneration());
                }
            });
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block19: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment2 : segmentsArr) {
                        if (!segment2.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment2.mergeId = onGoingMerge.getId();
                        continue block19;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticsearchException {
        block22: {
            try (InternalLock _ = this.writeLock.acquire();){
                if (this.closed) break block22;
                try {
                    this.closed = true;
                    this.indexSettingsService.removeListener(this.applySettings);
                    this.versionMap.clear();
                    this.failedEngineListeners.clear();
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
                    }
                    catch (Throwable t) {
                        this.logger.warn("Failed to close SearcherManager", t, new Object[0]);
                    }
                    if (this.indexWriter != null) {
                        try {
                            this.indexWriter.rollback();
                        }
                        catch (AlreadyClosedException e) {
                            // empty catch block
                        }
                    }
                    this.indexWriter = null;
                    this.store.decRef();
                }
                catch (Throwable e) {
                    try {
                        this.logger.warn("failed to rollback writer on close", e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.indexWriter = null;
                        this.store.decRef();
                    }
                }
            }
        }
    }

    LiveIndexWriterConfig currentIndexWriterConfig() {
        this.ensureOpen();
        return this.indexWriter.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void failEngine(String reason, Throwable failure) {
        assert (failure != null);
        if (this.failEngineLock.tryLock()) {
            block18: {
                try {
                    if (Lucene.isCorruptionException(failure)) {
                        try {
                            this.store.markStoreCorrupted(ExceptionsHelper.unwrap(failure, CorruptIndexException.class));
                        }
                        catch (IOException e) {
                            this.logger.warn("Couldn't marks store corrupted", e, new Object[0]);
                        }
                    }
                    if ($assertionsDisabled || !this.readLock.assertLockIsHeld()) break block18;
                    throw new AssertionError((Object)"readLock is held by a thread that tries to fail the engine");
                }
                catch (Throwable throwable) {
                    assert (!this.readLock.assertLockIsHeld()) : "readLock is held by a thread that tries to fail the engine";
                    if (this.failedEngine != null) {
                        this.logger.debug("tried to fail engine but engine is already failed. ignoring. [{}]", reason, failure);
                        return;
                    }
                    try {
                        this.logger.warn("failed engine [{}]", failure, reason);
                        this.failedEngine = failure;
                        for (Engine.FailedEngineListener listener : this.failedEngineListeners) {
                            listener.onFailedEngine(this.shardId, reason, failure);
                        }
                        throw throwable;
                    }
                    finally {
                        this.close();
                    }
                }
            }
            if (this.failedEngine != null) {
                this.logger.debug("tried to fail engine but engine is already failed. ignoring. [{}]", reason, failure);
                return;
            }
            try {
                this.logger.warn("failed engine [{}]", failure, reason);
                this.failedEngine = failure;
                for (Engine.FailedEngineListener listener : this.failedEngineListeners) {
                    listener.onFailedEngine(this.shardId, reason, failure);
                }
                return;
            }
            finally {
                this.close();
            }
        }
        this.logger.debug("tried to fail engine but could not acquire lock - engine should be failed by now [{}]", reason, failure);
    }

    private Object dirtyLock(BytesRef uid) {
        int hash = DjbHashFunction.DJB_HASH(uid.bytes, uid.offset, uid.length);
        return this.dirtyLocks[MathUtils.mod(hash, this.dirtyLocks.length)];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.bytes());
    }

    private long loadCurrentVersionFromIndex(Term uid) throws IOException {
        try (Engine.Searcher searcher = this.acquireSearcher("load_version");){
            long l = Versions.loadVersion(searcher.reader(), uid);
            return l;
        }
    }

    private static boolean isMergedSegment(AtomicReader reader) {
        Map diagnostics = SegmentReaderUtils.segmentReader((AtomicReader)reader).getSegmentInfo().info.getDiagnostics();
        String source = (String)diagnostics.get("source");
        assert (Arrays.asList("addIndexes(IndexReader...)", "flush", "merge").contains(source)) : "Unknown source " + source;
        return "merge".equals(source);
    }

    private IndexWriter createWriter() throws IOException {
        try {
            if (IndexWriter.isLocked((Directory)this.store.directory())) {
                this.logger.warn("shard is locked, releasing lock", new Object[0]);
                IndexWriter.unlock((Directory)this.store.directory());
            }
            boolean create = !Lucene.indexExists(this.store.directory());
            IndexWriterConfig config = new IndexWriterConfig(Lucene.VERSION, (Analyzer)this.analysisService.defaultIndexAnalyzer());
            config.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            config.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            config.setInfoStream((InfoStream)new LoggerInfoStream(this.indexSettings, this.shardId));
            config.setMergeScheduler(this.mergeScheduler.newMergeScheduler());
            Object mergePolicy = this.mergePolicyProvider.getMergePolicy();
            mergePolicy = new ElasticsearchMergePolicy((MergePolicy)mergePolicy);
            config.setMergePolicy(mergePolicy);
            config.setSimilarity(this.similarityService.similarity());
            config.setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            config.setMaxThreadStates(this.indexConcurrency);
            config.setCodec(this.codecService.codec(this.codecName));
            config.setWriteLockTimeout(5000L);
            config.setUseCompoundFile(this.compoundOnFlush);
            config.setCheckIntegrityAtMerge(this.checksumOnMerge);
            config.setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                public void warm(AtomicReader reader) throws IOException {
                    block5: {
                        try {
                            assert (InternalEngine.isMergedSegment(reader));
                            if (InternalEngine.this.warmer != null) {
                                Engine.SimpleSearcher searcher = new Engine.SimpleSearcher("warmer", new IndexSearcher((IndexReader)reader));
                                IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, searcher);
                                InternalEngine.this.warmer.warmNewReaders(context);
                            }
                        }
                        catch (Throwable t) {
                            if (!InternalEngine.this.closed) {
                                InternalEngine.this.logger.warn("Warm-up failed", t, new Object[0]);
                            }
                            if (!(t instanceof Error)) break block5;
                            throw (Error)t;
                        }
                    }
                }
            });
            return new IndexWriter(this.store.directory(), config);
        }
        catch (LockObtainFailedException ex) {
            boolean isLocked = IndexWriter.isLocked((Directory)this.store.directory());
            this.logger.warn("Could not lock IndexWriter isLocked [{}]", ex, isLocked);
            throw ex;
        }
    }

    private SearcherManager buildSearchManager(IndexWriter indexWriter) throws IOException {
        return new SearcherManager(indexWriter, true, this.searcherFactory);
    }

    private static final class NoOpLock
    implements Lock {
        private NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("NoOpLock can't provide a condition");
        }
    }

    static final class IndexThrottle
    implements MergeSchedulerProvider.Listener {
        private static final InternalLock NOOP_LOCK = new InternalLock(new NoOpLock());
        private final InternalLock lockReference = new InternalLock(new ReentrantLock());
        private final AtomicInteger numMergesInFlight = new AtomicInteger(0);
        private final AtomicBoolean isThrottling = new AtomicBoolean();
        private final MergeSchedulerProvider mergeScheduler;
        private final ESLogger logger;
        private final ShardIndexingService indexingService;
        private volatile InternalLock lock = NOOP_LOCK;

        public IndexThrottle(MergeSchedulerProvider mergeScheduler, ESLogger logger, ShardIndexingService indexingService) {
            this.mergeScheduler = mergeScheduler;
            this.logger = logger;
            this.indexingService = indexingService;
        }

        public Releasable acquireThrottle() {
            return this.lock.acquire();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = this.mergeScheduler.getMaxMerges();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges) {
                if (!this.isThrottling.getAndSet(true)) {
                    this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", this.numMergesInFlight, maxNumMerges);
                    this.indexingService.throttlingActivated();
                }
                this.lock = this.lockReference;
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = this.mergeScheduler.getMaxMerges();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges) {
                if (this.isThrottling.getAndSet(false)) {
                    this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", this.numMergesInFlight, maxNumMerges);
                    this.indexingService.throttlingDeactivated();
                }
                this.lock = NOOP_LOCK;
            }
        }
    }

    private static final class InternalLock
    implements Releasable {
        private final ThreadLocal<AtomicInteger> lockIsHeld;
        private final Lock lock;

        InternalLock(Lock lock) {
            ThreadLocal tl = null;
            assert ((tl = new ThreadLocal()) != null);
            this.lockIsHeld = tl;
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
            assert (this.onAssertRelease());
        }

        InternalLock acquire() throws EngineException {
            this.lock.lock();
            assert (this.onAssertLock());
            return this;
        }

        protected boolean onAssertRelease() {
            AtomicInteger count = this.lockIsHeld.get();
            if (count.decrementAndGet() == 0) {
                this.lockIsHeld.remove();
            }
            return true;
        }

        protected boolean onAssertLock() {
            AtomicInteger count = this.lockIsHeld.get();
            if (count == null) {
                count = new AtomicInteger(0);
                this.lockIsHeld.set(count);
            }
            count.incrementAndGet();
            return true;
        }

        boolean assertLockIsHeld() {
            AtomicInteger count = this.lockIsHeld.get();
            return count != null && count.get() > 0;
        }
    }

    private final class RecoveryCounter
    implements Releasable {
        private final AtomicInteger onGoingRecoveries = new AtomicInteger();

        private RecoveryCounter() {
        }

        public void startRecovery() {
            InternalEngine.this.store.incRef();
            this.onGoingRecoveries.incrementAndGet();
        }

        public int get() {
            return this.onGoingRecoveries.get();
        }

        public void endRecovery() throws ElasticsearchException {
            InternalEngine.this.store.decRef();
            this.onGoingRecoveries.decrementAndGet();
            assert (this.onGoingRecoveries.get() >= 0) : "ongoingRecoveries must be >= 0 but was: " + this.onGoingRecoveries.get();
        }

        @Override
        public void close() throws ElasticsearchException {
            this.endRecovery();
        }
    }

    class SearchFactory
    extends SearcherFactory {
        SearchFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IndexSearcher newSearcher(IndexReader reader) throws IOException {
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setSimilarity(InternalEngine.this.similarityService.similarity());
            if (InternalEngine.this.warmer == null) return searcher;
            IndexSearcher newSearcher = null;
            boolean closeNewSearcher = false;
            try {
                if (InternalEngine.this.searcherManager == null) {
                    newSearcher = searcher;
                } else {
                    try (Engine.Searcher currentSearcher = InternalEngine.this.acquireSearcher("search_factory");){
                        ArrayList<AtomicReader> readers = Lists.newArrayList();
                        for (AtomicReaderContext newReaderContext : searcher.getIndexReader().leaves()) {
                            if (InternalEngine.isMergedSegment(newReaderContext.reader())) continue;
                            boolean found = false;
                            for (AtomicReaderContext currentReaderContext : currentSearcher.reader().leaves()) {
                                if (!currentReaderContext.reader().getCoreCacheKey().equals(newReaderContext.reader().getCoreCacheKey())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            readers.add(newReaderContext.reader());
                        }
                        if (!readers.isEmpty()) {
                            newSearcher = new IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()]), false));
                            closeNewSearcher = true;
                        }
                    }
                }
                if (newSearcher != null) {
                    IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, new Engine.SimpleSearcher("warmer", newSearcher));
                    InternalEngine.this.warmer.warmNewReaders(context);
                }
                InternalEngine.this.warmer.warmTopReader(new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, new Engine.SimpleSearcher("warmer", searcher)));
                if (newSearcher == null || !closeNewSearcher) return searcher;
            }
            catch (Throwable e) {
                try {
                    if (!InternalEngine.this.closed) {
                        InternalEngine.this.logger.warn("failed to prepare/warm", e, new Object[0]);
                    }
                    if (newSearcher == null || !closeNewSearcher) return searcher;
                }
                catch (Throwable throwable) {
                    if (newSearcher == null || !closeNewSearcher) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                return searcher;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
            return searcher;
        }
    }

    class EngineSearcher
    implements Engine.Searcher {
        private final String source;
        private final IndexSearcher searcher;
        private final SearcherManager manager;
        private final AtomicBoolean released = new AtomicBoolean(false);

        private EngineSearcher(String source, IndexSearcher searcher, SearcherManager manager) {
            this.source = source;
            this.searcher = searcher;
            this.manager = manager;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws ElasticsearchException {
            if (!this.released.compareAndSet(false, true)) {
                InternalEngine.this.logger.warn("Searcher was released twice", new ElasticsearchIllegalStateException("Double release"), new Object[0]);
                return;
            }
            try {
                this.manager.release((Object)this.searcher);
            }
            catch (IOException e) {
                throw new ElasticsearchIllegalStateException("Cannot close", e);
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            finally {
                InternalEngine.this.store.decRef();
            }
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean checksumOnMerge;
            boolean compoundOnFlush;
            long gcDeletesInMillis = settings.getAsTime(InternalEngine.INDEX_GC_DELETES, TimeValue.timeValueMillis(InternalEngine.this.gcDeletesInMillis)).millis();
            if (gcDeletesInMillis != InternalEngine.this.gcDeletesInMillis) {
                InternalEngine.this.logger.info("updating index.gc_deletes from [{}] to [{}]", TimeValue.timeValueMillis(InternalEngine.this.gcDeletesInMillis), TimeValue.timeValueMillis(gcDeletesInMillis));
                InternalEngine.this.gcDeletesInMillis = gcDeletesInMillis;
            }
            if ((compoundOnFlush = settings.getAsBoolean(InternalEngine.INDEX_COMPOUND_ON_FLUSH, (Boolean)InternalEngine.this.compoundOnFlush).booleanValue()) != InternalEngine.this.compoundOnFlush) {
                InternalEngine.this.logger.info("updating {} from [{}] to [{}]", InternalEngine.INDEX_COMPOUND_ON_FLUSH, InternalEngine.this.compoundOnFlush, compoundOnFlush);
                InternalEngine.this.compoundOnFlush = compoundOnFlush;
                InternalEngine.this.indexWriter.getConfig().setUseCompoundFile(compoundOnFlush);
            }
            if ((checksumOnMerge = settings.getAsBoolean(InternalEngine.INDEX_CHECKSUM_ON_MERGE, (Boolean)InternalEngine.this.checksumOnMerge).booleanValue()) != InternalEngine.this.checksumOnMerge) {
                InternalEngine.this.logger.info("updating {} from [{}] to [{}]", InternalEngine.INDEX_CHECKSUM_ON_MERGE, InternalEngine.this.checksumOnMerge, checksumOnMerge);
                InternalEngine.this.checksumOnMerge = checksumOnMerge;
                InternalEngine.this.indexWriter.getConfig().setCheckIntegrityAtMerge(checksumOnMerge);
            }
            InternalEngine.this.failEngineOnCorruption = settings.getAsBoolean(InternalEngine.INDEX_FAIL_ON_CORRUPTION, (Boolean)InternalEngine.this.failEngineOnCorruption);
            int indexConcurrency = settings.getAsInt(InternalEngine.INDEX_INDEX_CONCURRENCY, (Integer)InternalEngine.this.indexConcurrency);
            boolean failOnMergeFailure = settings.getAsBoolean(InternalEngine.INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)InternalEngine.this.failOnMergeFailure);
            String codecName = settings.get("index.codec", InternalEngine.this.codecName);
            boolean codecBloomLoad = settings.getAsBoolean("index.codec.bloom.load", (Boolean)InternalEngine.this.codecService.isLoadBloomFilter());
            boolean requiresFlushing = false;
            if (indexConcurrency != InternalEngine.this.indexConcurrency || !codecName.equals(InternalEngine.this.codecName) || failOnMergeFailure != InternalEngine.this.failOnMergeFailure || codecBloomLoad != InternalEngine.this.codecService.isLoadBloomFilter()) {
                try (InternalLock _ = InternalEngine.this.readLock.acquire();){
                    if (indexConcurrency != InternalEngine.this.indexConcurrency) {
                        InternalEngine.this.logger.info("updating index.index_concurrency from [{}] to [{}]", InternalEngine.this.indexConcurrency, indexConcurrency);
                        InternalEngine.this.indexConcurrency = indexConcurrency;
                        requiresFlushing = true;
                    }
                    if (!codecName.equals(InternalEngine.this.codecName)) {
                        InternalEngine.this.logger.info("updating index.codec from [{}] to [{}]", InternalEngine.this.codecName, codecName);
                        InternalEngine.this.codecName = codecName;
                        requiresFlushing = true;
                    }
                    if (failOnMergeFailure != InternalEngine.this.failOnMergeFailure) {
                        InternalEngine.this.logger.info("updating {} from [{}] to [{}]", InternalEngine.INDEX_FAIL_ON_MERGE_FAILURE, InternalEngine.this.failOnMergeFailure, failOnMergeFailure);
                        InternalEngine.this.failOnMergeFailure = failOnMergeFailure;
                    }
                    if (codecBloomLoad != InternalEngine.this.codecService.isLoadBloomFilter()) {
                        InternalEngine.this.logger.info("updating {} from [{}] to [{}]", "index.codec.bloom.load", InternalEngine.this.codecService.isLoadBloomFilter(), codecBloomLoad);
                        InternalEngine.this.codecService.setLoadBloomFilter(codecBloomLoad);
                        requiresFlushing = true;
                    }
                }
                if (requiresFlushing) {
                    InternalEngine.this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
            }
        }
    }

    class FailEngineOnMergeFailure
    implements MergeSchedulerProvider.FailureListener {
        FailEngineOnMergeFailure() {
        }

        @Override
        public void onFailedMerge(MergePolicy.MergeException e) {
            if (Lucene.isCorruptionException((Throwable)e)) {
                if (InternalEngine.this.failEngineOnCorruption) {
                    InternalEngine.this.failEngine("corrupt file detected source: [merge]", (Throwable)e);
                } else {
                    InternalEngine.this.logger.warn("corrupt file detected source: [merge] but [{}] is set to [{}]", (Throwable)e, InternalEngine.INDEX_FAIL_ON_CORRUPTION, InternalEngine.this.failEngineOnCorruption);
                }
            } else {
                InternalEngine.this.failEngine("merge exception", (Throwable)e);
            }
        }
    }
}

