/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.transport.TransportAddress;

public class LocalTransportAddress
implements TransportAddress {
    private String id;

    LocalTransportAddress() {
    }

    public LocalTransportAddress(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    @Override
    public short uniqueAddressTypeId() {
        return 2;
    }

    @Override
    public boolean sameHost(TransportAddress other) {
        return other instanceof LocalTransportAddress && this.id.equals(((LocalTransportAddress)other).id);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransportAddress that = (LocalTransportAddress)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "local[" + this.id + "]";
    }
}

