/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.script.SearchScript;

public class ScriptScoreFunction
extends ScoreFunction {
    private final String sScript;
    private final Map<String, Object> params;
    private final CannedScorer scorer;
    private final SearchScript script;

    public ScriptScoreFunction(String sScript, Map<String, Object> params, SearchScript script) {
        super(CombineFunction.REPLACE);
        this.sScript = sScript;
        this.params = params;
        this.script = script;
        this.scorer = new CannedScorer();
        script.setScorer(this.scorer);
    }

    @Override
    public void setNextReader(AtomicReaderContext ctx) {
        this.script.setNextReader(ctx);
    }

    @Override
    public double score(int docId, float subQueryScore) {
        this.script.setNextDocId(docId);
        this.scorer.docid = docId;
        this.scorer.score = subQueryScore;
        return this.script.runAsDouble();
    }

    @Override
    public Explanation explainScore(int docId, float subQueryScore) {
        double score = this.score(docId, subQueryScore);
        String explanation = "script score function, computed with script:\"" + this.sScript;
        if (this.params != null) {
            explanation = explanation + "\" and parameters: \n" + this.params.toString();
        }
        Explanation exp = new Explanation(CombineFunction.toFloat(score), explanation);
        return exp;
    }

    public String toString() {
        return "script[" + this.sScript + "], params [" + this.params + "]";
    }

    static final class CannedScorer
    extends Scorer {
        protected int docid;
        protected float score;

        public CannedScorer() {
            super(null);
        }

        public int docID() {
            return this.docid;
        }

        public float score() throws IOException {
            return this.score;
        }

        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            return 1L;
        }
    }
}

