/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.lucene.all.AllTokenStream;

public class AllField
extends Field {
    private final AllEntries allEntries;
    private final Analyzer analyzer;

    public AllField(String name, AllEntries allEntries, Analyzer analyzer, FieldType fieldType) {
        super(name, fieldType);
        this.allEntries = allEntries;
        this.analyzer = analyzer;
    }

    public String stringValue() {
        if (this.fieldType().stored()) {
            return this.allEntries.buildText();
        }
        return null;
    }

    public Reader readerValue() {
        return null;
    }

    public AllEntries getAllEntries() {
        return this.allEntries;
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) throws IOException {
        try {
            this.allEntries.reset();
            if (this.allEntries.customBoost() && this.fieldType().indexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                return AllTokenStream.allTokenStream(this.name, this.allEntries, analyzer);
            }
            return analyzer.tokenStream(this.name, (Reader)this.allEntries);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create token stream");
        }
    }
}

