/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.EnvelopeBuilder;
import org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiPointBuilder;
import org.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public abstract class ShapeBuilder
implements ToXContent {
    protected static final ESLogger LOGGER = ESLoggerFactory.getLogger(ShapeBuilder.class.getName());
    private static final boolean DEBUG;
    public static final double DATELINE = 180.0;
    public static final JtsSpatialContext SPATIAL_CONTEXT;
    public static final GeometryFactory FACTORY;
    protected final boolean wrapdateline = SPATIAL_CONTEXT.isGeo();
    protected final boolean multiPolygonMayOverlap = false;
    protected final boolean autoValidateJtsGeometry = true;
    protected final boolean autoIndexJtsGeometry = true;
    protected static final IntersectionOrder INTERSECTION_ORDER;
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_COORDINATES = "coordinates";
    public static final String FIELD_GEOMETRIES = "geometries";

    protected ShapeBuilder() {
    }

    protected static Coordinate coordinate(double longitude, double latitude) {
        return new Coordinate(longitude, latitude);
    }

    protected JtsGeometry jtsGeometry(Geometry geom) {
        JtsGeometry jtsGeometry = new JtsGeometry(geom, SPATIAL_CONTEXT, false, false);
        jtsGeometry.validate();
        jtsGeometry.index();
        return jtsGeometry;
    }

    public static PointBuilder newPoint(double longitude, double latitude) {
        return ShapeBuilder.newPoint(new Coordinate(longitude, latitude));
    }

    public static PointBuilder newPoint(Coordinate coordinate) {
        return new PointBuilder().coordinate(coordinate);
    }

    public static MultiPointBuilder newMultiPoint() {
        return new MultiPointBuilder();
    }

    public static LineStringBuilder newLineString() {
        return new LineStringBuilder();
    }

    public static MultiLineStringBuilder newMultiLinestring() {
        return new MultiLineStringBuilder();
    }

    public static PolygonBuilder newPolygon() {
        return new PolygonBuilder();
    }

    public static MultiPolygonBuilder newMultiPolygon() {
        return new MultiPolygonBuilder();
    }

    public static GeometryCollectionBuilder newGeometryCollection() {
        return new GeometryCollectionBuilder();
    }

    public static CircleBuilder newCircleBuilder() {
        return new CircleBuilder();
    }

    public static EnvelopeBuilder newEnvelope() {
        return new EnvelopeBuilder();
    }

    public String toString() {
        try {
            XContentBuilder xcontent = JsonXContent.contentBuilder();
            return this.toXContent(xcontent, EMPTY_PARAMS).prettyPrint().string();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public abstract Shape build();

    private static CoordinateNode parseCoordinates(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY) {
            double lon = parser.doubleValue();
            token = parser.nextToken();
            double lat = parser.doubleValue();
            token = parser.nextToken();
            return new CoordinateNode(new Coordinate(lon, lat));
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            nodes.add(ShapeBuilder.parseCoordinates(parser));
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    public static ShapeBuilder parse(XContentParser parser) throws IOException {
        return GeoShapeType.parse(parser);
    }

    protected static XContentBuilder toXContent(XContentBuilder builder, Coordinate coordinate) throws IOException {
        return builder.startArray().value(coordinate.x).value(coordinate.y).endArray();
    }

    protected static Coordinate shift(Coordinate coordinate, double dateline) {
        if (dateline == 0.0) {
            return coordinate;
        }
        return new Coordinate(-2.0 * dateline + coordinate.x, coordinate.y);
    }

    public abstract GeoShapeType type();

    protected static final double intersection(Coordinate p1, Coordinate p2, double dateline) {
        if (p1.x == p2.x) {
            return Double.NaN;
        }
        double t = (dateline - p1.x) / (p2.x - p1.x);
        if (t > 1.0 || t <= 0.0) {
            return Double.NaN;
        }
        return t;
    }

    protected static int intersections(double dateline, Edge[] edges) {
        int numIntersections = 0;
        assert (!Double.isNaN(dateline));
        for (int i = 0; i < edges.length; ++i) {
            Coordinate p1 = edges[i].coordinate;
            Coordinate p2 = edges[i].next.coordinate;
            assert (!Double.isNaN(p2.x) && !Double.isNaN(p1.x));
            edges[i].intersect = IntersectionOrder.SENTINEL;
            double position = ShapeBuilder.intersection(p1, p2, dateline);
            if (Double.isNaN(position)) continue;
            edges[i].intersection(position);
            ++numIntersections;
        }
        Arrays.sort(edges, INTERSECTION_ORDER);
        return numIntersections;
    }

    protected static final boolean debugEnabled() {
        return LOGGER.isDebugEnabled() || DEBUG;
    }

    static {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        DEBUG = debug;
        SPATIAL_CONTEXT = JtsSpatialContext.GEO;
        FACTORY = SPATIAL_CONTEXT.getGeometryFactory();
        INTERSECTION_ORDER = new IntersectionOrder();
    }

    public static enum GeoShapeType {
        POINT("point"),
        MULTIPOINT("multipoint"),
        LINESTRING("linestring"),
        MULTILINESTRING("multilinestring"),
        POLYGON("polygon"),
        MULTIPOLYGON("multipolygon"),
        GEOMETRYCOLLECTION("geometrycollection"),
        ENVELOPE("envelope"),
        CIRCLE("circle");

        protected final String shapename;

        private GeoShapeType(String shapename) {
            this.shapename = shapename;
        }

        public static GeoShapeType forName(String geoshapename) {
            String typename = geoshapename.toLowerCase(Locale.ROOT);
            for (GeoShapeType type : GeoShapeType.values()) {
                if (!type.shapename.equals(typename)) continue;
                return type;
            }
            throw new ElasticsearchIllegalArgumentException("unknown geo_shape [" + geoshapename + "]");
        }

        public static ShapeBuilder parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("Shape must be an object consisting of type and coordinates");
            }
            Enum shapeType = null;
            DistanceUnit.Distance radius = null;
            CoordinateNode node = null;
            GeometryCollectionBuilder geometryCollections = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String fieldName = parser.currentName();
                if (ShapeBuilder.FIELD_TYPE.equals(fieldName)) {
                    parser.nextToken();
                    shapeType = GeoShapeType.forName(parser.text());
                    continue;
                }
                if (ShapeBuilder.FIELD_COORDINATES.equals(fieldName)) {
                    parser.nextToken();
                    node = ShapeBuilder.parseCoordinates(parser);
                    continue;
                }
                if (ShapeBuilder.FIELD_GEOMETRIES.equals(fieldName)) {
                    parser.nextToken();
                    geometryCollections = GeoShapeType.parseGeometries(parser);
                    continue;
                }
                if ("radius".equals(fieldName)) {
                    parser.nextToken();
                    radius = DistanceUnit.Distance.parseDistance(parser.text());
                    continue;
                }
                parser.nextToken();
                parser.skipChildren();
            }
            if (shapeType == null) {
                throw new ElasticsearchParseException("Shape type not included");
            }
            if (node == null && GEOMETRYCOLLECTION != shapeType) {
                throw new ElasticsearchParseException("Coordinates not included");
            }
            if (geometryCollections == null && GEOMETRYCOLLECTION == shapeType) {
                throw new ElasticsearchParseException("geometries not included");
            }
            if (radius != null && CIRCLE != shapeType) {
                throw new ElasticsearchParseException("Field [radius] is supported for [" + (Object)((Object)CircleBuilder.TYPE) + "] only");
            }
            switch (1.$SwitchMap$org$elasticsearch$common$geo$builders$ShapeBuilder$GeoShapeType[shapeType.ordinal()]) {
                case 1: {
                    return GeoShapeType.parsePoint(node);
                }
                case 2: {
                    return GeoShapeType.parseMultiPoint(node);
                }
                case 3: {
                    return GeoShapeType.parseLineString(node);
                }
                case 4: {
                    return GeoShapeType.parseMultiLine(node);
                }
                case 5: {
                    return GeoShapeType.parsePolygon(node);
                }
                case 6: {
                    return GeoShapeType.parseMultiPolygon(node);
                }
                case 7: {
                    return GeoShapeType.parseCircle(node, radius);
                }
                case 8: {
                    return GeoShapeType.parseEnvelope(node);
                }
                case 9: {
                    return geometryCollections;
                }
            }
            throw new ElasticsearchParseException("Shape type [" + shapeType + "] not included");
        }

        protected static PointBuilder parsePoint(CoordinateNode node) {
            return ShapeBuilder.newPoint(node.coordinate);
        }

        protected static CircleBuilder parseCircle(CoordinateNode coordinates, DistanceUnit.Distance radius) {
            return ShapeBuilder.newCircleBuilder().center(coordinates.coordinate).radius(radius);
        }

        protected static EnvelopeBuilder parseEnvelope(CoordinateNode coordinates) {
            return ShapeBuilder.newEnvelope().topLeft(coordinates.children.get((int)0).coordinate).bottomRight(coordinates.children.get((int)1).coordinate);
        }

        protected static MultiPointBuilder parseMultiPoint(CoordinateNode coordinates) {
            MultiPointBuilder points = new MultiPointBuilder();
            for (CoordinateNode node : coordinates.children) {
                points.point(node.coordinate);
            }
            return points;
        }

        protected static LineStringBuilder parseLineString(CoordinateNode coordinates) {
            LineStringBuilder line = ShapeBuilder.newLineString();
            for (CoordinateNode node : coordinates.children) {
                line.point(node.coordinate);
            }
            return line;
        }

        protected static MultiLineStringBuilder parseMultiLine(CoordinateNode coordinates) {
            MultiLineStringBuilder multiline = ShapeBuilder.newMultiLinestring();
            for (CoordinateNode node : coordinates.children) {
                multiline.linestring(GeoShapeType.parseLineString(node));
            }
            return multiline;
        }

        protected static PolygonBuilder parsePolygon(CoordinateNode coordinates) {
            LineStringBuilder shell = GeoShapeType.parseLineString(coordinates.children.get(0));
            PolygonBuilder polygon = new PolygonBuilder(shell.points);
            for (int i = 1; i < coordinates.children.size(); ++i) {
                polygon.hole(GeoShapeType.parseLineString(coordinates.children.get(i)));
            }
            return polygon;
        }

        protected static MultiPolygonBuilder parseMultiPolygon(CoordinateNode coordinates) {
            MultiPolygonBuilder polygons = ShapeBuilder.newMultiPolygon();
            for (CoordinateNode node : coordinates.children) {
                polygons.polygon(GeoShapeType.parsePolygon(node));
            }
            return polygons;
        }

        protected static GeometryCollectionBuilder parseGeometries(XContentParser parser) throws IOException {
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("Geometries must be an array of geojson objects");
            }
            XContentParser.Token token = parser.nextToken();
            GeometryCollectionBuilder geometryCollection = ShapeBuilder.newGeometryCollection();
            while (token != XContentParser.Token.END_ARRAY) {
                ShapeBuilder shapeBuilder = GeoShapeType.parse(parser);
                geometryCollection.shape(shapeBuilder);
                token = parser.nextToken();
            }
            return geometryCollection;
        }
    }

    private static final class IntersectionOrder
    implements Comparator<Edge> {
        private static final Coordinate SENTINEL = new Coordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

        private IntersectionOrder() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            return Double.compare(o1.intersect.y, o2.intersect.y);
        }
    }

    protected static final class Edge {
        Coordinate coordinate;
        Edge next;
        Coordinate intersect;
        int component = -1;

        protected Edge(Coordinate coordinate, Edge next, Coordinate intersection) {
            this.coordinate = coordinate;
            this.next = next;
            this.intersect = intersection;
            if (next != null) {
                this.component = next.component;
            }
        }

        protected Edge(Coordinate coordinate, Edge next) {
            this(coordinate, next, IntersectionOrder.SENTINEL);
        }

        private static final int top(Coordinate[] points, int offset, int length) {
            int top = 0;
            for (int i = 1; i < length; ++i) {
                if (points[offset + i].y < points[offset + top].y) {
                    top = i;
                    continue;
                }
                if (points[offset + i].y != points[offset + top].y || !(points[offset + i].x < points[offset + top].x)) continue;
                top = i;
            }
            return top;
        }

        private static Edge[] concat(int component, boolean direction, Coordinate[] points, int pointOffset, Edge[] edges, int edgeOffset, int length) {
            assert (edges.length >= length + edgeOffset);
            assert (points.length >= length + pointOffset);
            edges[edgeOffset] = new Edge(points[pointOffset], null);
            for (int i = 1; i < length; ++i) {
                if (direction) {
                    edges[edgeOffset + i] = new Edge(points[pointOffset + i], edges[edgeOffset + i - 1]);
                    edges[edgeOffset + i].component = component;
                    continue;
                }
                Edge edge = new Edge(points[pointOffset + i], null);
                edges[edgeOffset + i] = edge;
                edges[edgeOffset + i - 1].next = edge;
                edges[edgeOffset + i - 1].component = component;
            }
            if (direction) {
                edges[edgeOffset].next = edges[edgeOffset + length - 1];
                edges[edgeOffset].component = component;
            } else {
                edges[edgeOffset + length - 1].next = edges[edgeOffset];
                edges[edgeOffset + length - 1].component = component;
            }
            return edges;
        }

        protected static Edge[] ring(int component, boolean direction, Coordinate[] points, int offset, Edge[] edges, int toffset, int length) {
            int top = Edge.top(points, offset, length);
            int prev = offset + (top + length - 1) % length;
            int next = offset + (top + 1) % length;
            boolean orientation = points[offset + prev].x > points[offset + next].x;
            return Edge.concat(component, direction ^ orientation, points, offset, edges, toffset, length);
        }

        protected Coordinate intersection(double position) {
            this.intersect = Edge.position(this.coordinate, this.next.coordinate, position);
            return this.intersect;
        }

        public static Coordinate position(Coordinate p1, Coordinate p2, double position) {
            if (position == 0.0) {
                return p1;
            }
            if (position == 1.0) {
                return p2;
            }
            double x = p1.x + position * (p2.x - p1.x);
            double y = p1.y + position * (p2.y - p1.y);
            return new Coordinate(x, y);
        }

        public String toString() {
            return "Edge[Component=" + this.component + "; start=" + this.coordinate + " " + "; intersection=" + this.intersect + "]";
        }
    }

    protected static class CoordinateNode
    implements ToXContent {
        protected final Coordinate coordinate;
        protected final List<CoordinateNode> children;

        protected CoordinateNode(Coordinate coordinate) {
            this.coordinate = coordinate;
            this.children = null;
        }

        protected CoordinateNode(List<CoordinateNode> children) {
            this.children = children;
            this.coordinate = null;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.children == null) {
                builder.startArray().value(this.coordinate.x).value(this.coordinate.y).endArray();
            } else {
                builder.startArray();
                for (CoordinateNode child : this.children) {
                    child.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }
    }
}

