/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateFilter;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.metadata.MetaDataService;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataCreateIndexService
extends AbstractComponent {
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private static final DefaultIndexTemplateFilter DEFAULT_INDEX_TEMPLATE_FILTER = new DefaultIndexTemplateFilter();
    private final Environment environment;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final MetaDataService metaDataService;
    private final Version version;
    private final String riverIndexName;
    private final AliasValidator aliasValidator;
    private final IndexTemplateFilter indexTemplateFilter;

    @Inject
    public MetaDataCreateIndexService(Settings settings, Environment environment, ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, MetaDataService metaDataService, Version version, @RiverIndexName String riverIndexName, AliasValidator aliasValidator, Set<IndexTemplateFilter> indexTemplateFilters) {
        super(settings);
        this.environment = environment;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.metaDataService = metaDataService;
        this.version = version;
        this.riverIndexName = riverIndexName;
        this.aliasValidator = aliasValidator;
        if (indexTemplateFilters.isEmpty()) {
            this.indexTemplateFilter = DEFAULT_INDEX_TEMPLATE_FILTER;
        } else {
            IndexTemplateFilter[] templateFilters = new IndexTemplateFilter[indexTemplateFilters.size() + 1];
            templateFilters[0] = DEFAULT_INDEX_TEMPLATE_FILTER;
            int i = 1;
            for (IndexTemplateFilter indexTemplateFilter : indexTemplateFilters) {
                templateFilters[i++] = indexTemplateFilter;
            }
            this.indexTemplateFilter = new IndexTemplateFilter.Compound(templateFilters);
        }
    }

    public void createIndex(final CreateIndexClusterStateUpdateRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        final Semaphore mdLock = this.metaDataService.indexMetaDataLock(request.index());
        if (mdLock.tryAcquire()) {
            this.createIndex(request, listener, mdLock);
            return;
        }
        try {
            this.threadPool.executor("management").execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!mdLock.tryAcquire(request.masterNodeTimeout().nanos(), TimeUnit.NANOSECONDS)) {
                            listener.onFailure(new ProcessClusterEventTimeoutException(request.masterNodeTimeout(), "acquire index lock"));
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        listener.onFailure(e);
                        return;
                    }
                    MetaDataCreateIndexService.this.createIndex(request, listener, mdLock);
                }
            });
        }
        catch (EsRejectedExecutionException ex) {
            listener.onFailure(ex);
        }
    }

    public void validateIndexName(String index, ClusterState state) throws ElasticsearchException {
        if (state.routingTable().hasIndex(index)) {
            throw new IndexAlreadyExistsException(new Index(index));
        }
        if (state.metaData().hasIndex(index)) {
            throw new IndexAlreadyExistsException(new Index(index));
        }
        if (!Strings.validFileName(index)) {
            throw new InvalidIndexNameException(new Index(index), index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw new InvalidIndexNameException(new Index(index), index, "must not contain '#'");
        }
        if (!index.equals(this.riverIndexName) && index.charAt(0) == '_') {
            throw new InvalidIndexNameException(new Index(index), index, "must not start with '_'");
        }
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(new Index(index), index, "must be lowercase");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", e);
        }
        if (byteCount > 255) {
            throw new InvalidIndexNameException(new Index(index), index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (state.metaData().aliases().containsKey(index)) {
            throw new InvalidIndexNameException(new Index(index), index, "already exists as alias");
        }
    }

    private void createIndex(final CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener, final Semaphore mdLock) {
        ImmutableSettings.Builder updatedSettingsBuilder = ImmutableSettings.settingsBuilder();
        for (Map.Entry entry : request.settings().getAsMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith("index.")) {
                updatedSettingsBuilder.put("index." + (String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            updatedSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        request.settings(updatedSettingsBuilder.build());
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", Priority.URGENT, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                mdLock.release();
                super.onAllNodesAcked(t);
            }

            @Override
            public void onAckTimeout() {
                mdLock.release();
                super.onAckTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                mdLock.release();
                super.onFailure(source, t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState;
                block49: {
                    boolean indexCreated = false;
                    String failureReason = null;
                    try {
                        IndexMetaData indexMetaData;
                        MetaDataCreateIndexService.this.validate(request, currentState);
                        for (Alias alias : request.aliases()) {
                            MetaDataCreateIndexService.this.aliasValidator.validateAlias(alias, request.index(), currentState.metaData());
                        }
                        List templates = MetaDataCreateIndexService.this.findTemplates(request, currentState, MetaDataCreateIndexService.this.indexTemplateFilter);
                        HashMap<String, Object> customs = Maps.newHashMap();
                        HashMap<String, Map> mappings = Maps.newHashMap();
                        HashMap<String, AliasMetaData> templatesAliases = Maps.newHashMap();
                        for (Map.Entry<String, String> entry : request.mappings().entrySet()) {
                            mappings.put(entry.getKey(), MetaDataCreateIndexService.this.parseMapping(entry.getValue()));
                        }
                        for (Map.Entry<String, Object> entry : request.customs().entrySet()) {
                            customs.put(entry.getKey(), entry.getValue());
                        }
                        for (IndexTemplateMetaData indexTemplateMetaData : templates) {
                            for (ObjectObjectCursor<String, CompressedString> objectObjectCursor : indexTemplateMetaData.mappings()) {
                                if (mappings.containsKey(objectObjectCursor.key)) {
                                    XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MetaDataCreateIndexService.this.parseMapping(((CompressedString)objectObjectCursor.value).string()));
                                    continue;
                                }
                                mappings.put((String)objectObjectCursor.key, MetaDataCreateIndexService.this.parseMapping(((CompressedString)objectObjectCursor.value).string()));
                            }
                            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexTemplateMetaData.customs()) {
                                String type = (String)objectObjectCursor.key;
                                IndexMetaData.Custom custom = (IndexMetaData.Custom)objectObjectCursor.value;
                                IndexMetaData.Custom existing = (IndexMetaData.Custom)customs.get(type);
                                if (existing == null) {
                                    customs.put(type, custom);
                                    continue;
                                }
                                IndexMetaData.Custom merged = IndexMetaData.lookupFactorySafe(type).merge(existing, custom);
                                customs.put(type, merged);
                            }
                            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexTemplateMetaData.aliases()) {
                                AliasMetaData aliasMetaData = (AliasMetaData)objectObjectCursor.value;
                                if (request.aliases().contains(new Alias(aliasMetaData.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                                if (aliasMetaData.alias().contains("{index}")) {
                                    String templatedAlias = aliasMetaData.alias().replace("{index}", request.index());
                                    aliasMetaData = AliasMetaData.newAliasMetaData(aliasMetaData, templatedAlias);
                                }
                                MetaDataCreateIndexService.this.aliasValidator.validateAliasMetaData(aliasMetaData, request.index(), currentState.metaData());
                                templatesAliases.put(aliasMetaData.alias(), aliasMetaData);
                            }
                        }
                        File mappingsDir = new File(MetaDataCreateIndexService.this.environment.configFile(), "mappings");
                        if (mappingsDir.exists() && mappingsDir.isDirectory()) {
                            File defaultMappingsDir;
                            File file = new File(mappingsDir, request.index());
                            if (file.exists() && file.isDirectory()) {
                                MetaDataCreateIndexService.this.addMappings(mappings, file);
                            }
                            if ((defaultMappingsDir = new File(mappingsDir, "_default")).exists() && defaultMappingsDir.isDirectory()) {
                                MetaDataCreateIndexService.this.addMappings(mappings, defaultMappingsDir);
                            }
                        }
                        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
                        for (int i = templates.size() - 1; i >= 0; --i) {
                            builder.put(((IndexTemplateMetaData)templates.get(i)).settings());
                        }
                        builder.put(request.settings());
                        if (request.index().equals(".scripts")) {
                            builder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)1));
                        } else if (builder.get("index.number_of_shards") == null) {
                            if (request.index().equals(MetaDataCreateIndexService.this.riverIndexName)) {
                                builder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)1));
                            } else {
                                builder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)5));
                            }
                        }
                        if (request.index().equals(".scripts")) {
                            builder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)0));
                            builder.put("index.auto_expand_replicas", "0-all");
                        } else if (builder.get("index.number_of_replicas") == null) {
                            if (request.index().equals(MetaDataCreateIndexService.this.riverIndexName)) {
                                builder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)1));
                            } else {
                                builder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)1));
                            }
                        }
                        if (MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas") != null && builder.get("index.auto_expand_replicas") == null) {
                            builder.put("index.auto_expand_replicas", MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas"));
                        }
                        if (builder.get("index.version.created") == null) {
                            DiscoveryNodes nodes = currentState.nodes();
                            Version version = Version.smallest(MetaDataCreateIndexService.this.version, nodes.smallestNonClientNodeVersion());
                            builder.put("index.version.created", version);
                        }
                        if (builder.get("index.creation_date") == null) {
                            builder.put("index.creation_date", System.currentTimeMillis());
                        }
                        builder.put("index.uuid", Strings.randomBase64UUID());
                        Settings actualIndexSettings = builder.build();
                        MetaDataCreateIndexService.this.indicesService.createIndex(request.index(), actualIndexSettings, MetaDataCreateIndexService.this.clusterService.localNode().id());
                        indexCreated = true;
                        IndexService indexService = MetaDataCreateIndexService.this.indicesService.indexServiceSafe(request.index());
                        MapperService mapperService = indexService.mapperService();
                        if (mappings.containsKey("_default_")) {
                            try {
                                mapperService.merge("_default_", new CompressedString(XContentFactory.jsonBuilder().map((Map)mappings.get("_default_")).string()), false);
                            }
                            catch (Exception e) {
                                failureReason = "failed on parsing default mapping on index creation";
                                throw new MapperParsingException("mapping [_default_]", e);
                            }
                        }
                        for (Map.Entry entry : mappings.entrySet()) {
                            if (((String)entry.getKey()).equals("_default_")) continue;
                            try {
                                mapperService.merge((String)entry.getKey(), new CompressedString(XContentFactory.jsonBuilder().map((Map)entry.getValue()).string()), true);
                            }
                            catch (Exception e) {
                                failureReason = "failed on parsing mappings on index creation";
                                throw new MapperParsingException("mapping [" + (String)entry.getKey() + "]", e);
                            }
                        }
                        IndexQueryParserService indexQueryParserService = indexService.queryParserService();
                        for (Alias alias : request.aliases()) {
                            if (!Strings.hasLength(alias.filter())) continue;
                            MetaDataCreateIndexService.this.aliasValidator.validateAliasFilter(alias.name(), alias.filter(), indexQueryParserService);
                        }
                        for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                            if (aliasMetaData.filter() == null) continue;
                            MetaDataCreateIndexService.this.aliasValidator.validateAliasFilter(aliasMetaData.alias(), aliasMetaData.filter().uncompressed(), indexQueryParserService);
                        }
                        HashMap<String, MappingMetaData> mappingsMetaData = Maps.newHashMap();
                        for (DocumentMapper mapper : mapperService.docMappers(true)) {
                            MappingMetaData mappingMetaData = new MappingMetaData(mapper);
                            mappingsMetaData.put(mapper.type(), mappingMetaData);
                        }
                        IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(request.index()).settings(actualIndexSettings);
                        for (MappingMetaData mappingMetaData : mappingsMetaData.values()) {
                            indexMetaDataBuilder.putMapping(mappingMetaData);
                        }
                        for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                            indexMetaDataBuilder.putAlias(aliasMetaData);
                        }
                        for (Alias alias : request.aliases()) {
                            AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).build();
                            indexMetaDataBuilder.putAlias(aliasMetaData);
                        }
                        for (Map.Entry entry : customs.entrySet()) {
                            indexMetaDataBuilder.putCustom((String)entry.getKey(), (IndexMetaData.Custom)entry.getValue());
                        }
                        indexMetaDataBuilder.state(request.state());
                        try {
                            indexMetaData = indexMetaDataBuilder.build();
                        }
                        catch (Exception exception) {
                            failureReason = "failed to build index metadata";
                            throw exception;
                        }
                        MetaData metaData = MetaData.builder(currentState.metaData()).put(indexMetaData, false).build();
                        MetaDataCreateIndexService.this.logger.info("[{}] creating index, cause [{}], shards [{}]/[{}], mappings {}", request.index(), request.cause(), indexMetaData.numberOfShards(), indexMetaData.numberOfReplicas(), mappings.keySet());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                        if (!request.blocks().isEmpty()) {
                            for (ClusterBlock block : request.blocks()) {
                                blocks.addIndexBlock(request.index(), block);
                            }
                        }
                        if (request.state() == IndexMetaData.State.CLOSE) {
                            blocks.addIndexBlock(request.index(), MetaDataIndexStateService.INDEX_CLOSED_BLOCK);
                        }
                        ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(metaData).build();
                        if (request.state() == IndexMetaData.State.OPEN) {
                            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metaData().index(request.index()));
                            RoutingAllocation.Result routingResult = MetaDataCreateIndexService.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder).build());
                            updatedState = ClusterState.builder(updatedState).routingResult(routingResult).build();
                        }
                        clusterState = updatedState;
                        if (!indexCreated) break block49;
                    }
                    catch (Throwable throwable) {
                        if (indexCreated) {
                            MetaDataCreateIndexService.this.indicesService.removeIndex(request.index(), failureReason != null ? failureReason : "failed to create index");
                        }
                        throw throwable;
                    }
                    MetaDataCreateIndexService.this.indicesService.removeIndex(request.index(), failureReason != null ? failureReason : "failed to create index");
                }
                return clusterState;
            }
        });
    }

    private Map<String, Object> parseMapping(String mappingSource) throws Exception {
        return XContentFactory.xContent(mappingSource).createParser(mappingSource).mapAndClose();
    }

    private void addMappings(Map<String, Map<String, Object>> mappings, File mappingsDir) {
        File[] mappingsFiles;
        for (File mappingFile : mappingsFiles = mappingsDir.listFiles()) {
            if (mappingFile.isHidden()) continue;
            int lastDotIndex = mappingFile.getName().lastIndexOf(46);
            String mappingType = lastDotIndex != -1 ? mappingFile.getName().substring(0, lastDotIndex) : mappingFile.getName();
            try {
                String mappingSource = Streams.copyToString(new InputStreamReader((InputStream)new FileInputStream(mappingFile), Charsets.UTF_8));
                if (mappings.containsKey(mappingType)) {
                    XContentHelper.mergeDefaults(mappings.get(mappingType), this.parseMapping(mappingSource));
                    continue;
                }
                mappings.put(mappingType, this.parseMapping(mappingSource));
            }
            catch (Exception e) {
                this.logger.warn("failed to read / parse mapping [" + mappingType + "] from location [" + mappingFile + "], ignoring...", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexTemplateMetaData> findTemplates(CreateIndexClusterStateUpdateRequest request, ClusterState state, IndexTemplateFilter indexTemplateFilter) {
        File[] fileArray;
        ArrayList<IndexTemplateMetaData> templates = Lists.newArrayList();
        for (ObjectCursor<IndexTemplateMetaData> objectCursor : state.metaData().templates().values()) {
            IndexTemplateMetaData template = (IndexTemplateMetaData)objectCursor.value;
            if (!indexTemplateFilter.apply(request, template)) continue;
            templates.add(template);
        }
        File templatesDir = new File(this.environment.configFile(), "templates");
        if (templatesDir.exists() && templatesDir.isDirectory() && (fileArray = templatesDir.listFiles()) != null) {
            for (File templatesFile : fileArray) {
                XContentParser parser;
                block7: {
                    parser = null;
                    try {
                        byte[] templatesData = Streams.copyToByteArray(templatesFile);
                        parser = XContentHelper.createParser(templatesData, 0, templatesData.length);
                        IndexTemplateMetaData template = IndexTemplateMetaData.Builder.fromXContent(parser);
                        if (!indexTemplateFilter.apply(request, template)) break block7;
                        templates.add(template);
                    }
                    catch (Exception e) {
                        try {
                            this.logger.warn("[{}] failed to read template [{}] from config", e, request.index(), templatesFile.getAbsolutePath());
                        }
                        catch (Throwable throwable) {
                            Releasables.closeWhileHandlingException(parser);
                            throw throwable;
                        }
                        Releasables.closeWhileHandlingException(parser);
                        continue;
                    }
                }
                Releasables.closeWhileHandlingException(parser);
            }
        }
        CollectionUtil.timSort(templates, (Comparator)new Comparator<IndexTemplateMetaData>(){

            @Override
            public int compare(IndexTemplateMetaData o1, IndexTemplateMetaData o2) {
                return o2.order() - o1.order();
            }
        });
        return templates;
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) throws ElasticsearchException {
        this.validateIndexName(request.index(), state);
    }

    private static class DefaultIndexTemplateFilter
    implements IndexTemplateFilter {
        private DefaultIndexTemplateFilter() {
        }

        @Override
        public boolean apply(CreateIndexClusterStateUpdateRequest request, IndexTemplateMetaData template) {
            return Regex.simpleMatch(template.template(), request.index());
        }
    }
}

