/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSingleShardTermVectorAction
extends TransportShardSingleOperationAction<TermVectorRequest, TermVectorResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportSingleShardTermVectorAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, "indices:data/read/tv", threadPool, clusterService, transportService, actionFilters);
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "get";
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportShardSingleOperationAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((TermVectorRequest)request.request()).type(), ((TermVectorRequest)request.request()).id(), ((TermVectorRequest)request.request()).routing(), ((TermVectorRequest)request.request()).preference());
    }

    @Override
    protected boolean resolveIndex() {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportShardSingleOperationAction.InternalRequest request) {
        ((TermVectorRequest)request.request()).routing(state.metaData().resolveIndexRouting(((TermVectorRequest)request.request()).routing(), ((TermVectorRequest)request.request()).index()));
        if (((TermVectorRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((TermVectorRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((TermVectorRequest)request.request()).type(), ((TermVectorRequest)request.request()).id());
        }
    }

    @Override
    protected TermVectorResponse shardOperation(TermVectorRequest request, ShardId shardId) throws ElasticsearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        return indexShard.termVectorService().getTermVector(request, shardId.getIndex());
    }

    @Override
    protected TermVectorRequest newRequest() {
        return new TermVectorRequest();
    }

    @Override
    protected TermVectorResponse newResponse() {
        return new TermVectorResponse();
    }
}

