/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.mlt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.mlt.MoreLikeThisRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportMoreLikeThisAction
extends HandledTransportAction<MoreLikeThisRequest, SearchResponse> {
    private final TransportSearchAction searchAction;
    private final TransportGetAction getAction;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public TransportMoreLikeThisAction(Settings settings, ThreadPool threadPool, TransportSearchAction searchAction, TransportGetAction getAction, ClusterService clusterService, IndicesService indicesService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, "indices:data/read/mlt", threadPool, transportService, actionFilters);
        this.searchAction = searchAction;
        this.getAction = getAction;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.transportService = transportService;
    }

    @Override
    public MoreLikeThisRequest newRequestInstance() {
        return new MoreLikeThisRequest();
    }

    @Override
    protected void doExecute(final MoreLikeThisRequest request, final ActionListener<SearchResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        final String concreteIndex = clusterState.metaData().concreteSingleIndex(request.index(), request.indicesOptions());
        RoutingNodes.RoutingNodeIterator routingNode = clusterState.getRoutingNodes().routingNodeIter(this.clusterService.localNode().getId());
        if (routingNode == null) {
            this.redirect(request, concreteIndex, listener, clusterState);
            return;
        }
        boolean hasIndexLocally = false;
        for (MutableShardRouting shardRouting : routingNode) {
            if (!concreteIndex.equals(shardRouting.index())) continue;
            hasIndexLocally = true;
            break;
        }
        if (!hasIndexLocally) {
            this.redirect(request, concreteIndex, listener, clusterState);
            return;
        }
        HashSet<String> getFields = Sets.newHashSet();
        if (request.fields() != null) {
            Collections.addAll(getFields, request.fields());
        }
        getFields.add("_source");
        GetRequest getRequest = (GetRequest)((GetRequest)new GetRequest(request, request.index()).fields(getFields.toArray(new String[getFields.size()])).type(request.type()).id(request.id()).routing(request.routing()).listenerThreaded(true)).operationThreaded(true);
        request.beforeLocalFork();
        this.getAction.execute(getRequest, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse getResponse) {
                String[] searchTypes;
                if (!getResponse.isExists()) {
                    listener.onFailure(new DocumentMissingException(null, request.type(), request.id()));
                    return;
                }
                BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
                try {
                    DocumentMapper docMapper = TransportMoreLikeThisAction.this.indicesService.indexServiceSafe(concreteIndex).mapperService().documentMapper(request.type());
                    if (docMapper == null) {
                        throw new ElasticsearchException("No DocumentMapper found for type [" + request.type() + "]");
                    }
                    HashSet<String> fields = Sets.newHashSet();
                    if (request.fields() != null) {
                        for (String field : request.fields()) {
                            FieldMappers fieldMappers = docMapper.mappers().smartName(field);
                            if (fieldMappers != null) {
                                fields.add(fieldMappers.mapper().names().indexName());
                                continue;
                            }
                            fields.add(field);
                        }
                    }
                    if (!fields.isEmpty()) {
                        Iterator it = fields.iterator();
                        while (it.hasNext()) {
                            String field = (String)it.next();
                            GetField getField = getResponse.getField(field);
                            if (getField == null) continue;
                            for (Object value : getField.getValues()) {
                                TransportMoreLikeThisAction.this.addMoreLikeThis(request, boolBuilder, getField.getName(), value.toString(), true);
                            }
                            it.remove();
                        }
                        if (!fields.isEmpty()) {
                            TransportMoreLikeThisAction.this.parseSource(getResponse, boolBuilder, docMapper, fields, request);
                        }
                    } else {
                        TransportMoreLikeThisAction.this.parseSource(getResponse, boolBuilder, docMapper, fields, request);
                    }
                    if (!boolBuilder.hasClauses()) {
                        listener.onFailure(new ElasticsearchException("No fields found to fetch the 'likeText' from"));
                        return;
                    }
                    if (!request.include()) {
                        Term uidTerm = docMapper.uidMapper().term(request.type(), request.id());
                        boolBuilder.mustNot(QueryBuilders.termQuery(uidTerm.field(), uidTerm.text()));
                        boolBuilder.adjustPureNegative(false);
                    }
                }
                catch (Throwable e) {
                    listener.onFailure(e);
                    return;
                }
                String[] searchIndices = request.searchIndices();
                if (searchIndices == null) {
                    searchIndices = new String[]{request.index()};
                }
                if ((searchTypes = request.searchTypes()) == null) {
                    searchTypes = new String[]{request.type()};
                }
                SearchRequest searchRequest = (SearchRequest)new SearchRequest(request).indices(searchIndices).types(searchTypes).searchType(request.searchType()).scroll(request.searchScroll()).listenerThreaded(request.listenerThreaded());
                SearchSourceBuilder extraSource = SearchSourceBuilder.searchSource().query(boolBuilder);
                if (request.searchFrom() != 0) {
                    extraSource.from(request.searchFrom());
                }
                if (request.searchSize() != 0) {
                    extraSource.size(request.searchSize());
                }
                searchRequest.extraSource(extraSource);
                if (request.searchSource() != null) {
                    searchRequest.source(request.searchSource(), request.searchSourceUnsafe());
                }
                TransportMoreLikeThisAction.this.searchAction.execute(searchRequest, new ActionListener<SearchResponse>(){

                    @Override
                    public void onResponse(SearchResponse response) {
                        listener.onResponse(response);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        listener.onFailure(e);
                    }
                });
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }

    private void redirect(MoreLikeThisRequest request, String concreteIndex, final ActionListener<SearchResponse> listener, ClusterState clusterState) {
        ShardIterator shardIterator = this.clusterService.operationRouting().getShards(clusterState, concreteIndex, request.type(), request.id(), request.routing(), null);
        ShardRouting shardRouting = shardIterator.nextOrNull();
        if (shardRouting == null) {
            throw new ElasticsearchException("No shards for index " + request.index());
        }
        String nodeId = shardRouting.currentNodeId();
        DiscoveryNode discoveryNode = clusterState.nodes().get(nodeId);
        this.transportService.sendRequest(discoveryNode, "indices:data/read/mlt", request, new TransportResponseHandler<SearchResponse>(){

            @Override
            public SearchResponse newInstance() {
                return new SearchResponse();
            }

            @Override
            public void handleResponse(SearchResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    private void parseSource(GetResponse getResponse, final BoolQueryBuilder boolBuilder, DocumentMapper docMapper, final Set<String> fields, final MoreLikeThisRequest request) {
        if (getResponse.isSourceEmpty()) {
            return;
        }
        docMapper.parse(SourceToParse.source(getResponse.getSourceAsBytesRef()).type(request.type()).id(request.id()), new DocumentMapper.ParseListenerAdapter(){

            @Override
            public boolean beforeFieldAdded(FieldMapper fieldMapper, Field field, Object parseContext) {
                if (!field.fieldType().indexed()) {
                    return false;
                }
                if (fieldMapper instanceof InternalMapper) {
                    return true;
                }
                String value = fieldMapper.value(TransportMoreLikeThisAction.this.convertField(field)).toString();
                if (value == null) {
                    return false;
                }
                if (fields.isEmpty() || fields.contains(field.name())) {
                    TransportMoreLikeThisAction.this.addMoreLikeThis(request, boolBuilder, fieldMapper, field, !fields.isEmpty());
                }
                return false;
            }
        });
    }

    private Object convertField(Field field) {
        if (field.stringValue() != null) {
            return field.stringValue();
        }
        if (field.binaryValue() != null) {
            return BytesRef.deepCopyOf((BytesRef)field.binaryValue()).bytes;
        }
        if (field.numericValue() != null) {
            return field.numericValue();
        }
        throw new ElasticsearchIllegalStateException("Field should have either a string, numeric or binary value");
    }

    private void addMoreLikeThis(MoreLikeThisRequest request, BoolQueryBuilder boolBuilder, FieldMapper fieldMapper, Field field, boolean failOnUnsupportedField) {
        this.addMoreLikeThis(request, boolBuilder, field.name(), fieldMapper.value(this.convertField(field)).toString(), failOnUnsupportedField);
    }

    private void addMoreLikeThis(MoreLikeThisRequest request, BoolQueryBuilder boolBuilder, String fieldName, String likeText, boolean failOnUnsupportedField) {
        MoreLikeThisQueryBuilder mlt = QueryBuilders.moreLikeThisQuery(fieldName).likeText(likeText).percentTermsToMatch(request.percentTermsToMatch()).boostTerms(request.boostTerms()).minDocFreq(request.minDocFreq()).maxDocFreq(request.maxDocFreq()).minWordLength(request.minWordLength()).maxWordLength(request.maxWordLength()).minTermFreq(request.minTermFreq()).maxQueryTerms(request.maxQueryTerms()).stopWords(request.stopWords()).failOnUnsupportedField(failOnUnsupportedField);
        boolBuilder.should(mlt);
    }
}

