/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;

public class BulkProcessor
implements Closeable {
    private final Client client;
    private final Listener listener;
    private final String name;
    private final int concurrentRequests;
    private final int bulkActions;
    private final long bulkSize;
    private final TimeValue flushInterval;
    private final Semaphore semaphore;
    private final ScheduledThreadPoolExecutor scheduler;
    private final ScheduledFuture scheduledFuture;
    private final AtomicLong executionIdGen = new AtomicLong();
    private BulkRequest bulkRequest;
    private volatile boolean closed = false;

    public static Builder builder(Client client, Listener listener) {
        return new Builder(client, listener);
    }

    BulkProcessor(Client client, Listener listener, @Nullable String name, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval) {
        this.client = client;
        this.listener = listener;
        this.name = name;
        this.concurrentRequests = concurrentRequests;
        this.bulkActions = bulkActions;
        this.bulkSize = bulkSize.bytes();
        this.semaphore = new Semaphore(concurrentRequests);
        this.bulkRequest = new BulkRequest();
        this.flushInterval = flushInterval;
        if (flushInterval != null) {
            this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory(client.settings(), (name != null ? "[" + name + "]" : "") + "bulk_processor"));
            this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Flush(), flushInterval.millis(), flushInterval.millis(), TimeUnit.MILLISECONDS);
        } else {
            this.scheduler = null;
            this.scheduledFuture = null;
        }
    }

    @Override
    public void close() {
        try {
            this.awaitClose(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.closed) {
            return true;
        }
        this.closed = true;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduler.shutdown();
        }
        if (this.bulkRequest.numberOfActions() > 0) {
            this.execute();
        }
        if (this.concurrentRequests < 1) {
            return true;
        }
        if (this.semaphore.tryAcquire(this.concurrentRequests, timeout, unit)) {
            this.semaphore.release(this.concurrentRequests);
            return true;
        }
        return false;
    }

    public BulkProcessor add(IndexRequest request) {
        return this.add((ActionRequest)request);
    }

    public BulkProcessor add(DeleteRequest request) {
        return this.add((ActionRequest)request);
    }

    public BulkProcessor add(ActionRequest request) {
        return this.add(request, null);
    }

    public BulkProcessor add(ActionRequest request, @Nullable Object payload) {
        this.internalAdd(request, payload);
        return this;
    }

    boolean isOpen() {
        return !this.closed;
    }

    protected void ensureOpen() {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("bulk process already closed");
        }
    }

    private synchronized void internalAdd(ActionRequest request, @Nullable Object payload) {
        this.ensureOpen();
        this.bulkRequest.add(request, payload);
        this.executeIfNeeded();
    }

    public BulkProcessor add(BytesReference data, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(data, contentUnsafe, defaultIndex, defaultType, null);
    }

    public synchronized BulkProcessor add(BytesReference data, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable Object payload) throws Exception {
        this.bulkRequest.add(data, contentUnsafe, defaultIndex, defaultType, null, payload, true);
        this.executeIfNeeded();
        return this;
    }

    private void executeIfNeeded() {
        this.ensureOpen();
        if (!this.isOverTheLimit()) {
            return;
        }
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        block12: {
            final BulkRequest bulkRequest = this.bulkRequest;
            final long executionId = this.executionIdGen.incrementAndGet();
            this.bulkRequest = new BulkRequest();
            if (this.concurrentRequests == 0) {
                boolean afterCalled = false;
                try {
                    this.listener.beforeBulk(executionId, bulkRequest);
                    BulkResponse bulkItemResponses = this.client.bulk(bulkRequest).actionGet();
                    afterCalled = true;
                    this.listener.afterBulk(executionId, bulkRequest, bulkItemResponses);
                }
                catch (Exception e) {
                    if (!afterCalled) {
                        this.listener.afterBulk(executionId, bulkRequest, e);
                    }
                    break block12;
                }
            }
            boolean success = false;
            try {
                this.listener.beforeBulk(executionId, bulkRequest);
                this.semaphore.acquire();
                this.client.bulk(bulkRequest, new ActionListener<BulkResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(BulkResponse response) {
                        try {
                            BulkProcessor.this.listener.afterBulk(executionId, bulkRequest, response);
                        }
                        finally {
                            BulkProcessor.this.semaphore.release();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Throwable e) {
                        try {
                            BulkProcessor.this.listener.afterBulk(executionId, bulkRequest, e);
                        }
                        finally {
                            BulkProcessor.this.semaphore.release();
                        }
                    }
                });
                success = true;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
            catch (Throwable t) {
                this.listener.afterBulk(executionId, bulkRequest, t);
            }
            finally {
                if (!success) {
                    this.semaphore.release();
                }
            }
        }
    }

    private boolean isOverTheLimit() {
        if (this.bulkActions != -1 && this.bulkRequest.numberOfActions() >= this.bulkActions) {
            return true;
        }
        return this.bulkSize != -1L && this.bulkRequest.estimatedSizeInBytes() >= this.bulkSize;
    }

    public synchronized void flush() {
        this.ensureOpen();
        if (this.bulkRequest.numberOfActions() > 0) {
            this.execute();
        }
    }

    class Flush
    implements Runnable {
        Flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkProcessor bulkProcessor = BulkProcessor.this;
            synchronized (bulkProcessor) {
                if (BulkProcessor.this.closed) {
                    return;
                }
                if (BulkProcessor.this.bulkRequest.numberOfActions() == 0) {
                    return;
                }
                BulkProcessor.this.execute();
            }
        }
    }

    public static class Builder {
        private final Client client;
        private final Listener listener;
        private String name;
        private int concurrentRequests = 1;
        private int bulkActions = 1000;
        private ByteSizeValue bulkSize = new ByteSizeValue(5L, ByteSizeUnit.MB);
        private TimeValue flushInterval = null;

        public Builder(Client client, Listener listener) {
            this.client = client;
            this.listener = listener;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setConcurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        public Builder setBulkActions(int bulkActions) {
            this.bulkActions = bulkActions;
            return this;
        }

        public Builder setBulkSize(ByteSizeValue bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder setFlushInterval(TimeValue flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public BulkProcessor build() {
            return new BulkProcessor(this.client, this.listener, this.name, this.concurrentRequests, this.bulkActions, this.bulkSize, this.flushInterval);
        }
    }

    public static interface Listener {
        public void beforeBulk(long var1, BulkRequest var3);

        public void afterBulk(long var1, BulkRequest var3, BulkResponse var4);

        public void afterBulk(long var1, BulkRequest var3, Throwable var4);
    }
}

