/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.info.ClusterInfoRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetIndexRequest
extends ClusterInfoRequest<GetIndexRequest> {
    private String[] features = new String[]{"_settings", "_warmers", "_mappings", "_aliases"};
    private boolean indicesOptionsSet = false;

    public GetIndexRequest features(String[] features) {
        if (features == null) {
            throw new ElasticsearchIllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    public String[] features() {
        return this.features;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.features = in.readStringArray();
        this.indicesOptionsSet = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.features);
        out.writeBoolean(this.indicesOptionsSet);
    }

    @Override
    public GetIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptionsSet = true;
        return (GetIndexRequest)super.indicesOptions(indicesOptions);
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (!this.indicesOptionsSet) {
            this.indicesOptions(this.resolveIndicesOptions());
        }
        IndicesOptions indicesOptions = super.indicesOptions();
        return indicesOptions;
    }

    private IndicesOptions resolveIndicesOptions() {
        IndicesOptions defaultIndicesOptions = IndicesOptions.strictExpandOpen();
        String[] indices = this.indices();
        if (this.features != null && this.features.length == 1 && this.features[0] != null && ("_alias".equals(this.features[0]) || "_aliases".equals(this.features[0]))) {
            defaultIndicesOptions = MetaData.isAllIndices(indices) ? IndicesOptions.fromOptions(true, true, true, true) : IndicesOptions.lenientExpandOpen();
        }
        return defaultIndicesOptions;
    }
}

