/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.metadata.SnapshotMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSnapshotsStatusAction
extends TransportMasterNodeOperationAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private final SnapshotsService snapshotsService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;

    @Inject
    public TransportSnapshotsStatusAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters) {
        super(settings, "cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters);
        this.snapshotsService = snapshotsService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA);
    }

    @Override
    protected SnapshotsStatusRequest newRequest() {
        return new SnapshotsStatusRequest();
    }

    @Override
    protected SnapshotsStatusResponse newResponse() {
        return new SnapshotsStatusResponse();
    }

    @Override
    protected void masterOperation(final SnapshotsStatusRequest request, ClusterState state, final ActionListener<SnapshotsStatusResponse> listener) throws ElasticsearchException {
        ImmutableList<SnapshotMetaData.Entry> currentSnapshots = this.snapshotsService.currentSnapshots(request.repository(), request.snapshots());
        if (currentSnapshots.isEmpty()) {
            listener.onResponse(this.buildResponse(request, currentSnapshots, null));
            return;
        }
        HashSet<String> nodesIds = Sets.newHashSet();
        for (SnapshotMetaData.Entry entry : currentSnapshots) {
            for (SnapshotMetaData.ShardSnapshotStatus status : entry.shards().values()) {
                if (status.nodeId() == null) continue;
                nodesIds.add(status.nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            SnapshotId[] snapshotIds = new SnapshotId[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshotIds[i] = ((SnapshotMetaData.Entry)currentSnapshots.get(i)).snapshotId();
            }
            this.transportNodesSnapshotsStatus.status(nodesIds.toArray(new String[nodesIds.size()]), snapshotIds, request.masterNodeTimeout(), new ActionListener<TransportNodesSnapshotsStatus.NodesSnapshotStatus>(){

                @Override
                public void onResponse(TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses) {
                    try {
                        ImmutableList<SnapshotMetaData.Entry> currentSnapshots = TransportSnapshotsStatusAction.this.snapshotsService.currentSnapshots(request.repository(), request.snapshots());
                        listener.onResponse(TransportSnapshotsStatusAction.this.buildResponse(request, currentSnapshots, nodeSnapshotStatuses));
                    }
                    catch (Throwable e) {
                        listener.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
        } else {
            listener.onResponse(this.buildResponse(request, currentSnapshots, null));
        }
    }

    private SnapshotsStatusResponse buildResponse(SnapshotsStatusRequest request, ImmutableList<SnapshotMetaData.Entry> currentSnapshots, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<SnapshotId> currentSnapshotIds = Sets.newHashSet();
        if (!currentSnapshots.isEmpty()) {
            Map<Object, Object> nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : Maps.newHashMap();
            for (SnapshotMetaData.Entry entry : currentSnapshots) {
                currentSnapshotIds.add(entry.snapshotId());
                ImmutableList.Builder shardStatusBuilder = ImmutableList.builder();
                for (Map.Entry shardEntry : entry.shards().entrySet()) {
                    SnapshotIndexShardStage stage;
                    Object shardStatus;
                    ImmutableMap<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotMetaData.ShardSnapshotStatus status = (SnapshotMetaData.ShardSnapshotStatus)shardEntry.getValue();
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)nodeSnapshotStatusMap.get(status.nodeId())) != null && (shardStatues = nodeStatus.status().get(entry.snapshotId())) != null && (shardStatus = shardStatues.get(shardEntry.getKey())) != null) {
                        shardStatusBuilder.add(shardStatus);
                        continue;
                    }
                    switch (((SnapshotMetaData.ShardSnapshotStatus)shardEntry.getValue()).state()) {
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            stage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: 
                        case STARTED: {
                            stage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            stage = SnapshotIndexShardStage.DONE;
                            break;
                        }
                        default: {
                            throw new ElasticsearchIllegalArgumentException("Unknown snapshot state " + (Object)((Object)((SnapshotMetaData.ShardSnapshotStatus)shardEntry.getValue()).state()));
                        }
                    }
                    SnapshotIndexShardStatus shardStatus2 = new SnapshotIndexShardStatus((ShardId)shardEntry.getKey(), stage);
                    shardStatusBuilder.add(shardStatus2);
                }
                builder.add(new SnapshotStatus(entry.snapshotId(), entry.state(), (ImmutableList<SnapshotIndexShardStatus>)shardStatusBuilder.build()));
            }
        }
        if (Strings.hasText(request.repository()) && request.snapshots() != null && request.snapshots().length > 0) {
            for (String snapshotName : request.snapshots()) {
                SnapshotMetaData.State state;
                SnapshotId snapshotId = new SnapshotId(request.repository(), snapshotName);
                if (currentSnapshotIds.contains(snapshotId)) continue;
                Snapshot snapshot = this.snapshotsService.snapshot(snapshotId);
                ImmutableList.Builder shardStatusBuilder = ImmutableList.builder();
                if (!snapshot.state().completed()) continue;
                ImmutableMap<ShardId, IndexShardSnapshotStatus> shardStatues = this.snapshotsService.snapshotShards(snapshotId);
                for (Object shardStatus : shardStatues.entrySet()) {
                    shardStatusBuilder.add(new SnapshotIndexShardStatus((ShardId)shardStatus.getKey(), (IndexShardSnapshotStatus)shardStatus.getValue()));
                }
                switch (snapshot.state()) {
                    case FAILED: {
                        state = SnapshotMetaData.State.FAILED;
                        break;
                    }
                    case SUCCESS: 
                    case PARTIAL: {
                        state = SnapshotMetaData.State.SUCCESS;
                        break;
                    }
                    default: {
                        throw new ElasticsearchIllegalArgumentException("Unknown snapshot state " + (Object)((Object)snapshot.state()));
                    }
                }
                builder.add(new SnapshotStatus(snapshotId, state, (ImmutableList<SnapshotIndexShardStatus>)shardStatusBuilder.build()));
            }
        }
        return new SnapshotsStatusResponse((ImmutableList<SnapshotStatus>)builder.build());
    }
}

