/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.utils.Crc32;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.TraitSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Runnable runnable(Function0<BoxedUnit> fun$1) {
        return new Runnable(fun$1){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = function0;
            }
        };
    }

    public Thread daemonThread(Runnable runnable) {
        return this.newThread(runnable, true);
    }

    public Thread daemonThread(String name, Runnable runnable) {
        return this.newThread(name, runnable, true);
    }

    public Thread daemonThread(String name, Function0<BoxedUnit> fun) {
        return this.daemonThread(name, this.runnable(fun));
    }

    public Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t$1, Throwable e$1) {
                Utils$.MODULE$.error((Function0<String>)new Serializable(this, t$1){
                    public static final long serialVersionUID;
                    private final Thread t$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Uncaught exception in thread '").append((Object)this.t$1.getName()).append((Object)"':").toString();
                    }
                    {
                        this.t$1 = thread;
                    }
                }, (Function0<Throwable>)new Serializable(this, e$1){
                    public static final long serialVersionUID;
                    private final Throwable e$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = throwable;
                    }
                });
            }
        });
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    public Thread newThread(Runnable runnable, boolean daemon) {
        void var3_3;
        Thread thread = new Thread(runnable);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t$2, Throwable e$2) {
                Utils$.MODULE$.error((Function0<String>)new Serializable(this, t$2){
                    public static final long serialVersionUID;
                    private final Thread t$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Uncaught exception in thread '").append((Object)this.t$2.getName()).append((Object)"':").toString();
                    }
                    {
                        this.t$2 = thread;
                    }
                }, (Function0<Throwable>)new Serializable(this, e$2){
                    public static final long serialVersionUID;
                    private final Throwable e$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e$2;
                    }
                    {
                        this.e$2 = throwable;
                    }
                });
            }
        });
        return var3_3;
    }

    public byte[] readBytes(ByteBuffer buffer) {
        return this.readBytes(buffer, 0, buffer.limit());
    }

    public byte[] readBytes(ByteBuffer buffer, int offset, int size2) {
        Buffer buffer2;
        byte[] dest = new byte[size2];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + offset, dest, 0, size2);
            buffer2 = BoxedUnit.UNIT;
        } else {
            buffer.mark();
            buffer.get(dest);
            buffer2 = buffer.reset();
        }
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadProps(String filename) {
        void var3_3;
        FileInputStream propStream = new FileInputStream(filename);
        Properties props = new Properties();
        props.load(propStream);
        return var3_3;
    }

    public FileChannel openChannel(File file, boolean mutable) {
        return mutable ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> log, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log.apply((Object)throwable.getMessage(), (Object)throwable);
        }
    }

    public boolean equal(ByteBuffer b1$1, ByteBuffer b2$1) {
        Object object = new Object();
        boolean exceptionResult1 = false;
        try {
            if (b1$1.position() != b2$1.position()) {
                return false;
            }
            if (b1$1.remaining() != b2$1.remaining()) {
                return false;
            }
            Predef$.MODULE$.intWrapper(0).until(b1$1.remaining()).foreach$mVc$sp((Function1)new Serializable(b1$1, b2$1, object){
                public static final long serialVersionUID;
                private final ByteBuffer b1$1;
                private final ByteBuffer b2$1;
                private final Object nonLocalReturnKey1$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int v1) {
                    if (this.b1$1.get(v1) != this.b2$1.get(v1)) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                }
                {
                    this.b1$1 = byteBuffer;
                    this.b2$1 = byteBuffer2;
                    this.nonLocalReturnKey1$1 = object;
                }
            });
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                exceptionResult1 = BoxesRunTime.unboxToBoolean((Object)nonLocalReturnControl.value());
                return exceptionResult1;
            }
            throw nonLocalReturnControl;
        }
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public void rm(String file) {
        this.rm(new File(file));
    }

    public void rm(Seq<String> files) {
        files.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String f) {
                Utils$.MODULE$.rm(new File(f));
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(File f) {
                        Utils$.MODULE$.rm(f);
                    }
                });
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name$1) {
        void var3_3;
        boolean exceptionResult2 = false;
        try {
            Boolean bl;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name$1);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl = BoxesRunTime.boxToBoolean((boolean)true);
            }
            exceptionResult2 = BoxesRunTime.unboxToBoolean((Object)bl);
            return (boolean)var3_3;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(name$1){
                public static final long serialVersionUID;
                private final String name$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = string;
                }
            }, (Function0<Throwable>)new Serializable(exception){
                public static final long serialVersionUID;
                private final Exception e$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Exception apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = exception;
                }
            });
            return (boolean)var3_3;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public void writetUnsignedInt(ByteBuffer buffer, long value2) {
        buffer.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    public void writeUnsignedInt(ByteBuffer buffer, int index, long value2) {
        buffer.putInt(index, (int)(value2 & 0xFFFFFFFFL));
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        Crc32 crc = new Crc32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int hashcode(Seq<Object> as) {
        if (as == null) {
            return 0;
        }
        int h = 1;
        int i = 0;
        while (i < as.length()) {
            if (as.apply(i) == null) continue;
            h = 31 * h + as.apply(i).hashCode();
            ++i;
        }
        return h;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Map<K, List<V>> groupby(Iterable<V> vals, Function1<V, K> f$1) {
        void var3_3;
        HashMap m$1 = new HashMap();
        vals.foreach((Function1)new Serializable(f$1, m$1){
            public static final long serialVersionUID;
            private final Function1 f$1;
            private final HashMap m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<List<V>> apply(V v) {
                Option option;
                block5: {
                    Option option2;
                    block4: {
                        Object k;
                        block2: {
                            block3: {
                                k = this.f$1.apply(v);
                                option = this.m$1.get(k);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                List list = (List)some.x();
                                if (list == null) break block3;
                                V v2 = v;
                                option2 = this.m$1.put(k, (Object)list.$colon$colon(v2));
                                break block4;
                            }
                            throw new MatchError((Object)option);
                        }
                        None$ none$ = None$.MODULE$;
                        Option option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        option2 = this.m$1.put(k, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                    }
                    return option2;
                }
                throw new MatchError((Object)option);
            }
            {
                this.f$1 = function1;
                this.m$1 = hashMap;
            }
        });
        return var3_3;
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        if (n == -1) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        if (BoxesRunTime.boxToInteger((int)n) instanceof Integer) {
            return n;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new KafkaException("Value cannot be null.");
        }
        return v;
    }

    public Tuple2<String, Object> parseHostPort(String hostport) {
        String[] splits = hostport.split(":");
        return new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(splits[1]).toInt()));
    }

    public String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        String[][] keyVals = (String[][])Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String[] apply(String s) {
                return s.split("\\s*:\\s*");
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.arrayType((OptManifest)ClassManifest$.MODULE$.classType(String.class))));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])keyVals).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<String, String> apply(String[] pair) {
                return new Tuple2((Object)pair[0], (Object)pair[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(String.class)}))))).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")).filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String v) {
                return !v.equals("");
            }
        }));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className);
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Class<?> apply(Object object) {
                return object.getClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(Class.class, (OptManifest)NoManifest$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))));
        return (T)constructor.newInstance((Object[])args.toArray((ClassManifest)Manifest$.MODULE$.Object()));
    }

    public boolean nullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll$1) {
        Stream stream = (Stream)package$.MODULE$.Stream().continually((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap((Function1)new Serializable(coll$1){
            public static final long serialVersionUID;
            private final Iterable coll$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterable<T> apply(int forever) {
                return (Iterable)this.coll$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = iterable;
            }
        }, Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    public String readFileAsString(String path, Charset charset) {
        FileInputStream stream = new FileInputStream(new File(path));
        String exceptionResult3 = null;
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            exceptionResult3 = charset.decode(bb).toString();
            return exceptionResult3;
        }
        finally {
            stream.close();
        }
    }

    public Charset readFileAsString$default$2() {
        return Charset.defaultCharset();
    }

    public int abs(int n) {
        return n & Integer.MAX_VALUE;
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (s.endsWith(oldSuffix)) {
            return new StringBuilder().append((Object)s.substring(0, s.length() - oldSuffix.length())).append((Object)newSuffix).toString();
        }
        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
    }

    public File createFile(String path) {
        File f = new File(path);
        boolean created = f.createNewFile();
        if (created) {
            return f;
        }
        throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to create file %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
    }

    public String asString(Properties props) {
        StringWriter writer = new StringWriter();
        props.store(writer, "");
        return writer.toString();
    }

    public Properties readProps(String s, Properties defaults) {
        StringReader reader = new StringReader(s);
        Properties props = new Properties(defaults);
        props.load(reader);
        return props;
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock2, Function0<T> fun) {
        lock2.lock();
        Object exceptionResult4 = null;
        try {
            return (T)fun.apply();
        }
        finally {
            lock2.unlock();
        }
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

