/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpLogSegments$
implements ScalaObject {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content");
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration");
        OptionSet options = parser.parse(args);
        if (!options.has((OptionSpec)filesOpt)) {
            System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append((Object)filesOpt).append((Object)"\"").toString());
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        boolean print$1 = options.has((OptionSpec)printOpt);
        boolean verifyOnly$1 = options.has((OptionSpec)verifyOpt);
        String[] files = ((String)options.valueOf((OptionSpec)filesOpt)).split(",");
        int maxMessageSize$1 = (Integer)options.valueOf((OptionSpec)maxMessageSizeOpt);
        boolean isDeepIteration$1 = options.has((OptionSpec)deepIterationOpt);
        HashMap misMatchesForIndexFilesMap$1 = new HashMap();
        HashMap nonConsecutivePairsForLogFilesMap$1 = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(print$1, verifyOnly$1, maxMessageSize$1, isDeepIteration$1, misMatchesForIndexFilesMap$1, nonConsecutivePairsForLogFilesMap$1){
            public static final long serialVersionUID;
            private final boolean print$1;
            private final boolean verifyOnly$1;
            private final int maxMessageSize$1;
            private final boolean isDeepIteration$1;
            private final HashMap misMatchesForIndexFilesMap$1;
            private final HashMap nonConsecutivePairsForLogFilesMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String arg) {
                File file = new File(arg);
                if (file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.print$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1);
                } else if (file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                }
            }
            {
                this.print$1 = bl;
                this.verifyOnly$1 = bl2;
                this.maxMessageSize$1 = n;
                this.isDeepIteration$1 = bl3;
                this.misMatchesForIndexFilesMap$1 = hashMap;
                this.nonConsecutivePairsForLogFilesMap$1 = hashMap2;
            }
        });
        misMatchesForIndexFilesMap$1.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> tuple2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    System.err.println(new StringBuilder().append((Object)"Mismatches in :").append(tuple22._1()).toString());
                    ((LinearSeqOptimized)tuple22._2()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }
        });
        nonConsecutivePairsForLogFilesMap$1.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> tuple2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    System.err.println(new StringBuilder().append((Object)"Non-secutive offsets in :").append(tuple22._1()).toString());
                    ((LinearSeqOptimized)tuple22._2()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(Predef$.MODULE$.augmentString("  %d is followed by %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public final void kafka$tools$DumpLogSegments$$dumpIndex(File file$2, boolean verifyOnly$2, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap$2, int maxMessageSize$2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                long startOffset = Predef$.MODULE$.augmentString(file$2.getName().split("\\.")[0]).toLong();
                String logFileName = new StringBuilder().append((Object)file$2.getAbsolutePath().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString();
                File logFile = new File(logFileName);
                FileMessageSet messageSet$1 = new FileMessageSet(logFile, false);
                OffsetIndex index$1 = new OffsetIndex(file$2, startOffset, OffsetIndex$.MODULE$.init$default$3());
                Predef$.MODULE$.intWrapper(0).until(index$1.entries()).foreach$mVc$sp((Function1)new Serializable(file$2, verifyOnly$2, misMatchesForIndexFilesMap$2, maxMessageSize$2, messageSet$1, index$1, object){
                    public static final long serialVersionUID;
                    private final File file$2;
                    private final boolean verifyOnly$2;
                    private final HashMap misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$2;
                    private final FileMessageSet messageSet$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int v1) {
                        BoxedUnit boxedUnit;
                        OffsetPosition entry2 = this.index$1.entry(v1);
                        FileMessageSet partialFileMessageSet = this.messageSet$1.read(entry2.position(), this.maxMessageSize$2);
                        MessageAndOffset messageAndOffset = (MessageAndOffset)DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((MessageAndOffset)partialFileMessageSet.head(), true).next();
                        if (messageAndOffset.offset() != entry2.offset() + this.index$1.baseOffset()) {
                            List misMatchesSeq = (List)this.misMatchesForIndexFilesMap$2.getOrElse((Object)this.file$2.getAbsolutePath(), (Function0)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry2.offset() + this.index$1.baseOffset(), messageAndOffset.offset()));
                            boxedUnit = this.misMatchesForIndexFilesMap$2.put((Object)this.file$2.getAbsolutePath(), (Object)misMatchesSeq);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (entry2.offset() == 0L && v1 > 0) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxedUnit.UNIT);
                        }
                        if (!this.verifyOnly$2) {
                            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("offset: %d position: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(entry2.offset() + this.index$1.baseOffset())), BoxesRunTime.boxToInteger((int)entry2.position())})));
                        }
                    }
                    {
                        this.file$2 = file;
                        this.verifyOnly$2 = bl;
                        this.misMatchesForIndexFilesMap$2 = hashMap;
                        this.maxMessageSize$2 = n;
                        this.messageSet$1 = fileMessageSet;
                        this.index$1 = offsetIndex;
                        this.nonLocalReturnKey1$1 = object;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)nonLocalReturnControl2.value();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public final void kafka$tools$DumpLogSegments$$dumpLog(File file$1, boolean printContents$1, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap$2, boolean isDeepIteration$2) {
        long startOffset = Predef$.MODULE$.augmentString(file$1.getName().split("\\.")[0]).toLong();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Starting offset: ").append((Object)BoxesRunTime.boxToLong((long)startOffset)).toString());
        FileMessageSet messageSet = new FileMessageSet(file$1, false);
        LongRef validBytes$1 = new LongRef(0L);
        LongRef lastOffset$1 = new LongRef(-1L);
        messageSet.foreach((Function1)new Serializable(file$1, printContents$1, nonConsecutivePairsForLogFilesMap$2, isDeepIteration$2, validBytes$1, lastOffset$1){
            public static final long serialVersionUID;
            public final File file$1;
            public final boolean printContents$1;
            public final HashMap nonConsecutivePairsForLogFilesMap$2;
            private final boolean isDeepIteration$2;
            public final LongRef validBytes$1;
            public final LongRef lastOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MessageAndOffset shallowMessageAndOffset) {
                Iterator<MessageAndOffset> itr = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator(shallowMessageAndOffset, this.isDeepIteration$2);
                itr.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MessageAndOffset messageAndOffset) {
                        BoxedUnit boxedUnit;
                        Message msg = messageAndOffset.message();
                        if (this.$outer.lastOffset$1.elem == -1L) {
                            this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            CompressionCodec compressionCodec = msg.compressionCodec();
                            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                            if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) && messageAndOffset.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                List nonConsecutivePairsSeq = (List)this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)this.$outer.file$1.getAbsolutePath(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final List<Tuple2<Object, Object>> apply() {
                                        return Nil$.MODULE$;
                                    }
                                });
                                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(this.$outer.lastOffset$1.elem, messageAndOffset.offset()));
                                boxedUnit = this.$outer.nonConsecutivePairsForLogFilesMap$2.put((Object)this.$outer.file$1.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"offset: ").append((Object)BoxesRunTime.boxToLong((long)messageAndOffset.offset())).append((Object)" position: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.validBytes$1.elem)).append((Object)" isvalid: ").append((Object)BoxesRunTime.boxToBoolean((boolean)msg.isValid())).append((Object)" payloadsize: ").append((Object)BoxesRunTime.boxToInteger((int)msg.payloadSize())).append((Object)" magic: ").append((Object)BoxesRunTime.boxToByte((byte)msg.magic())).append((Object)" compresscodec: ").append((Object)msg.compressionCodec()).append((Object)" crc: ").append((Object)BoxesRunTime.boxToLong((long)msg.checksum())).toString());
                        if (msg.hasKey()) {
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" keysize: ").append((Object)BoxesRunTime.boxToInteger((int)msg.keySize())).toString());
                        }
                        if (this.$outer.printContents$1) {
                            if (msg.hasKey()) {
                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" key: ").append((Object)Utils$.MODULE$.readString(messageAndOffset.message().key(), "UTF-8")).toString());
                            }
                            String payload = messageAndOffset.message().isNull() ? null : Utils$.MODULE$.readString(messageAndOffset.message().payload(), "UTF-8");
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" payload: ").append((Object)payload).toString());
                        }
                        Predef$.MODULE$.println();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.validBytes$1.elem += (long)MessageSet$.MODULE$.entrySize(shallowMessageAndOffset.message());
            }
            {
                this.file$1 = file;
                this.printContents$1 = bl;
                this.nonConsecutivePairsForLogFilesMap$2 = hashMap;
                this.isDeepIteration$2 = bl2;
                this.validBytes$1 = longRef;
                this.lastOffset$1 = longRef2;
            }
        });
        long trailingBytes = (long)messageSet.sizeInBytes() - validBytes$1.elem;
        if (trailingBytes > 0L) {
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trailingBytes), file$1.getName()})));
        }
    }

    public final Iterator<MessageAndOffset> kafka$tools$DumpLogSegments$$getIterator(MessageAndOffset messageAndOffset, boolean isDeepIteration) {
        IteratorTemplate<MessageAndOffset> iteratorTemplate;
        if (isDeepIteration) {
            Message message = messageAndOffset.message();
            CompressionCodec compressionCodec = message.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            CompressionCodec compressionCodec2 = compressionCodec;
            iteratorTemplate = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? this.getSingleMessageIterator(messageAndOffset) : ByteBufferMessageSet$.MODULE$.decompress(message).iterator();
        } else {
            iteratorTemplate = this.getSingleMessageIterator(messageAndOffset);
        }
        return iteratorTemplate;
    }

    private IteratorTemplate<MessageAndOffset> getSingleMessageIterator(MessageAndOffset messageAndOffset$1) {
        return new IteratorTemplate<MessageAndOffset>(messageAndOffset$1){
            private boolean messageIterated;
            private final MessageAndOffset messageAndOffset$1;

            public boolean messageIterated() {
                return this.messageIterated;
            }

            public void messageIterated_$eq(boolean bl) {
                this.messageIterated = bl;
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                if (this.messageIterated()) {
                    messageAndOffset = (MessageAndOffset)this.allDone();
                } else {
                    this.messageIterated_$eq(true);
                    messageAndOffset = this.messageAndOffset$1;
                }
                return messageAndOffset;
            }
            {
                this.messageAndOffset$1 = messageAndOffset;
                this.messageIterated = false;
            }
        };
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

