/*
 * Decompiled with CFR 0.152.
 */
package jbundler;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;

public class AetherSettings {
    private static final SettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
    private File globalSettings;
    private File userSettings;
    private List<Proxy> proxies = new LinkedList<Proxy>();
    private Settings settings;
    private List<Mirror> mirrors = new LinkedList<Mirror>();
    private Boolean offline;
    private LocalRepository localRepository;

    LocalRepository getLocalRepository() {
        if (this.localRepository != null && this.localRepository.getBasedir() != null) {
            return this.localRepository;
        }
        return new LocalRepository(this.getDefaultLocalRepoDir());
    }

    private File getDefaultLocalRepoDir() {
        Settings settings = this.getSettings();
        if (settings.getLocalRepository() != null) {
            return new File(settings.getLocalRepository());
        }
        return new File(new File(System.getProperty("user.home"), ".m2"), "repository");
    }

    void setLocalRepository(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    synchronized Settings getSettings() {
        if (this.settings == null) {
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(this.getUserSettings());
            request.setGlobalSettingsFile(this.getGlobalSettings());
            request.setSystemProperties(this.getSystemProperties());
            request.setUserProperties(this.getUserProperties());
            try {
                this.settings = settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException settingsBuildingException) {
                // empty catch block
            }
        }
        return this.settings;
    }

    ProxySelector getProxySelector() {
        DefaultProxySelector selector = new DefaultProxySelector();
        for (Proxy proxy : this.proxies) {
            selector.add(proxy, proxy.getHost());
        }
        Settings settings = this.getSettings();
        for (org.apache.maven.settings.Proxy proxy : settings.getProxies()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(proxy.getUsername());
            auth.addPassword(proxy.getPassword());
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth.build()), proxy.getNonProxyHosts());
        }
        return selector;
    }

    AuthenticationSelector getAuthSelector() {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        Settings settings = this.getSettings();
        for (Server server : settings.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername());
            auth.addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)selector);
    }

    String getUserAgent() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("JBundler/");
        buffer.append(" (");
        buffer.append("Java ").append(System.getProperty("java.version"));
        buffer.append("; ");
        buffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        buffer.append(")");
        buffer.append(" Aether");
        return buffer.toString();
    }

    void setOffline(Boolean offline) {
        this.offline = offline;
    }

    boolean isOffline() {
        return this.offline == null ? this.getSettings().isOffline() : this.offline.booleanValue();
    }

    Properties getSystemProperties() {
        Properties props = new Properties();
        this.getEnvProperties(props);
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    Properties getUserProperties() {
        Properties props = new Properties();
        return props;
    }

    private Properties getEnvProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        boolean envCaseInsensitive = false;
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (envCaseInsensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            key = "env." + key;
            props.put(key, entry.getValue());
        }
        return props;
    }

    void addMirror(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    MirrorSelector getMirrorSelector() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : this.mirrors) {
            selector.add(mirror.getId(), mirror.getUrl(), "default", true, mirror.getMirrorOf(), null);
        }
        Settings settings = this.getSettings();
        for (Mirror mirror : settings.getMirrors()) {
            selector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), true, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    synchronized void setUserSettings(File file) {
        this.userSettings = file;
    }

    File getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = new File(new File(System.getProperty("user.home"), ".m2"), "settings.xml");
        }
        return this.userSettings;
    }

    private String getMavenHome() {
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            return mavenHome;
        }
        return System.getenv("M2_HOME");
    }

    File getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = new File(new File(this.getMavenHome(), "conf"), "settings.xml");
        }
        return this.globalSettings;
    }

    void addProxy(Proxy proxy) {
        this.proxies.add(proxy);
    }
}

