/*
 * Decompiled with CFR 0.152.
 */
package jbundler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jbundler.AetherSettings;
import jbundler.ManualWagonProvider;
import jbundler.SimpleRepositoryListener;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.wagon.WagonProvider;
import org.eclipse.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aether {
    private DependencyNode node;
    private final RepositorySystem repoSystem;
    private RepositorySystemSession session;
    private List<Dependency> dependencies = new LinkedList<Dependency>();
    private List<RemoteRepository> repos = new LinkedList<RemoteRepository>();
    private final Installer installer;
    private final AetherSettings settings = new AetherSettings();
    private final boolean verbose;

    public Aether(boolean verbose) {
        ServiceLocator locator = this.newServiceLocator();
        this.verbose = verbose;
        this.repoSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.installer = (Installer)locator.getService(Installer.class);
        this.repos.add(new RemoteRepository.Builder("central", "default", "http://repo2.maven.org/maven2").build());
    }

    private RepositorySystemSession getSession() {
        if (this.session == null) {
            DefaultRepositorySystemSession s = MavenRepositorySystemUtils.newSession();
            LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
            configProps.put("aether.connector.userAgent", this.settings.getUserAgent());
            configProps.putAll(System.getProperties());
            configProps.putAll(this.settings.getUserProperties());
            s.setConfigProperties(configProps);
            s.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager((RepositorySystemSession)s, this.settings.getLocalRepository()));
            s.setRepositoryListener((RepositoryListener)new SimpleRepositoryListener(this.verbose, s.getLocalRepositoryManager()));
            s.setOffline(this.settings.isOffline());
            s.setMirrorSelector(this.settings.getMirrorSelector());
            s.setAuthenticationSelector(this.settings.getAuthSelector());
            s.setProxySelector(this.settings.getProxySelector());
            s.setUserProperties((Map)this.settings.getUserProperties());
            s.setSystemProperties((Map)this.settings.getSystemProperties());
            this.session = s;
        }
        return this.session;
    }

    private ServiceLocator newServiceLocator() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        return locator;
    }

    public void setLocalRepository(File localRepository) {
        this.settings.setLocalRepository(new LocalRepository(localRepository));
    }

    public void addMirror(String url) {
        Mirror mirror = new Mirror();
        mirror.setId("jbundler");
        mirror.setLayout("default");
        mirror.setMirrorOf("central");
        mirror.setName("JBundler Maven Central Mirror");
        mirror.setUrl(url);
        mirror.setMirrorOfLayouts("*");
        this.settings.addMirror(mirror);
    }

    public void setOffline(Boolean offline) {
        this.settings.setOffline(offline);
    }

    public synchronized void setUserSettings(File file) {
        this.settings.setUserSettings(file);
    }

    public void addProxy(String url) {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("can not parse given url: " + url, e);
        }
        AuthenticationBuilder authentication = new AuthenticationBuilder();
        String userInfo = u.getUserInfo();
        if (userInfo != null && userInfo.contains(":")) {
            int i = userInfo.indexOf(58);
            authentication.addUsername(userInfo.substring(0, i));
            authentication.addPassword(userInfo.substring(i + 1));
        }
        this.settings.addProxy(new Proxy(u.getProtocol(), u.getHost(), u.getPort(), authentication.build()));
    }

    public void addArtifact(String coordinate) {
        this.addArtifact(coordinate, "compile");
    }

    public void addArtifact(String coordinate, String scope) {
        this.dependencies.add(new Dependency((Artifact)new DefaultArtifact(coordinate), scope));
    }

    public void addArtifactWithExclusions(String coordinate, String scope, String ... exclusions) {
        DefaultArtifact artifact = new DefaultArtifact(coordinate);
        ArrayList<Exclusion> list = new ArrayList<Exclusion>(exclusions.length);
        for (String exclusion : exclusions) {
            String[] parts = exclusion.split(":");
            list.add(new Exclusion(parts[0], parts[1], "*", "*"));
        }
        Dependency dependency = new Dependency((Artifact)artifact, scope, Boolean.valueOf(false), list);
        this.dependencies.add(dependency);
    }

    public void addRepository(String id, String url) {
        RemoteRepository.Builder repo = new RemoteRepository.Builder(id, "default", url);
        repo.setSnapshotPolicy(new RepositoryPolicy(false, null, null));
        repo.setReleasePolicy(null);
        this.repos.add(repo.build());
    }

    public void addSnapshotRepository(String id, String url) {
        RemoteRepository.Builder repo = new RemoteRepository.Builder(id, "default", url);
        repo.setSnapshotPolicy(null);
        repo.setReleasePolicy(new RepositoryPolicy(false, null, null));
        this.repos.add(repo.build());
    }

    public void resolve() throws DependencyCollectionException, DependencyResolutionException {
        if (this.dependencies.size() == 0) {
            throw new IllegalArgumentException("no artifacts given");
        }
        CollectRequest collectRequest = new CollectRequest();
        for (Dependency dependency : this.dependencies) {
            collectRequest.addDependency(dependency);
        }
        for (RemoteRepository r : this.repos) {
            Proxy proxy;
            RemoteRepository mirror = this.settings.getMirrorSelector().getMirror(r);
            if (mirror != null) {
                r = mirror;
            }
            if ((proxy = this.settings.getProxySelector().getProxy(r)) != null) {
                RemoteRepository.Builder builder = new RemoteRepository.Builder(r);
                builder.setProxy(proxy);
                r = builder.build();
            }
            collectRequest.addRepository(r);
        }
        this.node = this.repoSystem.collectDependencies(this.getSession(), collectRequest).getRoot();
        DependencyRequest dependencyRequest = new DependencyRequest(this.node, null);
        this.repoSystem.resolveDependencies(this.getSession(), dependencyRequest);
    }

    public List<RemoteRepository> getRepositories() {
        return Collections.unmodifiableList(this.repos);
    }

    public List<Artifact> getArtifacts() {
        ArrayList<Artifact> result = new ArrayList<Artifact>(this.dependencies.size());
        for (Dependency dependency : this.dependencies) {
            result.add(dependency.getArtifact());
        }
        return result;
    }

    public String getClasspath() {
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        this.node.accept((DependencyVisitor)nlg);
        StringBuilder buffer = new StringBuilder(1024);
        Iterator it = nlg.getNodes().iterator();
        while (it.hasNext()) {
            Artifact artifact;
            DependencyNode node = (DependencyNode)it.next();
            if (node.getDependency() == null || (artifact = node.getDependency().getArtifact()).getFile() == null || "pom".equals(artifact.getExtension())) continue;
            buffer.append(artifact.getFile().getAbsolutePath());
            if (!it.hasNext()) continue;
            buffer.append(File.pathSeparatorChar);
        }
        return buffer.toString();
    }

    public List<String> getResolvedCoordinates() {
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        this.node.accept((DependencyVisitor)nlg);
        return Aether.generateCoordinatesForNodes(nlg.getNodes());
    }

    static List<String> generateCoordinatesForNodes(List<DependencyNode> nodes) {
        ArrayList<String> result = new ArrayList<String>();
        for (DependencyNode node : nodes) {
            Artifact artifact;
            if (node.getDependency() == null || (artifact = node.getDependency().getArtifact()).getFile() == null) continue;
            StringBuilder coord = new StringBuilder(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getExtension()).append(":");
            if (!artifact.getClassifier().isEmpty()) {
                coord.append(artifact.getClassifier()).append(":");
            }
            coord.append(artifact.getVersion());
            result.add(coord.toString());
        }
        return result;
    }

    public void install(String coordinate, String file) throws InstallationException {
        LocalRepositoryManager lrm = this.getSession().getLocalRepositoryManager();
        DefaultArtifact artifact = new DefaultArtifact(coordinate);
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact((Artifact)artifact));
        if (!dstFile.exists()) {
            artifact = artifact.setFile(new File(file));
            InstallRequest request = new InstallRequest();
            request.addArtifact((Artifact)artifact);
            this.installer.install(this.getSession(), request);
        }
    }
}

