/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.RDN;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class DXEntry
extends DXAttributes {
    DN dn = null;
    public static final int NORMAL = 0;
    public static final int NEW = 1;
    public static final int NEW_WRITTEN = 2;
    private int status = 0;

    public DXEntry() {
    }

    public DXEntry(DN dn) {
        this.dn = dn;
    }

    public DXEntry(Attribute a) {
        super(a);
    }

    public DXEntry(Attributes a) {
        super(a);
    }

    public DXEntry(Attributes a, DN dn) {
        super(a);
        this.dn = dn;
    }

    public DXEntry(Hashtable newAtts) {
        super(newAtts);
    }

    public DXEntry(NamingEnumeration newAtts) {
        super(newAtts);
    }

    public DXEntry(DXEntry copyMe) {
        super(copyMe);
        this.dn = copyMe.dn;
        this.status = copyMe.status;
    }

    public Attribute put(Attribute attr) {
        if (attr.getID().equalsIgnoreCase("dn")) {
            try {
                Object o = attr.get();
                this.dn = o instanceof String ? new DN((String)o) : new DN(o.toString());
            }
            catch (NamingException e) {
                CBUtility.error("Unexpected exception in DXEntry.put.", e);
            }
            return null;
        }
        return super.put(attr);
    }

    public void setStatus(int entryStatus) {
        this.status = entryStatus;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStringStatus() {
        switch (this.status) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "New";
            }
            case 2: {
                return "Newly Written";
            }
        }
        return "Unknown";
    }

    public boolean isNewEntry() {
        return this.status == 1 || this.status == 2;
    }

    public void putDN(DN dn) {
        this.setDN(dn);
    }

    public void setDN(DN dn) {
        this.dn = dn;
    }

    public DN getDN() {
        return this.dn == null ? new DN() : this.dn;
    }

    public String toString() {
        return "entry = " + this.getDN().toString() + "\n status: " + this.getStringStatus() + "\n" + super.toString();
    }

    public String getString(String id) {
        Attribute a = this.get(id);
        try {
            return a.get().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public RDN getRDN() {
        if (this.dn == null) {
            return null;
        }
        return this.dn.getLowestRDN();
    }
}

