/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.asn1;

import impl.krypt.asn1.Length;
import impl.krypt.asn1.ParseException;
import impl.krypt.asn1.ParsedHeader;
import impl.krypt.asn1.SerializeException;
import impl.krypt.asn1.Tag;
import impl.krypt.asn1.TagClass;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.Streams;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyHeader
extends RubyObject {
    private final ParsedHeader h;
    private final IRubyObject tag;
    private final IRubyObject tagClass;
    private final IRubyObject isConstructed;
    private final IRubyObject isInfLen;
    private final IRubyObject len;
    private final IRubyObject hlen;
    private IRubyObject cachedValue;

    public static void createHeader(Ruby runtime, RubyModule mASN1) {
        mASN1.defineClassUnder("Header", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).defineAnnotatedMethods(RubyHeader.class);
    }

    public RubyHeader(Ruby runtime, RubyClass type, ParsedHeader h) {
        super(runtime, type);
        if (h == null) {
            throw new NullPointerException();
        }
        this.h = h;
        Tag t = h.getTag();
        Length l = h.getLength();
        this.tag = runtime.newFixnum(t.getTag());
        this.tagClass = RubyHeader.tagClassFor(runtime, t.getTagClass());
        this.isConstructed = runtime.newBoolean(t.isConstructed());
        this.isInfLen = runtime.newBoolean(l.isInfiniteLength());
        this.len = runtime.newFixnum(l.getLength());
        this.hlen = runtime.newFixnum(h.getHeaderLength());
    }

    static IRubyObject tagClassFor(Ruby runtime, TagClass tc) {
        switch (tc) {
            case UNIVERSAL: {
                return RubySymbol.newSymbol((Ruby)runtime, (String)TagClass.UNIVERSAL.name());
            }
            case CONTEXT_SPECIFIC: {
                return RubySymbol.newSymbol((Ruby)runtime, (String)TagClass.CONTEXT_SPECIFIC.name());
            }
            case APPLICATION: {
                return RubySymbol.newSymbol((Ruby)runtime, (String)TagClass.APPLICATION.name());
            }
            case PRIVATE: {
                return RubySymbol.newSymbol((Ruby)runtime, (String)TagClass.PRIVATE.name());
            }
        }
        throw runtime.newRuntimeError("Unknown TagClass " + (Object)((Object)tc));
    }

    @JRubyMethod
    public IRubyObject tag() {
        return this.tag;
    }

    @JRubyMethod
    public IRubyObject tag_class() {
        return this.tagClass;
    }

    @JRubyMethod(name={"constructed?"})
    public IRubyObject is_constructed() {
        return this.isConstructed;
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject is_infinite() {
        return this.isInfLen;
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.len;
    }

    @JRubyMethod(name={"header_size", "header_length"})
    public IRubyObject header_size() {
        return this.hlen;
    }

    @JRubyMethod
    public IRubyObject encode_to(ThreadContext ctx, IRubyObject io) {
        Ruby runtime = ctx.getRuntime();
        OutputStream out = Streams.tryWrapAsOuputStream(runtime, io);
        try {
            this.h.encodeTo(out);
            return this;
        }
        catch (SerializeException ex) {
            throw Errors.newSerializeError(runtime, ex.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject bytes(ThreadContext ctx) {
        Ruby runtime = ctx.getRuntime();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.h.encodeTo(baos);
            return runtime.newString(new ByteList(baos.toByteArray(), false));
        }
        catch (SerializeException ex) {
            throw Errors.newSerializeError(runtime, ex.getMessage());
        }
    }

    @JRubyMethod
    public synchronized IRubyObject skip_value() {
        this.h.skipValue();
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject value(ThreadContext ctx) {
        if (this.cachedValue == null) {
            this.cachedValue = this.readValue(ctx);
        }
        return this.cachedValue;
    }

    private IRubyObject readValue(ThreadContext ctx) {
        Ruby runtime = ctx.getRuntime();
        try {
            byte[] value = this.h.getValue();
            if (value == null || value.length == 0) {
                return runtime.getNil();
            }
            return runtime.newString(new ByteList(value, false));
        }
        catch (ParseException ex) {
            throw Errors.newParseError(runtime, ex.getMessage());
        }
    }

    @JRubyMethod(optional=1)
    public synchronized IRubyObject value_io(ThreadContext ctx, IRubyObject[] args) {
        Ruby runtime = ctx.getRuntime();
        IRubyObject valuesOnly = args.length > 0 ? args[0] : RubyBoolean.newBoolean((Ruby)runtime, (boolean)true);
        try {
            InputStream valueStream = this.h.getValueStream(valuesOnly.isTrue());
            RubyIO io = new RubyIO(runtime, valueStream);
            RubyEncoding binaryEncoding = RubyEncoding.newEncoding((Ruby)runtime, (Encoding)runtime.getEncodingService().getAscii8bitEncoding());
            io.set_encoding(ctx, (IRubyObject)binaryEncoding);
            return io;
        }
        catch (ParseException ex) {
            throw Errors.newParseError(runtime, ex.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject to_s(ThreadContext ctx) {
        Tag t = this.h.getTag();
        Length l = this.h.getLength();
        String s = "Tag: " + t.getTag() + " Tag Class: " + t.getTagClass().name() + " Length: " + l.getLength() + " Header Length: " + this.h.getHeaderLength() + " Constructed: " + t.isConstructed() + " Infinite Length: " + l.isInfiniteLength();
        return ctx.getRuntime().newString(s);
    }
}

