/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread_safe;

import java.io.IOException;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.thread_safe.jsr166e.ConcurrentHashMap;
import org.jruby.ext.thread_safe.jsr166e.ConcurrentHashMapV8;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class JRubyCacheBackendLibrary
implements Library {
    private static final ObjectAllocator BACKEND_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new JRubyCacheBackend(runtime, klazz);
        }
    };

    public void load(Ruby runtime, boolean wrap) throws IOException {
        RubyClass jrubyRefClass = runtime.defineClassUnder("JRubyCacheBackend", runtime.getObject(), BACKEND_ALLOCATOR, runtime.getModule("ThreadSafe"));
        jrubyRefClass.setAllocator(BACKEND_ALLOCATOR);
        jrubyRefClass.defineAnnotatedMethods(JRubyCacheBackend.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JRubyClass(name={"JRubyCacheBackend"}, parent="Object")
    public static class JRubyCacheBackend
    extends RubyObject {
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        public static final boolean CAN_USE_UNSAFE_CHM = JRubyCacheBackend.canUseUnsafeCHM();
        private ConcurrentHashMap<IRubyObject, IRubyObject> map;

        private static ConcurrentHashMap<IRubyObject, IRubyObject> newCHM(int initialCapacity, float loadFactor) {
            if (CAN_USE_UNSAFE_CHM) {
                return new ConcurrentHashMapV8<IRubyObject, IRubyObject>(initialCapacity, loadFactor);
            }
            return new org.jruby.ext.thread_safe.jsr166e.nounsafe.ConcurrentHashMapV8<IRubyObject, IRubyObject>(initialCapacity, loadFactor);
        }

        private static ConcurrentHashMap<IRubyObject, IRubyObject> newCHM() {
            return JRubyCacheBackend.newCHM(16, 0.75f);
        }

        private static boolean canUseUnsafeCHM() {
            try {
                new ConcurrentHashMapV8();
                return true;
            }
            catch (Throwable t) {
                if (t.getMessage().contains("Could not initialize intrinsics") || JRubyCacheBackend.isCausedBySecurityException(t)) {
                    return false;
                }
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
        }

        private static boolean isCausedBySecurityException(Throwable t) {
            while (t != null) {
                if (t instanceof SecurityException) {
                    return true;
                }
                t = t.getCause();
            }
            return false;
        }

        public JRubyCacheBackend(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context) {
            this.map = JRubyCacheBackend.newCHM();
            return context.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject options) {
            this.map = this.toCHM(context, options);
            return context.getRuntime().getNil();
        }

        private ConcurrentHashMap<IRubyObject, IRubyObject> toCHM(ThreadContext context, IRubyObject options) {
            Ruby runtime = context.getRuntime();
            if (!options.isNil() && options.respondsTo("[]")) {
                IRubyObject rInitialCapacity = options.callMethod(context, "[]", (IRubyObject)runtime.newSymbol("initial_capacity"));
                IRubyObject rLoadFactor = options.callMethod(context, "[]", (IRubyObject)runtime.newSymbol("load_factor"));
                int initialCapacity = !rInitialCapacity.isNil() ? RubyNumeric.num2int((IRubyObject)rInitialCapacity.convertToInteger()) : 16;
                float loadFactor = !rLoadFactor.isNil() ? (float)RubyNumeric.num2dbl((IRubyObject)rLoadFactor.convertToFloat()) : 0.75f;
                return JRubyCacheBackend.newCHM(initialCapacity, loadFactor);
            }
            return JRubyCacheBackend.newCHM();
        }

        @JRubyMethod(name={"[]"}, required=1)
        public IRubyObject op_aref(ThreadContext context, IRubyObject key) {
            IRubyObject value = this.map.get(key);
            return value == null ? context.getRuntime().getNil() : value;
        }

        @JRubyMethod(name={"[]="}, required=2)
        public IRubyObject op_aset(IRubyObject key, IRubyObject value) {
            this.map.put(key, value);
            return value;
        }

        @JRubyMethod
        public IRubyObject put_if_absent(IRubyObject key, IRubyObject value) {
            IRubyObject result = this.map.putIfAbsent(key, value);
            return result == null ? this.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public IRubyObject compute_if_absent(final ThreadContext context, IRubyObject key, final Block block) {
            return this.map.computeIfAbsent(key, new ConcurrentHashMap.Fun<IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject key) {
                    return block.yieldSpecific(context);
                }
            });
        }

        @JRubyMethod
        public IRubyObject compute_if_present(final ThreadContext context, IRubyObject key, final Block block) {
            IRubyObject result = this.map.computeIfPresent(key, new ConcurrentHashMap.BiFun<IRubyObject, IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject key, IRubyObject oldValue) {
                    IRubyObject result = block.yieldSpecific(context, oldValue == null ? context.getRuntime().getNil() : oldValue);
                    return result.isNil() ? null : result;
                }
            });
            return result == null ? context.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public IRubyObject compute(final ThreadContext context, IRubyObject key, final Block block) {
            IRubyObject result = this.map.compute(key, new ConcurrentHashMap.BiFun<IRubyObject, IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject key, IRubyObject oldValue) {
                    IRubyObject result = block.yieldSpecific(context, oldValue == null ? context.getRuntime().getNil() : oldValue);
                    return result.isNil() ? null : result;
                }
            });
            return result == null ? context.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public IRubyObject merge_pair(final ThreadContext context, IRubyObject key, IRubyObject value, final Block block) {
            IRubyObject result = this.map.merge(key, value, new ConcurrentHashMap.BiFun<IRubyObject, IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject oldValue, IRubyObject newValue) {
                    IRubyObject result = block.yieldSpecific(context, oldValue == null ? context.getRuntime().getNil() : oldValue);
                    return result.isNil() ? null : result;
                }
            });
            return result == null ? context.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public RubyBoolean replace_pair(IRubyObject key, IRubyObject oldValue, IRubyObject newValue) {
            return this.getRuntime().newBoolean(this.map.replace(key, oldValue, newValue));
        }

        @JRubyMethod(name={"key?"}, required=1)
        public RubyBoolean has_key_p(IRubyObject key) {
            return this.map.containsKey(key) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public IRubyObject key(IRubyObject value) {
            IRubyObject key = this.map.findKey(value);
            return key == null ? this.getRuntime().getNil() : key;
        }

        @JRubyMethod
        public IRubyObject replace_if_exists(IRubyObject key, IRubyObject value) {
            IRubyObject result = this.map.replace(key, value);
            return result == null ? this.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public IRubyObject get_and_set(IRubyObject key, IRubyObject value) {
            IRubyObject result = this.map.put(key, value);
            return result == null ? this.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public IRubyObject delete(IRubyObject key) {
            IRubyObject result = this.map.remove(key);
            return result == null ? this.getRuntime().getNil() : result;
        }

        @JRubyMethod
        public RubyBoolean delete_pair(IRubyObject key, IRubyObject value) {
            return this.getRuntime().newBoolean(this.map.remove(key, value));
        }

        @JRubyMethod
        public IRubyObject clear() {
            this.map.clear();
            return this;
        }

        @JRubyMethod
        public IRubyObject each_pair(ThreadContext context, Block block) {
            for (Map.Entry<IRubyObject, IRubyObject> entry : this.map.entrySet()) {
                block.yieldSpecific(context, entry.getKey(), entry.getValue());
            }
            return this;
        }

        @JRubyMethod
        public RubyFixnum size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.map.size());
        }

        @JRubyMethod
        public IRubyObject get_or_default(IRubyObject key, IRubyObject defaultValue) {
            return this.map.getValueOrDefault(key, defaultValue);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public JRubyCacheBackend initialize_copy(ThreadContext context, IRubyObject other) {
            this.map = JRubyCacheBackend.newCHM();
            return this;
        }
    }
}

