/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.Token;
import org.jruby.util.ByteList;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int flags, int begin, int end) {
        this.flags = flags;
        this.begin = (char)begin;
        this.end = (char)end;
        this.nest = 0;
    }

    protected ByteList createByteList(RipperLexer lexer) {
        return new ByteList(new byte[0], lexer.getEncoding());
    }

    private int endFound(RipperLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        if ((this.flags & 8) != 0) {
            this.flags = -1;
            buffer.append((int)this.end);
            return 32;
        }
        if ((this.flags & 4) != 0) {
            String options = this.parseRegexpFlags(lexer, src);
            buffer.append(options.getBytes());
            return 380;
        }
        buffer.append((int)this.end);
        lexer.setValue(new Token(buffer));
        return 372;
    }

    @Override
    public int parseString(RipperLexer lexer, LexerSource src) throws IOException {
        boolean spaceSeen = false;
        if (this.flags == -1) {
            lexer.setValue(new Token("" + this.end));
            lexer.ignoreNextScanEvent = true;
            return 372;
        }
        ByteList buffer = this.createByteList(lexer);
        int c = lexer.nextc();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            do {
                buffer.append((int)((char)c));
            } while (Character.isWhitespace(c = lexer.nextc()));
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer, src, buffer);
        }
        if (spaceSeen) {
            lexer.pushback(c);
            lexer.setValue(new Token(buffer));
            return 32;
        }
        if ((this.flags & 2) != 0 && c == 35) {
            c = lexer.nextc();
            switch (c) {
                case 36: 
                case 64: {
                    lexer.pushback(c);
                    return 371;
                }
                case 123: {
                    return 370;
                }
            }
            buffer.append((byte)35);
        }
        lexer.pushback(c);
        Encoding[] enc = new Encoding[]{lexer.getEncoding()};
        if (this.parseStringIntoBuffer(lexer, src, buffer, enc) == -1) {
            if ((this.flags & 4) != 0) {
                if (lexer.eofp) {
                    lexer.compile_error("unterminated regexp meets end of file");
                }
                return 380;
            }
            if (lexer.eofp) {
                lexer.compile_error("unterminated string meets end of file");
            }
            return 372;
        }
        lexer.setValue(lexer.createStr(buffer, this.flags));
        lexer.flush_string_content(enc[0]);
        return 377;
    }

    private String parseRegexpFlags(RipperLexer lexer, LexerSource src) throws IOException {
        StringBuilder buf = new StringBuilder("" + this.end);
        StringBuilder unknownFlags = new StringBuilder(10);
        int c = lexer.nextc();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 101: 
                case 105: 
                case 109: 
                case 110: 
                case 111: 
                case 115: 
                case 117: 
                case 120: {
                    buf.append((char)c);
                    break;
                }
                default: {
                    unknownFlags.append((char)c);
                }
            }
            c = lexer.nextc();
        }
        lexer.pushback(c);
        if (unknownFlags.length() != 0) {
            lexer.compile_error("unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags.toString());
        }
        return buf.toString();
    }

    private void mixedEscape(RipperLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        lexer.compile_error(" mixed within " + parserEncoding);
    }

    public int parseStringIntoBuffer(RipperLexer lexer, LexerSource src, ByteList buffer, Encoding[] enc) throws IOException {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean regexp = (this.flags & 4) != 0;
        boolean symbol = (this.flags & 0x10) != 0;
        boolean hasNonAscii = false;
        block5: while ((c = lexer.nextc()) != -1) {
            block28: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                if (this.begin == '\u0000' || c != this.begin) break block27;
                                ++this.nest;
                                break block28;
                            }
                            if (c != this.end) break block29;
                            if (this.nest == 0) {
                                lexer.pushback(c);
                                break;
                            }
                            --this.nest;
                            break block28;
                        }
                        if (!expand || c != 35 || lexer.peek(10)) break block30;
                        int c2 = lexer.nextc();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            lexer.pushback(c2);
                            lexer.pushback(c);
                            break;
                        }
                        lexer.pushback(c2);
                        break block28;
                    }
                    if (c != 92) break block31;
                    c = lexer.nextc();
                    switch (c) {
                        case 10: {
                            if (qwords) break;
                            if (expand) continue block5;
                            buffer.append(92);
                            break;
                        }
                        case 92: {
                            if (escape) {
                                buffer.append(c);
                                break;
                            }
                            break block28;
                        }
                        case 117: {
                            if (!expand) {
                                buffer.append(92);
                                break;
                            }
                            if (regexp) {
                                lexer.readUTFEscapeRegexpLiteral(buffer);
                            } else {
                                lexer.readUTFEscape(buffer, true, symbol);
                            }
                            if (!hasNonAscii || buffer.getEncoding() == enc[0]) continue block5;
                            this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                            continue block5;
                        }
                        default: {
                            if (c == -1) {
                                return -1;
                            }
                            if (!Encoding.isAscii((int)c)) {
                                if (expand) {
                                    buffer.append(92);
                                }
                                hasNonAscii = true;
                                if (buffer.getEncoding() != enc[0]) {
                                    this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                    continue block5;
                                }
                                if (lexer.tokenAddMBC(c, buffer) != -1) continue block5;
                                return -1;
                            }
                            if (regexp) {
                                if (c == this.end && !this.simple_re_meta(c)) {
                                    buffer.append(c);
                                    continue block5;
                                }
                                lexer.pushback(c);
                                this.parseEscapeIntoBuffer(lexer, src, buffer);
                                if (!hasNonAscii || buffer.getEncoding() == enc[0]) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                continue block5;
                            }
                            if (expand) {
                                lexer.pushback(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block28;
                        }
                    }
                    break block28;
                }
                if (!Encoding.isAscii((byte)((byte)c))) {
                    if (buffer.getEncoding() != enc[0]) {
                        this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                        continue;
                    }
                    if ((c = lexer.readCodepoint(c, enc[0])) == -2) {
                        lexer.compile_error("invalid multibyte char (" + enc[0] + ")");
                        continue;
                    }
                    if (lexer.tokenAddMBC(c, buffer) != -1) continue;
                    return -1;
                }
                if (qwords && Character.isWhitespace(c)) {
                    lexer.pushback(c);
                    break;
                }
            }
            if ((c & 0x80) != 0) {
                hasNonAscii = true;
                if (buffer.getEncoding() != enc[0]) {
                    this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                }
            }
            buffer.append(c);
        }
        enc[0] = buffer.getEncoding();
        return c;
    }

    private boolean simple_re_meta(int c) {
        switch (c) {
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void escaped(RipperLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(lexer, src, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(RipperLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i = 0; i < 2; ++i) {
                    c = lexer.nextc();
                    if (c == -1) {
                        lexer.compile_error("Invalid escape character syntax");
                    }
                    if (!RipperLexer.isOctChar(c)) {
                        lexer.pushback(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = lexer.nextc();
                if (!RipperLexer.isHexChar(c)) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(c);
                c = lexer.nextc();
                if (RipperLexer.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                lexer.pushback(c);
                break;
            }
            case 77: {
                c = lexer.nextc();
                if (c != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(lexer, src, buffer);
                break;
            }
            case 67: {
                c = lexer.nextc();
                if (c != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(lexer, src, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(lexer, src, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

