/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import org.jcodings.Encoding;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.util.ByteList;

public class ByteListLexerSource
extends LexerSource {
    private ByteList completeSource;
    private int offset = 0;

    public ByteListLexerSource(String sourceName, int line, ByteList in) {
        super(sourceName, line);
        this.completeSource = in;
    }

    @Override
    public Encoding getEncoding() {
        return this.completeSource.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding) {
        this.completeSource.setEncoding(encoding);
    }

    @Override
    public ByteList gets() {
        int end;
        int length = this.completeSource.length();
        if (this.offset == length) {
            return null;
        }
        for (end = this.offset; end < length; ++end) {
            if (this.completeSource.get(end) != 10) continue;
            ++end;
            break;
        }
        ByteList line = this.completeSource.makeShared(this.offset, end - this.offset);
        this.offset = end;
        return line;
    }
}

