/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.provider.jdk.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ext.krypt.impl.digest.RIPEMD160;
import org.jruby.ext.krypt.provider.Digest;
import org.jruby.ext.krypt.provider.jdk.Algorithms;

public class JdkDigest
implements Digest {
    private static final Map<Algorithms.JavaAlgorithm, Integer> blockLengthMap = new HashMap<Algorithms.JavaAlgorithm, Integer>();
    private final MessageDigest md;
    private final Algorithms.JavaAlgorithm algorithm;
    private final int blockLength;

    public JdkDigest(Algorithms.JavaAlgorithm algorithm) throws NoSuchAlgorithmException {
        this.md = JdkDigest.createMessageDigest(algorithm);
        this.algorithm = algorithm;
        this.blockLength = blockLengthMap.get(algorithm);
    }

    private static MessageDigest createMessageDigest(Algorithms.JavaAlgorithm algorithm) throws NoSuchAlgorithmException {
        if (Algorithms.RIPEMD160.equals(algorithm)) {
            return new RIPEMD160();
        }
        return MessageDigest.getInstance(algorithm.getCanonicalJavaName());
    }

    public byte[] digest() {
        return this.md.digest();
    }

    public byte[] digest(byte[] data) {
        return this.md.digest(data);
    }

    public void update(byte[] data, int off, int len) {
        this.md.update(data, off, len);
    }

    public void reset() {
        this.md.reset();
    }

    public String getName() {
        return this.algorithm.getCanonicalRubyName();
    }

    public int getDigestLength() {
        return this.md.getDigestLength();
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    static {
        blockLengthMap.put(Algorithms.SHA1, 64);
        blockLengthMap.put(Algorithms.SHA224, 64);
        blockLengthMap.put(Algorithms.SHA256, 64);
        blockLengthMap.put(Algorithms.SHA384, 128);
        blockLengthMap.put(Algorithms.SHA512, 128);
        blockLengthMap.put(Algorithms.RIPEMD160, 64);
        blockLengthMap.put(Algorithms.MD5, 64);
    }
}

