/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509StoreContext;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Store
extends RubyObject {
    private static final long serialVersionUID = -2969708892287379665L;
    private static ObjectAllocator X509STORE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Store(runtime, klass);
        }
    };
    private final Store store = new Store();
    private static Store.VerifyCallbackFunction verifyCallback = new Store.VerifyCallbackFunction(){

        @Override
        public int call(StoreContext context, Integer outcome) {
            int ok = outcome;
            IRubyObject proc = (IRubyObject)context.getExtraData(1);
            if (proc == null) {
                proc = (IRubyObject)context.getStore().getExtraData(0);
            }
            if (proc == null) {
                return ok;
            }
            if (!proc.isNil()) {
                Ruby runtime = proc.getRuntime();
                RubyClass _StoreContext = X509Store.getX509StoreContext(runtime);
                X509StoreContext rubyContext = new X509StoreContext(runtime, _StoreContext, context);
                IRubyObject ret = proc.callMethod(runtime.getCurrentContext(), "call", new IRubyObject[]{runtime.newBoolean(ok != 0), rubyContext});
                if (ret.isTrue()) {
                    context.setError(0);
                    ok = 1;
                } else {
                    if (context.getError() == 0) {
                        context.setError(28);
                    }
                    ok = 0;
                }
            }
            return ok;
        }
    };

    public static void createX509Store(Ruby runtime, RubyModule mX509) {
        RubyClass cX509Store = mX509.defineClassUnder("Store", runtime.getObject(), X509STORE_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("StoreError", openSSLError, openSSLError.getAllocator());
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "verify_callback");
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "error");
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "error_string");
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "chain");
        cX509Store.defineAnnotatedMethods(X509Store.class);
        X509StoreContext.createX509StoreContext(runtime, mX509);
    }

    public X509Store(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    final Store getStore() {
        return this.store;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject nil = runtime.getNil();
        RubyFixnum zero = RubyFixnum.zero((Ruby)runtime);
        this.store.setVerifyCallbackFunction(verifyCallback);
        this.set_verify_callback(nil);
        this.setInstanceVariable("@flags", (IRubyObject)zero);
        this.setInstanceVariable("@purpose", (IRubyObject)zero);
        this.setInstanceVariable("@trust", (IRubyObject)zero);
        this.setInstanceVariable("@error", nil);
        this.setInstanceVariable("@error_string", nil);
        this.setInstanceVariable("@chain", nil);
        this.setInstanceVariable("@time", nil);
        return this;
    }

    @JRubyMethod(name={"verify_callback="})
    public IRubyObject set_verify_callback(IRubyObject cb) {
        this.store.setExtraData(1, cb);
        this.setInstanceVariable("@verify_callback", cb);
        return cb;
    }

    @JRubyMethod(name={"flags="})
    public IRubyObject set_flags(IRubyObject arg) {
        this.store.setFlags(RubyNumeric.fix2long((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"purpose="})
    public IRubyObject set_purpose(IRubyObject arg) {
        this.store.setPurpose(RubyNumeric.fix2int((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"trust="})
    public IRubyObject set_trust(IRubyObject arg) {
        this.store.setTrust(RubyNumeric.fix2int((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject arg) {
        this.setInstanceVariable("@time", arg);
        return arg;
    }

    @JRubyMethod
    public IRubyObject add_path(ThreadContext context, IRubyObject arg) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: Store#add_path");
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject add_file(ThreadContext context, IRubyObject arg) {
        String file = arg.toString();
        try {
            this.store.loadLocations(file, null);
        }
        catch (Exception e) {
            if (OpenSSLReal.isDebug(context.runtime)) {
                e.printStackTrace(context.runtime.getOut());
            }
            X509Store.raiseStoreError(context, "loading file failed: " + e.getMessage());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_default_paths(ThreadContext context) {
        try {
            this.store.setDefaultPaths();
        }
        catch (Exception e) {
            if (OpenSSLReal.isDebug(context.runtime)) {
                e.printStackTrace(context.runtime.getOut());
            }
            X509Store.raiseStoreError(context, "setting default path failed: " + e.getMessage());
        }
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject add_cert(ThreadContext context, IRubyObject _cert) {
        X509AuxCertificate cert;
        X509AuxCertificate x509AuxCertificate = cert = _cert instanceof X509Cert ? ((X509Cert)_cert).getAuxCert() : (X509AuxCertificate)null;
        if (this.store.addCertificate(cert) != 1) {
            X509Store.raiseStoreError(context, null);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject add_crl(ThreadContext context, IRubyObject arg) {
        java.security.cert.X509CRL crl;
        java.security.cert.X509CRL x509CRL = crl = arg instanceof X509CRL ? ((X509CRL)arg).getCRL() : null;
        if (this.store.addCRL(crl) != 1) {
            X509Store.raiseStoreError(context, null);
        }
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject verify(ThreadContext context, IRubyObject[] args, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject cert = args[0];
        IRubyObject chain = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2) == 2 ? args[1] : runtime.getNil();
        Object verify_callback = block.isGiven() ? runtime.newProc(Block.Type.PROC, block) : this.getInstanceVariable("@verify_callback");
        RubyClass _StoreContext = X509Store.getX509StoreContext(runtime);
        X509StoreContext storeContext = (X509StoreContext)_StoreContext.callMethod(context, "new", new IRubyObject[]{this, cert, chain});
        storeContext.setInstanceVariable("@verify_callback", (IRubyObject)verify_callback);
        IRubyObject result = storeContext.callMethod(context, "verify");
        this.setInstanceVariable("@error", storeContext.error(context));
        this.setInstanceVariable("@error_string", storeContext.error_string(context));
        this.setInstanceVariable("@chain", storeContext.chain(context));
        return result;
    }

    private static RubyClass getX509StoreError(Ruby runtime) {
        return (RubyClass)runtime.getClassFromPath("OpenSSL::X509::StoreError");
    }

    private static RubyClass getX509StoreContext(Ruby runtime) {
        return (RubyClass)runtime.getClassFromPath("OpenSSL::X509::StoreContext");
    }

    private static void raiseStoreError(ThreadContext context, String msg) {
        RubyClass _StoreError = X509Store.getX509StoreError(context.runtime);
        throw new RaiseException(context.runtime, _StoreError, msg, true);
    }
}

