/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Utils {
    private Utils() {
    }

    @Deprecated
    public static String toHex(byte[] val) {
        StringBuilder out = new StringBuilder();
        int j = val.length;
        for (int i = 0; i < j; ++i) {
            String ve = Integer.toString((char)val[i] & 0xFF, 16);
            if (ve.length() == 1) {
                out.append('0');
            }
            out.append(ve);
        }
        return out.toString();
    }

    @Deprecated
    public static String toHex(byte[] val, char sep) {
        StringBuilder out = new StringBuilder();
        String sepStr = Character.toString(sep);
        String separator = "";
        int j = val.length;
        for (int i = 0; i < j; ++i) {
            out.append(separator);
            String ve = Integer.toString((char)val[i] & 0xFF, 16);
            if (ve.length() == 1) {
                out.append('0');
            }
            out.append(ve);
            separator = sepStr;
        }
        return out.toString().toUpperCase();
    }

    @Deprecated
    public static void checkKind(Ruby rt, IRubyObject obj, String path) {
        if (((RubyObject)obj).kind_of_p(rt.getCurrentContext(), (IRubyObject)rt.getClassFromPath(path)).isFalse()) {
            throw rt.newTypeError(String.format("wrong argument (%s)! (Expected kind of %s)", obj.getMetaClass().getName(), path));
        }
    }

    @Deprecated
    public static RubyClass getClassFromPath(Ruby rt, String path) {
        return (RubyClass)rt.getClassFromPath(path);
    }

    static RaiseException newIOError(Ruby runtime, IOException e) {
        return new RaiseException(runtime, runtime.getIOError(), e.getMessage(), true);
    }

    static RaiseException newRuntimeError(Ruby runtime, Exception e) {
        return new RaiseException(runtime, runtime.getRuntimeError(), e.getMessage(), true);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, String message, boolean nativeException) {
        return new RaiseException(runtime, errorClass, message, nativeException);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, Exception e) {
        return new RaiseException(runtime, errorClass, e.getMessage(), true);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, String msg) {
        return new RaiseException(runtime, errorClass, msg, true);
    }

    @Deprecated
    public static RaiseException newError(Ruby rt, String path, String message) {
        return new RaiseException(rt, (RubyClass)rt.getClassFromPath(path), message, true);
    }

    @Deprecated
    public static RaiseException newError(Ruby rt, String path, String message, boolean nativeException) {
        return new RaiseException(rt, (RubyClass)rt.getClassFromPath(path), message, nativeException);
    }

    @Deprecated
    public static IRubyObject newRubyInstance(Ruby rt, String path) {
        return rt.getClassFromPath(path).callMethod(rt.getCurrentContext(), "new");
    }

    @Deprecated
    public static IRubyObject newRubyInstance(Ruby rt, String path, IRubyObject arg) {
        return rt.getClassFromPath(path).callMethod(rt.getCurrentContext(), "new", arg);
    }

    @Deprecated
    public static IRubyObject newRubyInstance(Ruby rt, String path, IRubyObject ... args) {
        return rt.getClassFromPath(path).callMethod(rt.getCurrentContext(), "new", args);
    }

    @Deprecated
    static IRubyObject newRubyInstance(ThreadContext context, String path) {
        RubyModule klass = context.runtime.getClassFromPath(path);
        return klass.callMethod(context, "new");
    }

    @Deprecated
    static IRubyObject newRubyInstance(ThreadContext context, String path, IRubyObject arg) {
        RubyModule klass = context.runtime.getClassFromPath(path);
        return klass.callMethod(context, "new", arg);
    }

    @Deprecated
    static IRubyObject newRubyInstance(ThreadContext context, String path, IRubyObject ... args) {
        RubyModule klass = context.runtime.getClassFromPath(path);
        return klass.callMethod(context, "new", args);
    }

    static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, Block block) {
        return self.getMetaClass().finvoke(context, self, name, block);
    }

    static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
        return Utils.invokeSuper(context, self, context.getFrameKlazz(), context.getFrameName(), args, block);
    }

    static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, RubyModule klass, String name, IRubyObject[] args, Block block) {
        Utils.checkSuperDisabledOrOutOfMethod(context, klass, name);
        RubyClass superClass = Utils.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klass).getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(name) : UndefinedMethod.INSTANCE;
        return method.call(context, self, (RubyModule)superClass, name, args, block);
    }

    private static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule klass, String name) {
        if (klass == null) {
            if (name != null) {
                throw context.runtime.newNameError("superclass method '" + name + "' disabled", name);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.nil);
        }
    }

    private static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass != null && implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass;
    }
}

