/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.KeyGenerator;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.net.ssl.SSLContext;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.jruby.ext.openssl.OpenSSLReal;

public abstract class SecurityHelper {
    private static String BC_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    static boolean setBouncyCastleProvider = true;
    static Provider securityProvider;
    private static Boolean registerProvider;
    private static Boolean tryCipherInternal;
    private static final Class<?>[] STRING_PARAM;
    private static boolean providerSSLContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Provider getSecurityProvider() {
        if (setBouncyCastleProvider && securityProvider == null) {
            Class<SecurityHelper> clazz = SecurityHelper.class;
            // MONITORENTER : org.jruby.ext.openssl.SecurityHelper.class
            if (setBouncyCastleProvider && securityProvider == null) {
                SecurityHelper.setBouncyCastleProvider();
                setBouncyCastleProvider = false;
            }
            // MONITOREXIT : clazz
        }
        SecurityHelper.doRegisterProvider();
        return securityProvider;
    }

    public static synchronized void setSecurityProvider(Provider provider) {
        securityProvider = provider;
    }

    static synchronized void setBouncyCastleProvider() {
        SecurityHelper.setSecurityProvider(SecurityHelper.newBouncyCastleProvider());
    }

    private static Provider newBouncyCastleProvider() {
        try {
            return (Provider)Class.forName(BC_PROVIDER_CLASS).newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static synchronized void setRegisterProvider(boolean register) {
        registerProvider = register;
        SecurityHelper.doRegisterProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doRegisterProvider() {
        if (registerProvider == null) return;
        Class<SecurityHelper> clazz = SecurityHelper.class;
        synchronized (SecurityHelper.class) {
            if (registerProvider != null && registerProvider.booleanValue() && securityProvider != null) {
                Security.addProvider(securityProvider);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            registerProvider = null;
            return;
        }
    }

    public static CertificateFactory getCertificateFactory(String type) throws CertificateException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null) {
                return SecurityHelper.getCertificateFactory(type, provider);
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return CertificateFactory.getInstance(type);
    }

    static CertificateFactory getCertificateFactory(String type, Provider provider) throws CertificateException {
        CertificateFactorySpi spi = (CertificateFactorySpi)SecurityHelper.getImplEngine("CertificateFactory", type);
        if (spi == null) {
            throw new CertificateException(type + " not found");
        }
        return SecurityHelper.newInstance(CertificateFactory.class, new Class[]{CertificateFactorySpi.class, Provider.class, String.class}, spi, provider, type);
    }

    public static KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null) {
                return SecurityHelper.getKeyFactory(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return KeyFactory.getInstance(algorithm);
    }

    static KeyFactory getKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyFactorySpi spi = (KeyFactorySpi)SecurityHelper.getImplEngine("KeyFactory", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(KeyFactory.class, new Class[]{KeyFactorySpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null) {
                return SecurityHelper.getKeyPairGenerator(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return KeyPairGenerator.getInstance(algorithm);
    }

    static KeyPairGenerator getKeyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator;
        Object spi = SecurityHelper.getImplEngine("KeyPairGenerator", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " KeyPairGenerator not available");
        }
        if (spi instanceof KeyPairGenerator) {
            keyPairGenerator = (KeyPairGenerator)spi;
        } else {
            Class<?> delegate;
            try {
                delegate = Class.forName(KeyPairGenerator.class.getName() + "$Delegate");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            keyPairGenerator = (KeyPairGenerator)SecurityHelper.newInstance(delegate, new Class[]{KeyPairGeneratorSpi.class, String.class}, spi, algorithm);
        }
        SecurityHelper.setField(keyPairGenerator, KeyPairGenerator.class, "provider", provider);
        return keyPairGenerator;
    }

    public static KeyStore getKeyStore(String type) throws KeyStoreException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null) {
                return SecurityHelper.getKeyStore(type, provider);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return KeyStore.getInstance(type);
    }

    static KeyStore getKeyStore(String type, Provider provider) throws KeyStoreException {
        return KeyStore.getInstance(type, provider);
    }

    public static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null) {
                return SecurityHelper.getMessageDigest(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return MessageDigest.getInstance(algorithm);
    }

    static MessageDigest getMessageDigest(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        MessageDigest messageDigest;
        Object spi = SecurityHelper.getImplEngine("MessageDigest", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        if (spi instanceof MessageDigest) {
            messageDigest = (MessageDigest)spi;
        } else {
            Class<?> delegate;
            try {
                delegate = Class.forName(MessageDigest.class.getName() + "$Delegate");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            messageDigest = (MessageDigest)SecurityHelper.newInstance(delegate, new Class[]{MessageDigestSpi.class, String.class}, spi, algorithm);
        }
        SecurityHelper.setField(messageDigest, MessageDigest.class, "provider", provider);
        return messageDigest;
    }

    public static SecureRandom getSecureRandom() {
        try {
            String algorithm;
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null && (algorithm = SecurityHelper.getSecureRandomAlgorithm(provider)) != null) {
                return SecurityHelper.getSecureRandom(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return new SecureRandom();
    }

    private static SecureRandom getSecureRandom(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        SecureRandomSpi spi = (SecureRandomSpi)SecurityHelper.getImplEngine("SecureRandom", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(SecureRandom.class, new Class[]{SecureRandomSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    private static String getSecureRandomAlgorithm(Provider provider) {
        for (Provider.Service service : provider.getServices()) {
            if (!"SecureRandom".equals(service.getType())) continue;
            return service.getAlgorithm();
        }
        return null;
    }

    public static Cipher getCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        block12: {
            Provider provider;
            block11: {
                try {
                    if (tryCipherInternal == Boolean.FALSE && (provider = SecurityHelper.getSecurityProvider()) != null) {
                        return SecurityHelper.getCipher(transformation, provider);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (NoSuchPaddingException e) {
                }
                catch (SecurityException e) {
                    if (tryCipherInternal != null) {
                        tryCipherInternal = Boolean.TRUE;
                    }
                    if (!OpenSSLReal.isDebug()) break block11;
                    e.printStackTrace();
                }
            }
            if (tryCipherInternal == Boolean.TRUE) {
                try {
                    provider = SecurityHelper.getSecurityProvider();
                    if (provider != null) {
                        return SecurityHelper.getCipherInternal(transformation, provider);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (RuntimeException e) {
                    tryCipherInternal = null;
                    if (!OpenSSLReal.isDebug()) break block12;
                    e.printStackTrace();
                }
            }
        }
        return Cipher.getInstance(transformation);
    }

    static Cipher getCipher(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(transformation, provider);
    }

    private static Cipher getCipherInternal(String transformation, Provider provider) throws NoSuchAlgorithmException {
        CipherSpi spi = (CipherSpi)SecurityHelper.getImplEngine("Cipher", transformation);
        if (spi == null) {
            StringTokenizer tok = new StringTokenizer(transformation, "/");
            String algorithm = tok.nextToken();
            spi = (CipherSpi)SecurityHelper.getImplEngine("Cipher", algorithm);
            if (spi == null) {
                throw new NoSuchAlgorithmException(transformation + " not found");
            }
            if (tok.hasMoreTokens() && !transformation.regionMatches(algorithm.length(), "//", 0, 2)) {
                SecurityHelper.invoke(spi, CipherSpi.class, "engineSetMode", STRING_PARAM, tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                SecurityHelper.invoke(spi, CipherSpi.class, "engineSetPadding", STRING_PARAM, tok.nextToken());
            }
        }
        return SecurityHelper.newInstance(Cipher.class, new Class[]{CipherSpi.class, Provider.class, String.class}, spi, provider, transformation);
    }

    public static Signature getSignature(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null) {
                return SecurityHelper.getSignature(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return Signature.getInstance(algorithm);
    }

    static Signature getSignature(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Signature signature;
        Object spi = SecurityHelper.getImplEngine("Signature", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " Signature not available");
        }
        if (spi instanceof Signature) {
            signature = (Signature)spi;
        } else {
            Class<?> delegate;
            try {
                delegate = Class.forName(Signature.class.getName() + "$Delegate");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            signature = (Signature)SecurityHelper.newInstance(delegate, new Class[]{SignatureSpi.class, String.class}, spi, algorithm);
        }
        SecurityHelper.setField(signature, Signature.class, "provider", provider);
        return signature;
    }

    public static Mac getMac(String algorithm) throws NoSuchAlgorithmException {
        Mac mac = null;
        Provider provider = SecurityHelper.getSecurityProvider();
        if (provider != null) {
            mac = SecurityHelper.getMac(algorithm, provider, true);
        }
        if (mac == null) {
            mac = Mac.getInstance(algorithm);
        }
        return mac;
    }

    static Mac getMac(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        return SecurityHelper.getMac(algorithm, provider, false);
    }

    private static Mac getMac(String algorithm, Provider provider, boolean silent) throws NoSuchAlgorithmException {
        MacSpi spi = (MacSpi)SecurityHelper.getImplEngine("Mac", algorithm);
        if (spi == null) {
            if (silent) {
                return null;
            }
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(Mac.class, new Class[]{MacSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static KeyGenerator getKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        block4: {
            try {
                Provider provider = SecurityHelper.getSecurityProvider();
                if (provider != null) {
                    return SecurityHelper.getKeyGenerator(algorithm, provider);
                }
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (SecurityException e) {
                if (!OpenSSLReal.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return KeyGenerator.getInstance(algorithm);
    }

    static KeyGenerator getKeyGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyGeneratorSpi spi = (KeyGeneratorSpi)SecurityHelper.getImplEngine("KeyGenerator", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(KeyGenerator.class, new Class[]{KeyGeneratorSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        block4: {
            try {
                Provider provider = SecurityHelper.getSecurityProvider();
                if (provider != null) {
                    return SecurityHelper.getSecretKeyFactory(algorithm, provider);
                }
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (SecurityException e) {
                if (!OpenSSLReal.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return SecretKeyFactory.getInstance(algorithm);
    }

    static SecretKeyFactory getSecretKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        SecretKeyFactorySpi spi = (SecretKeyFactorySpi)SecurityHelper.getImplEngine("SecretKeyFactory", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(SecretKeyFactory.class, new Class[]{SecretKeyFactorySpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static SSLContext getSSLContext(String protocol) throws NoSuchAlgorithmException {
        try {
            Provider provider;
            if (providerSSLContext && (provider = SecurityHelper.getSecurityProvider()) != null) {
                return SecurityHelper.getSSLContext(protocol, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return SSLContext.getInstance(protocol);
    }

    private static SSLContext getSSLContext(String protocol, Provider provider) throws NoSuchAlgorithmException {
        return SSLContext.getInstance(protocol, provider);
    }

    public static boolean verify(X509CRL crl, PublicKey publicKey) throws NoSuchAlgorithmException, CRLException, InvalidKeyException, SignatureException {
        return SecurityHelper.verify(crl, publicKey, false);
    }

    static boolean verify(X509CRL crl, PublicKey publicKey, boolean silent) throws NoSuchAlgorithmException, CRLException, InvalidKeyException, SignatureException {
        if (crl instanceof X509CRLObject) {
            CertificateList crlList = (CertificateList)SecurityHelper.getCertificateList(crl);
            AlgorithmIdentifier tbsSignatureId = crlList.getTBSCertList().getSignature();
            if (!crlList.getSignatureAlgorithm().equals((Object)tbsSignatureId)) {
                if (silent) {
                    return false;
                }
                throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
            }
            Signature signature = SecurityHelper.getSignature(crl.getSigAlgName(), securityProvider);
            signature.initVerify(publicKey);
            signature.update(crl.getTBSCertList());
            if (!signature.verify(crl.getSignature())) {
                if (silent) {
                    return false;
                }
                throw new SignatureException("CRL does not verify with supplied public key.");
            }
            return true;
        }
        try {
            crl.verify(publicKey);
            return true;
        }
        catch (NoSuchAlgorithmException ex) {
            if (silent) {
                return false;
            }
            throw ex;
        }
        catch (CRLException ex) {
            if (silent) {
                return false;
            }
            throw ex;
        }
        catch (InvalidKeyException ex) {
            if (silent) {
                return false;
            }
            throw ex;
        }
        catch (SignatureException ex) {
            if (silent) {
                return false;
            }
            throw ex;
        }
        catch (NoSuchProviderException e) {
            if (OpenSSLReal.isDebug()) {
                e.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    private static Object getCertificateList(Object crl) {
        try {
            Field cField = X509CRLObject.class.getDeclaredField("c");
            cField.setAccessible(true);
            return cField.get(crl);
        }
        catch (NoSuchFieldException ex) {
            if (OpenSSLReal.isDebug()) {
                ex.printStackTrace(System.out);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static Object getImplEngine(String baseName, String algorithm) {
        Object engine = SecurityHelper.findImplEngine(baseName, algorithm.toUpperCase(Locale.ENGLISH));
        if (engine == null) {
            engine = SecurityHelper.findImplEngine(baseName, algorithm);
        }
        return engine;
    }

    private static Object findImplEngine(String baseName, String algorithm) {
        String alias;
        Provider bcProvider = securityProvider;
        while ((alias = bcProvider.getProperty("Alg.Alias." + baseName + "." + algorithm)) != null) {
            algorithm = alias;
        }
        String className = bcProvider.getProperty(baseName + "." + algorithm);
        if (className != null) {
            try {
                ClassLoader loader = bcProvider.getClass().getClassLoader();
                Class<?> klass = loader != null ? loader.loadClass(className) : Class.forName(className);
                return klass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("algorithm " + algorithm + " in provider " + bcProvider.getName() + " but no class \"" + className + "\" found!");
            }
            catch (Exception e) {
                throw new IllegalStateException("algorithm " + algorithm + " in provider " + bcProvider.getName() + " but class \"" + className + "\" inaccessible!");
            }
        }
        return null;
    }

    private static <T> T newInstance(Class<T> klass, Class<?>[] paramTypes, Object ... params) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(paramTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> T invoke(Object object, Class<?> klass, String methodName, Class<?>[] paramTypes, Object ... params) {
        try {
            Method method = klass.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            return (T)method.invoke(object, params);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void setField(Object obj, Class<?> fieldOwner, String fieldName, Object value) {
        try {
            Field field = fieldOwner.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("no field '" + fieldName + "' declared in " + fieldOwner + "", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        registerProvider = null;
        tryCipherInternal = Boolean.FALSE;
        STRING_PARAM = new Class[]{String.class};
        providerSSLContext = false;
    }
}

