/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.Collection;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class Variable
implements TemplateEntry {
    private static final String SPECIAL_VARIABLE_PREFIX = "special:";
    private static final String SPECIAL_VALUE_EVERYTHING = "everything";
    private final String variableName;
    private final boolean special;

    public Variable(String string) {
        if (string.toLowerCase().startsWith(SPECIAL_VARIABLE_PREFIX)) {
            this.variableName = string.substring(SPECIAL_VARIABLE_PREFIX.length());
            this.special = !this.variableName.toLowerCase().startsWith(SPECIAL_VARIABLE_PREFIX);
        } else {
            this.variableName = string;
            this.special = false;
        }
    }

    @Override
    public void appendText(StringBuilder stringBuilder, TemplateEngineDataProvider templateEngineDataProvider) {
        if (this.special && SPECIAL_VALUE_EVERYTHING.equals(this.variableName)) {
            Collection<String> collection = templateEngineDataProvider.getTemplateKeys();
            boolean bl = true;
            for (String string : collection) {
                if (!bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = false;
                }
                stringBuilder.append(string).append("=").append(templateEngineDataProvider.getTemplateValue(string, false));
            }
        } else {
            Object object = templateEngineDataProvider.getTemplateValue(this.variableName, this.special);
            if (object != null) {
                stringBuilder.append(object);
            }
        }
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider templateEngineDataProvider) {
        if (this.special && SPECIAL_VALUE_EVERYTHING.equals(this.variableName)) {
            return true;
        }
        return templateEngineDataProvider.getTemplateValue(this.variableName, this.special) != null;
    }

    public String toString() {
        return "{" + this.variableName + "}";
    }

    public boolean isSpecial() {
        return this.special;
    }
}

