/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.geom.Area;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.Geometry;

public class RightAndLefthandTraffic {
    private static Collection<Area> leftHandTrafficPolygons;
    private static GeoPropertyIndex<Boolean> rlCache;

    public static synchronized boolean isRightHandTraffic(LatLon latLon) {
        if (leftHandTrafficPolygons == null) {
            RightAndLefthandTraffic.initialize();
        }
        return rlCache.get(latLon) == false;
    }

    private static void initialize() {
        leftHandTrafficPolygons = new ArrayList<Area>();
        try (InputStream inputStream = new CachedFile("resource://data/left-right-hand-traffic.osm").getInputStream();){
            DataSet dataSet = OsmReader.parseDataSet(inputStream, null);
            for (Way way : dataSet.getWays()) {
                leftHandTrafficPolygons.add(Geometry.getAreaLatLon(way.getNodes()));
            }
        }
        catch (IOException | IllegalDataException exception) {
            throw new RuntimeException(exception);
        }
        rlCache = new GeoPropertyIndex<Boolean>(new RLTrafficGeoProperty(), 24);
    }

    private static class RLTrafficGeoProperty
    implements GeoPropertyIndex.GeoProperty<Boolean> {
        private RLTrafficGeoProperty() {
        }

        @Override
        public Boolean get(LatLon latLon) {
            for (Area area : leftHandTrafficPolygons) {
                if (!area.contains(latLon.lon(), latLon.lat())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean get(BBox bBox) {
            Area area = new Area(bBox.toRectangle());
            for (Area area2 : leftHandTrafficPolygons) {
                Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(area, area2, 1.0E-10);
                if (polygonIntersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                    return true;
                }
                if (polygonIntersection == Geometry.PolygonIntersection.OUTSIDE) continue;
                return null;
            }
            return false;
        }
    }
}

