/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class ImagerySessionExporter
implements SessionLayerExporter {
    private ImageryLayer layer;
    private JCheckBox export;

    public ImagerySessionExporter(ImageryLayer imageryLayer) {
        this.layer = imageryLayer;
    }

    public ImagerySessionExporter(TMSLayer tMSLayer) {
        this((ImageryLayer)tMSLayer);
    }

    public ImagerySessionExporter(WMSLayer wMSLayer) {
        this((ImageryLayer)wMSLayer);
    }

    @Override
    public Collection<Layer> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        jLabel.setToolTipText(this.layer.getToolTipText());
        jPanel.add((Component)this.export, GBC.std());
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        return jPanel;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return false;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "imagery");
        element.setAttribute("version", "0.1");
        ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = new ImageryInfo.ImageryPreferenceEntry(this.layer.getInfo());
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(Preferences.serializeStruct(imageryPreferenceEntry, ImageryInfo.ImageryPreferenceEntry.class));
        if (this.layer instanceof WMSLayer) {
            WMSLayer wMSLayer = (WMSLayer)this.layer;
            linkedHashMap.put("automatic-downloading", Boolean.toString(wMSLayer.hasAutoDownload()));
            linkedHashMap.put("automatically-change-resolution", Boolean.toString(wMSLayer.isAutoResolution()));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Element element2 = exportSupport.createElement((String)entry.getKey());
            element.appendChild(element2);
            element2.appendChild(exportSupport.createTextNode((String)entry.getValue()));
        }
        return element;
    }
}

