/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class LoadDataHandler
extends RequestHandler {
    private static final String OSM_MIME_TYPE = "application/x-osm+xml";
    public static final String command = "load_data";
    private String data;
    private String mimeType;

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data.getBytes("UTF-8"));
            DataSet dataSet = new DataSet();
            if (this.mimeType != null && this.mimeType.contains(OSM_MIME_TYPE)) {
                dataSet = OsmReader.parseDataSet(byteArrayInputStream, null);
            }
            Main.worker.submit(new LoadDataTask(this.isLoadInNewLayer(), dataSet, (String)this.args.get("layer_name")));
        }
        catch (Exception exception) {
            Main.warn("Problem with data: " + this.data);
            throw new RequestHandler.RequestHandlerErrorException(exception);
        }
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"data"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "mime_type", "layer_name"};
    }

    @Override
    public String getUsage() {
        return "Reads data encoded directly in the URL and adds it to the current data set";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/load_data?layer_name=extra_layer&new_layer=true&data=%3Cosm%3E%3Cnode%3E...%3C%2Fnode%3E%3C%2Fosm%3E"};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load the following data:", new Object[0]) + "<br>" + this.data;
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    @Override
    protected void parseArgs() {
        String[] stringArray;
        if (this.request.indexOf(63) == -1) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.request.substring(this.request.indexOf(63) + 1);
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        this.args = hashMap;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        if (this.args.get("data") == null) {
            throw new RequestHandler.RequestHandlerBadRequestException("RemoteControl: No data defined in URL");
        }
        try {
            this.data = URLDecoder.decode((String)this.args.get("data"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RequestHandler.RequestHandlerBadRequestException("RemoteControl: UnsupportedEncodingException: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        this.mimeType = (String)this.args.get("mime_type");
        if (this.mimeType == null) {
            this.mimeType = OSM_MIME_TYPE;
        }
    }

    protected class LoadDataTask
    extends DownloadOsmTask.AbstractInternalTask {
        protected final String layerName;

        public LoadDataTask(boolean bl, DataSet dataSet, String string) {
            super(bl, I18n.tr("Loading data", new Object[0]), false);
            this.dataSet = dataSet;
            this.layerName = string;
        }

        @Override
        public void realRun() {
        }

        @Override
        protected void cancel() {
        }

        @Override
        protected void finish() {
            this.loadData(this.layerName, null);
        }
    }
}

