/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

public class JpgImporter
extends FileImporter {
    private GpxLayer gpx;
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("jpg,jpeg", "jpg", I18n.tr("Image Files", new Object[0]) + " (*.jpg)");
    public static final ExtensionFileFilter FILE_FILTER_WITH_FOLDERS = new ExtensionFileFilter("jpg,jpeg", "jpg", I18n.tr("Image Files", new Object[0]) + " (*.jpg, " + I18n.tr("folder", new Object[0]) + ")");

    public JpgImporter() {
        this(false);
    }

    public JpgImporter(boolean bl) {
        super(bl ? FILE_FILTER_WITH_FOLDERS : FILE_FILTER);
    }

    public JpgImporter(GpxLayer gpxLayer) {
        this(true);
        this.gpx = gpxLayer;
    }

    @Override
    public boolean acceptFile(File file) {
        return super.acceptFile(file) || file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(List<File> list, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        progressMonitor.beginTask(I18n.tr("Looking for image files", new Object[0]), 1);
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            HashSet<String> hashSet = new HashSet<String>();
            this.addRecursiveFiles(arrayList, hashSet, list, progressMonitor.createSubTaskMonitor(1, true));
            if (progressMonitor.isCanceled()) {
                return;
            }
            if (arrayList.isEmpty()) {
                throw new IOException(I18n.tr("No image files found.", new Object[0]));
            }
            GeoImageLayer.create(arrayList, this.gpx);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecursiveFiles(List<File> list, Set<String> set, List<File> list2, ProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor.isCanceled()) {
            return;
        }
        progressMonitor.beginTask(null, list2.size());
        try {
            for (File file : list2) {
                if (file.isDirectory()) {
                    if (set.add(file.getCanonicalPath())) {
                        File[] fileArray = file.listFiles();
                        if (fileArray == null) continue;
                        this.addRecursiveFiles(list, set, Arrays.asList(fileArray), progressMonitor.createSubTaskMonitor(1, true));
                        continue;
                    }
                    progressMonitor.worked(1);
                    continue;
                }
                if (file.getName().toLowerCase().endsWith(".jpg")) {
                    list.add(file);
                }
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public boolean isBatchImporter() {
        return true;
    }

    @Override
    public double getPriority() {
        return -1000.0;
    }
}

