/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class CellEditorSupport {
    private final CellEditor editor;
    private final List<CellEditorListener> listeners;

    public CellEditorSupport(CellEditor cellEditor) {
        this.editor = cellEditor;
        this.listeners = new LinkedList<CellEditorListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CellEditorListener> getListeners() {
        CellEditorSupport cellEditorSupport = this;
        synchronized (cellEditorSupport) {
            return new ArrayList<CellEditorListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCellEditorListener(CellEditorListener cellEditorListener) {
        CellEditorSupport cellEditorSupport = this;
        synchronized (cellEditorSupport) {
            if (cellEditorListener != null && !this.listeners.contains(cellEditorListener)) {
                this.listeners.add(cellEditorListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCellEditorListener(CellEditorListener cellEditorListener) {
        CellEditorSupport cellEditorSupport = this;
        synchronized (cellEditorSupport) {
            if (cellEditorListener != null && this.listeners.contains(cellEditorListener)) {
                this.listeners.remove(cellEditorListener);
            }
        }
    }

    public final void fireEditingCanceled() {
        for (CellEditorListener cellEditorListener : this.getListeners()) {
            cellEditorListener.editingCanceled(new ChangeEvent(this.editor));
        }
    }

    public final void fireEditingStopped() {
        for (CellEditorListener cellEditorListener : this.getListeners()) {
            cellEditorListener.editingStopped(new ChangeEvent(this.editor));
        }
    }
}

