/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.List;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSRule
implements Comparable<MapCSSRule> {
    public final Selector selector;
    public final Declaration declaration;

    public MapCSSRule(Selector selector, Declaration declaration) {
        this.selector = selector;
        this.declaration = declaration;
    }

    public void execute(Environment environment) {
        this.declaration.execute(environment);
    }

    @Override
    public int compareTo(MapCSSRule mapCSSRule) {
        return this.declaration.idx - mapCSSRule.declaration.idx;
    }

    public String toString() {
        return this.selector + " {\n  " + Utils.join("\n  ", this.declaration.instructions) + "\n}";
    }

    public static class Declaration {
        public final List<Instruction> instructions;
        public final int idx;

        public Declaration(List<Instruction> list, int n) {
            this.instructions = list;
            this.idx = n;
        }

        public void execute(Environment environment) {
            for (Instruction instruction : this.instructions) {
                instruction.execute(environment);
            }
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.idx;
            n = 31 * n + (this.instructions == null ? 0 : this.instructions.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Declaration)) {
                return false;
            }
            Declaration declaration = (Declaration)object;
            if (this.idx != declaration.idx) {
                return false;
            }
            return !(this.instructions == null ? declaration.instructions != null : !this.instructions.equals(declaration.instructions));
        }
    }
}

