/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Image;
import java.io.File;
import java.util.Date;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;

public final class ImageEntry
implements Comparable<ImageEntry>,
Cloneable {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Date exifTime;
    private boolean isNewGpsData = false;
    private Date exifGpsTime = null;
    Image thumbnail;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Date gpsTime;
    ImageEntry tmp;

    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    public Date getGpsTime() {
        if (this.tmp != null) {
            return ImageEntry.getDefensiveDate(this.tmp.gpsTime);
        }
        return ImageEntry.getDefensiveDate(this.gpsTime);
    }

    public final boolean hasGpsTime() {
        return this.tmp != null && this.tmp.gpsTime != null || this.gpsTime != null;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getExifOrientation() {
        return this.exifOrientation;
    }

    public Date getExifTime() {
        return ImageEntry.getDefensiveDate(this.exifTime);
    }

    public final boolean hasExifTime() {
        return this.exifTime != null;
    }

    public final Date getExifGpsTime() {
        return ImageEntry.getDefensiveDate(this.exifGpsTime);
    }

    public final boolean hasExifGpsTime() {
        return this.exifGpsTime != null;
    }

    private static Date getDefensiveDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public LatLon getExifCoor() {
        return this.exifCoor;
    }

    public Double getExifImgDir() {
        return this.exifImgDir;
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public void setPos(CachedLatLon cachedLatLon) {
        this.pos = cachedLatLon;
    }

    public void setPos(LatLon latLon) {
        this.pos = new CachedLatLon(latLon);
    }

    public void setSpeed(Double d) {
        this.speed = d;
    }

    public void setElevation(Double d) {
        this.elevation = d;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExifOrientation(Integer n) {
        this.exifOrientation = n;
    }

    public void setExifTime(Date date) {
        this.exifTime = ImageEntry.getDefensiveDate(date);
    }

    public final void setExifGpsTime(Date date) {
        this.exifGpsTime = ImageEntry.getDefensiveDate(date);
    }

    public void setGpsTime(Date date) {
        this.gpsTime = ImageEntry.getDefensiveDate(date);
    }

    public void setExifCoor(LatLon latLon) {
        this.exifCoor = latLon;
    }

    public void setExifImgDir(double d) {
        this.exifImgDir = d;
    }

    public ImageEntry clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        return (ImageEntry)object;
    }

    @Override
    public int compareTo(ImageEntry imageEntry) {
        if (this.exifTime != null && imageEntry.exifTime != null) {
            return this.exifTime.compareTo(imageEntry.exifTime);
        }
        if (this.exifTime == null && imageEntry.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public void cleanTmp() {
        this.tmp = this.clone();
        this.tmp.setPos(null);
        this.tmp.tmp = null;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.tmp = null;
        }
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        return this.file.getName() + ": " + "pos = " + this.pos + " | " + "exifCoor = " + this.exifCoor + " | " + (this.tmp == null ? " tmp==null" : " [tmp] pos = " + this.tmp.pos);
    }

    public void flagNewGpsData() {
        this.isNewGpsData = true;
        if (this.gpsTime == null) {
            Date date = this.getExifGpsTime();
            if (date == null && (date = this.getExifTime()) == null) {
                date = new Date();
            }
            this.gpsTime = date;
        }
        if (this.tmp != null && !this.tmp.hasGpsTime()) {
            this.tmp.gpsTime = this.gpsTime;
        }
    }

    public boolean hasNewGpsData() {
        return this.isNewGpsData;
    }
}

