/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.NoteDialog;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;

public class NoteLayer
extends AbstractModifiableLayer
implements MouseListener {
    private final NoteData noteData;

    public NoteLayer(List<Note> list, String string) {
        super(string);
        this.noteData = new NoteData(list);
        this.init();
    }

    public NoteLayer() {
        super(I18n.tr("Notes", new Object[0]));
        this.noteData = new NoteData();
        this.init();
    }

    private void init() {
        if (Main.map != null && Main.map.mapView != null) {
            Main.map.mapView.addMouseListener(this);
        }
    }

    public NoteData getNoteData() {
        return this.noteData;
    }

    @Override
    public boolean isModified() {
        for (Note note : this.noteData.getNotes()) {
            if (note.getId() < 0L) {
                return true;
            }
            for (NoteComment noteComment : note.getComments()) {
                if (!noteComment.getIsNew().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.isModified();
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Serializable serializable;
        Object object;
        for (Note object2 : this.noteData.getNotes()) {
            object = mapView.getPoint(object2.getLatLon());
            serializable = null;
            serializable = object2.getId() < 0L ? NoteDialog.ICON_NEW_SMALL : (object2.getState() == Note.State.closed ? NoteDialog.ICON_CLOSED_SMALL : NoteDialog.ICON_OPEN_SMALL);
            int object3 = ((ImageIcon)serializable).getIconWidth();
            int noteComment = ((ImageIcon)serializable).getIconHeight();
            graphics2D.drawImage(((ImageIcon)serializable).getImage(), ((Point)object).x - object3 / 2, ((Point)object).y - noteComment, Main.map.mapView);
        }
        if (this.noteData.getSelectedNote() != null) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            List<NoteComment> list = this.noteData.getSelectedNote().getComments();
            object = "";
            serializable = new SimpleDateFormat("MMM d, yyyy");
            for (NoteComment point : list) {
                String n = point.getText();
                if (n != null && n.trim().length() > 0) {
                    stringBuilder.append((String)object);
                    String n3 = point.getUser().getName();
                    if (n3 == null || n3.trim().length() == 0) {
                        n3 = "&lt;Anonymous&gt;";
                    }
                    stringBuilder.append(n3);
                    stringBuilder.append(" on ");
                    stringBuilder.append(((DateFormat)serializable).format(point.getCommentTimestamp()));
                    stringBuilder.append(":<br/>");
                    String i = XmlWriter.encode(point.getText(), true);
                    i = i.replace("&#xA;", "<br/>");
                    stringBuilder.append(i);
                }
                object = "<hr/>";
            }
            stringBuilder.append("</html>");
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(stringBuilder.toString());
            Point point = mapView.getPoint(this.noteData.getSelectedNote().getLatLon());
            graphics2D.setColor(ColorHelper.html2color(Main.pref.get("color.selected")));
            graphics2D.drawRect(point.x - 8, point.y - 16, 15, 15);
            int n = point.x + 8 + 5;
            int n2 = point.y - 16 - 1;
            graphics2D.translate(n, n2);
            for (int i = 0; i < 2; ++i) {
                Dimension dimension = jToolTip.getUI().getPreferredSize(jToolTip);
                dimension.width = Math.min(dimension.width, mapView.getWidth() * 1 / 2);
                jToolTip.setSize(dimension);
                jToolTip.paint(graphics2D);
            }
            graphics2D.translate(-n, -n2);
        }
    }

    @Override
    public Icon getIcon() {
        return NoteDialog.ICON_OPEN_SMALL;
    }

    @Override
    public String getToolTipText() {
        return this.noteData.getNotes().size() + " " + I18n.tr("Notes", new Object[0]);
    }

    @Override
    public void mergeFrom(Layer layer) {
        throw new UnsupportedOperationException("Notes layer does not support merging yet");
    }

    @Override
    public boolean isMergable(Layer layer) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I18n.tr("Notes layer", new Object[0]));
        stringBuilder.append("\n");
        stringBuilder.append(I18n.tr("Total notes:", new Object[0]));
        stringBuilder.append(" ");
        stringBuilder.append(this.noteData.getNotes().size());
        stringBuilder.append("\n");
        stringBuilder.append(I18n.tr("Changes need uploading?", new Object[0]));
        stringBuilder.append(" ");
        stringBuilder.append(this.isModified());
        return stringBuilder.toString();
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(LayerListDialog.getInstance().createShowHideLayerAction());
        arrayList.add(LayerListDialog.getInstance().createDeleteLayerAction());
        arrayList.add(new LayerListPopup.InfoAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        Point point = mouseEvent.getPoint();
        double d = 10.0;
        double d2 = Double.MAX_VALUE;
        Note note = null;
        for (Note note2 : this.noteData.getNotes()) {
            Point point2 = Main.map.mapView.getPoint(note2.getLatLon());
            point2.setLocation(point2.getX(), point2.getY() - 8.0);
            double d3 = point.distanceSq(point2);
            if (!(d2 > d3) || !(point.distance(point2) < d)) continue;
            d2 = d3;
            note = note2;
        }
        this.noteData.setSelectedNote(note);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

