/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.dialogs.OsmIdSelectionDialog;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;

public class DownloadObjectDialog
extends OsmIdSelectionDialog {
    protected final JCheckBox referrers = new JCheckBox(I18n.tr("Download referrers (parent relations)", new Object[0]));
    protected final JCheckBox fullRel = new JCheckBox(I18n.tr("Download relation members", new Object[0]));
    protected final JCheckBox newLayer = new JCheckBox(I18n.tr("Separate Layer", new Object[0]));

    public DownloadObjectDialog() {
        this(Main.parent);
    }

    public DownloadObjectDialog(Component component) {
        super(component, I18n.tr("Download object", new Object[0]), new String[]{I18n.tr("Download object", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.init();
        this.setButtonIcons(new String[]{"download.png", "cancel.png"});
        this.setToolTipTexts(new String[]{I18n.tr("Start downloading", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])});
        this.configureContextsensitiveHelp("/Action/DownloadObject", true);
    }

    @Override
    public void setupDialog() {
        super.setupDialog();
        ((JButton)this.buttons.get(0)).setEnabled(!Main.isOffline(OnlineResource.OSM_API));
    }

    @Override
    protected Collection<Component> getComponentsBeforeHelp() {
        this.newLayer.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        this.newLayer.setSelected(Main.pref.getBoolean("download.newlayer"));
        this.referrers.setToolTipText(I18n.tr("Select if the referrers of the object should be downloaded as well, i.e.,parent relations and for nodes, additionally, parent ways", new Object[0]));
        this.referrers.setSelected(Main.pref.getBoolean("downloadprimitive.referrers", true));
        this.fullRel.setToolTipText(I18n.tr("Select if the members of a relation should be downloaded as well", new Object[0]));
        this.fullRel.setSelected(Main.pref.getBoolean("downloadprimitive.full", true));
        this.cbType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DownloadObjectDialog.this.referrers.setText(DownloadObjectDialog.this.cbType.getType() == OsmPrimitiveType.NODE ? I18n.tr("Download referrers (parent relations and ways)", new Object[0]) : I18n.tr("Download referrers (parent relations)", new Object[0]));
            }
        });
        return Arrays.asList(this.referrers, this.fullRel, this.newLayer);
    }

    public final boolean isNewLayerRequested() {
        return this.newLayer.isSelected();
    }

    public final boolean isFullRelationRequested() {
        return this.fullRel.isSelected();
    }

    public final boolean isReferrersRequested() {
        return this.referrers.isSelected();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        super.windowClosed(windowEvent);
        if (windowEvent != null && windowEvent.getComponent() == this && this.getValue() == 1) {
            Main.pref.put("downloadprimitive.referrers", this.referrers.isSelected());
            Main.pref.put("downloadprimitive.full", this.fullRel.isSelected());
            Main.pref.put("download.newlayer", this.newLayer.isSelected());
        }
    }
}

