/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_DOUBLE_ENTRY = new Color(254, 226, 214);
    public static final Color BGCOLOR_SINGLE_ENTRY = new Color(235, 255, 177);
    private MemberTableModel model;

    public SelectionTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(OsmPrimitive osmPrimitive, boolean bl) {
        Color color = UIManager.getColor("Table.background");
        if (osmPrimitive != null && this.model != null && this.model.getNumMembersWithPrimitive(osmPrimitive) == 1) {
            color = BGCOLOR_SINGLE_ENTRY;
        } else if (osmPrimitive != null && this.model != null && this.model.getNumMembersWithPrimitive(osmPrimitive) > 1) {
            color = BGCOLOR_DOUBLE_ENTRY;
        }
        this.setBackground(color);
    }

    protected void renderPrimitive(OsmPrimitive osmPrimitive) {
        this.setIcon(ImageProvider.get(osmPrimitive.getDisplayType()));
        this.setText(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(osmPrimitive));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        if (object == null) {
            return this;
        }
        this.renderBackground((OsmPrimitive)object, bl);
        this.renderPrimitive((OsmPrimitive)object);
        return this;
    }

    public void setMemberTableModel(MemberTableModel memberTableModel) {
        this.model = memberTableModel;
    }
}

