/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.relation.ParentRelationLoadingTask;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ReferringRelationsBrowser
extends JPanel {
    private JList<Relation> referrers;
    private ReferringRelationsBrowserModel model;
    private OsmDataLayer layer;
    private JCheckBox cbReadFull;
    private EditAction editAction;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.referrers = new JList<Relation>(this.model);
        this.referrers.setCellRenderer(new OsmPrimitivRenderer());
        this.add((Component)new JScrollPane(this.referrers), "Center");
        this.referrers.setSelectionMode(0);
        this.referrers.addMouseListener(new DblClickMouseAdapter());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        ReloadAction reloadAction = new ReloadAction();
        this.referrers.getModel().addListDataListener(reloadAction);
        jPanel.add(new SideButton(reloadAction));
        this.cbReadFull = new JCheckBox(I18n.tr("including immediate children of parent relations", new Object[0]));
        jPanel.add(this.cbReadFull);
        this.editAction = new EditAction();
        this.referrers.getSelectionModel().addListSelectionListener(this.editAction);
        jPanel.add(new SideButton(this.editAction));
        this.add((Component)jPanel, "South");
    }

    public ReferringRelationsBrowser(OsmDataLayer osmDataLayer, ReferringRelationsBrowserModel referringRelationsBrowserModel) {
        this.model = referringRelationsBrowserModel;
        this.layer = osmDataLayer;
        this.build();
    }

    public void init() {
        this.model.populate(this.getLayer().data);
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    class DblClickMouseAdapter
    extends MouseAdapter {
        DblClickMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ReferringRelationsBrowser.this.editAction.run();
            }
        }
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the currently selected relation", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(ReferringRelationsBrowser.this.referrers.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = ReferringRelationsBrowser.this.referrers.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Relation relation = ReferringRelationsBrowser.this.model.getElementAt(n);
            if (relation == null) {
                return;
            }
            RelationEditor relationEditor = RelationEditor.getEditor(ReferringRelationsBrowser.this.getLayer(), relation, null);
            relationEditor.setVisible(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class ReloadAction
    extends AbstractAction
    implements ListDataListener {
        public ReloadAction() {
            this.putValue("ShortDescription", I18n.tr("Load parent relations", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(ReferringRelationsBrowser.this.model.canReload());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ReferringRelationsBrowser.this.cbReadFull.isSelected();
            final ParentRelationLoadingTask parentRelationLoadingTask = new ParentRelationLoadingTask(ReferringRelationsBrowser.this.model.getRelation(), ReferringRelationsBrowser.this.getLayer(), bl, new PleaseWaitProgressMonitor(I18n.tr("Loading parent relations", new Object[0])));
            parentRelationLoadingTask.setContinuation(new Runnable(){

                @Override
                public void run() {
                    if (parentRelationLoadingTask.isCanceled() || parentRelationLoadingTask.hasError()) {
                        return;
                    }
                    ReferringRelationsBrowser.this.model.populate(parentRelationLoadingTask.getParents());
                }
            });
            Main.worker.submit(parentRelationLoadingTask);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.refreshEnabled();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.refreshEnabled();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.refreshEnabled();
        }
    }
}

