/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.TaggingPresets;
import org.openstreetmap.josm.tools.I18n;

public class RelationChecker
extends Test {
    protected static final int ROLE_UNKNOWN = 1701;
    protected static final int ROLE_EMPTY = 1702;
    protected static final int WRONG_TYPE = 1703;
    protected static final int HIGH_COUNT = 1704;
    protected static final int LOW_COUNT = 1705;
    protected static final int ROLE_MISSING = 1706;
    protected static final int RELATION_UNKNOWN = 1707;
    protected static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        block0: for (TaggingPreset taggingPreset : TaggingPresets.getTaggingPresets()) {
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (!(taggingPresetItem instanceof TaggingPresetItems.Roles)) continue;
                relationpresets.add(taggingPreset);
                continue block0;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        LinkedList<TaggingPresetItems.Role> linkedList = this.buildAllRoles(relation);
        if (linkedList.isEmpty() && relation.hasTag("type", "route") && relation.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1"), 1707, relation));
        } else if (linkedList.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), 1707, relation));
        }
        HashMap<String, RoleInfo> hashMap = this.buildRoleInfoMap(relation);
        if (hashMap.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), 1708, relation));
        } else if (!linkedList.isEmpty()) {
            this.checkRoles(relation, linkedList, hashMap);
        }
    }

    private HashMap<String, RoleInfo> buildRoleInfoMap(Relation relation) {
        HashMap<String, RoleInfo> hashMap = new HashMap<String, RoleInfo>();
        for (RelationMember relationMember : relation.getMembers()) {
            String string = relationMember.getRole();
            RoleInfo roleInfo = hashMap.get(string);
            if (roleInfo == null) {
                roleInfo = new RoleInfo();
            }
            roleInfo.total++;
            if (relationMember.isRelation()) {
                roleInfo.relations.add(relationMember.getRelation());
            } else if (relationMember.isWay()) {
                roleInfo.ways.add(relationMember.getWay());
                if (!relationMember.getWay().isClosed()) {
                    roleInfo.openways.add(relationMember.getWay());
                }
            } else if (relationMember.isNode()) {
                roleInfo.nodes.add(relationMember.getNode());
            }
            hashMap.put(string, roleInfo);
        }
        return hashMap;
    }

    private LinkedList<TaggingPresetItems.Role> buildAllRoles(Relation relation) {
        LinkedList<TaggingPresetItems.Role> linkedList = new LinkedList<TaggingPresetItems.Role>();
        for (TaggingPreset taggingPreset : relationpresets) {
            boolean bl = true;
            TaggingPresetItems.Roles roles = null;
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (taggingPresetItem instanceof TaggingPresetItems.Key) {
                    TaggingPresetItems.Key key = (TaggingPresetItems.Key)taggingPresetItem;
                    if (key.value.equals(relation.get(key.key))) continue;
                    bl = false;
                    break;
                }
                if (!(taggingPresetItem instanceof TaggingPresetItems.Roles)) continue;
                roles = (TaggingPresetItems.Roles)taggingPresetItem;
            }
            if (!bl || roles == null) continue;
            linkedList.addAll(roles.roles);
        }
        return linkedList;
    }

    private void checkRoles(Relation relation, LinkedList<TaggingPresetItems.Role> linkedList, HashMap<String, RoleInfo> hashMap) {
        String string;
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<TaggingPresetItems.Role> linkedList3 = new LinkedList<TaggingPresetItems.Role>();
        for (TaggingPresetItems.Role object : linkedList) {
            if (!"".equals(object.key)) continue;
            linkedList3.add(object);
        }
        if (linkedList3.size() > 1) {
            linkedList.removeAll(linkedList3);
        }
        for (TaggingPresetItems.Role role : linkedList) {
            linkedList2.add(role.key);
            string = role.key;
            if ("".equals(string)) {
                string = I18n.tr("<empty>", new Object[0]);
            }
            RoleInfo roleInfo = hashMap.get(role.key);
            this.checkRoleCounts(relation, role, string, roleInfo);
            if (roleInfo == null) continue;
            if (role.types != null) {
                this.checkRoleTypes(relation, role, string, roleInfo);
            }
            if (role.memberExpression == null) continue;
            this.checkRoleMemberExpressions(relation, role, string, roleInfo);
        }
        for (String string2 : hashMap.keySet()) {
            if (linkedList2.contains(string2)) continue;
            if (string2.length() > 0) {
                string = I18n.marktr("Role {0} unknown");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string, string2), MessageFormat.format(string, string2), 1701, relation));
                continue;
            }
            string = I18n.marktr("Empty role found");
            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string, new Object[0]), string, 1702, relation));
        }
    }

    private void checkRoleMemberExpressions(Relation relation, TaggingPresetItems.Role role, String string, RoleInfo roleInfo) {
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(roleInfo.nodes);
        arrayList.addAll(roleInfo.ways);
        arrayList.addAll(roleInfo.relations);
        for (Object object : arrayList) {
            if (!((AbstractPrimitive)object).isUsable() || role.memberExpression.match((OsmPrimitive)object)) continue;
            hashSet.add(object);
        }
        if (!hashSet.isEmpty()) {
            Object object;
            String string2 = I18n.marktr("Member for role ''{0}'' does not match ''{1}''");
            object = new LinkedList(hashSet);
            ((LinkedList)object).addFirst(relation);
            this.errors.add(new TestError(this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string2, string, role.memberExpression), MessageFormat.format(string2, string, role.memberExpression), 1703, (Collection<? extends OsmPrimitive>)object, hashSet));
        }
    }

    private void checkRoleTypes(Relation relation, TaggingPresetItems.Role role, String string, RoleInfo roleInfo) {
        HashSet hashSet = new HashSet();
        if (!role.types.contains((Object)TaggingPresetType.WAY)) {
            hashSet.addAll(role.types.contains((Object)TaggingPresetType.CLOSEDWAY) ? roleInfo.openways : roleInfo.ways);
        }
        if (!role.types.contains((Object)TaggingPresetType.NODE)) {
            hashSet.addAll(roleInfo.nodes);
        }
        if (!role.types.contains((Object)TaggingPresetType.RELATION)) {
            hashSet.addAll(roleInfo.relations);
        }
        if (!hashSet.isEmpty()) {
            String string2 = I18n.marktr("Member for role {0} of wrong type");
            LinkedList<Relation> linkedList = new LinkedList<Relation>(hashSet);
            linkedList.addFirst(relation);
            this.errors.add(new TestError(this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string2, string), MessageFormat.format(string2, string), 1703, linkedList, hashSet));
        }
    }

    private void checkRoleCounts(Relation relation, TaggingPresetItems.Role role, String string, RoleInfo roleInfo) {
        long l;
        long l2 = roleInfo == null ? 0L : (long)roleInfo.total;
        if (l2 != (l = role.getValidCount(l2))) {
            if (l2 == 0L) {
                String string2 = I18n.marktr("Role {0} missing");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string2, string), MessageFormat.format(string2, string), 1706, relation));
            } else if (l > l2) {
                String string3 = I18n.marktr("Number of {0} roles too low ({1})");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string3, string, l2), MessageFormat.format(string3, string, l2), 1705, relation));
            } else {
                String string4 = I18n.marktr("Number of {0} roles too high ({1})");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(string4, string, l2), MessageFormat.format(string4, string, l2), 1704, relation));
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        return testError.getCode() == 1708 && !collection.isEmpty() && collection.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total = 0;
        private Collection<Node> nodes = new LinkedList<Node>();
        private Collection<Way> ways = new LinkedList<Way>();
        private Collection<Way> openways = new LinkedList<Way>();
        private Collection<Relation> relations = new LinkedList<Relation>();

        private RoleInfo() {
        }
    }
}

