/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.validation.FixableTestError;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSTagChecker
extends Test.TagTest {
    public static final String ENTRIES_PREF_KEY = "validator." + MapCSSTagChecker.class.getName() + ".entries";
    final MultiMap<String, TagCheck> checks = new MultiMap();

    public MapCSSTagChecker() {
        super(I18n.tr("Tag checker (MapCSS based)", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    public synchronized Collection<TestError> getErrorsForPrimitive(OsmPrimitive osmPrimitive, boolean bl) {
        ArrayList<TestError> arrayList = new ArrayList<TestError>();
        Environment environment = new Environment(osmPrimitive, new MultiCascade(), "default", null);
        for (Set<TagCheck> set : this.checks.values()) {
            for (TagCheck tagCheck : set) {
                Selector selector;
                if (Severity.OTHER.equals((Object)tagCheck.getSeverity()) && !bl || (selector = tagCheck.whichSelectorMatchesEnvironment(environment)) == null) continue;
                tagCheck.rule.declaration.execute(environment);
                TestError testError = tagCheck.getErrorForPrimitive(osmPrimitive, selector, environment);
                if (testError == null) continue;
                testError.setTester(new MapCSSTagCheckerAndRule(tagCheck.rule));
                arrayList.add(testError);
            }
        }
        return arrayList;
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        this.errors.addAll(this.getErrorsForPrimitive(osmPrimitive, ValidatorPreference.PREF_OTHER.get()));
    }

    public synchronized void addMapCSS(String string) throws ParseException, IOException {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        CachedFile cachedFile = new CachedFile(string);
        try (InputStream inputStream = cachedFile.getInputStream();){
            List<TagCheck> list = TagCheck.readMapCSS(new BufferedReader(UTFInputStreamReader.create(inputStream)));
            this.checks.remove(string);
            this.checks.putAll(string, list);
            if (Main.pref.getBoolean("validator.check_assert_local_rules", false) && Utils.isLocalUrl(string)) {
                for (String string2 : this.checkAsserts(list)) {
                    Main.warn(string2);
                }
            }
        }
    }

    @Override
    public synchronized void initialize() throws Exception {
        this.checks.clear();
        for (SourceEntry sourceEntry : new ValidatorTagCheckerRulesPreference.RulePrefHelper().get()) {
            if (!sourceEntry.active) continue;
            String string = sourceEntry.url;
            try {
                if (!string.startsWith("resource:")) {
                    Main.info(I18n.tr("Adding {0} to tag checker", string));
                } else if (Main.isDebugEnabled()) {
                    Main.debug(I18n.tr("Adding {0} to tag checker", string));
                }
                this.addMapCSS(string);
                if (!Main.pref.getBoolean("validator.auto_reload_local_rules", true) || !sourceEntry.isLocal()) continue;
                try {
                    Main.fileWatcher.registerValidatorRule(sourceEntry);
                }
                catch (IOException iOException) {
                    Main.error(iOException);
                }
            }
            catch (IOException iOException) {
                Main.warn(I18n.tr("Failed to add {0} to tag checker", string));
                Main.warn(iOException, false);
            }
            catch (Exception exception) {
                Main.warn(I18n.tr("Failed to add {0} to tag checker", string));
                Main.warn(exception);
            }
        }
    }

    public Set<String> checkAsserts(Collection<TagCheck> collection) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (final TagCheck tagCheck : collection) {
            if (Main.isDebugEnabled()) {
                Main.debug("Check: " + tagCheck);
            }
            for (Map.Entry<String, Boolean> entry : tagCheck.assertions.entrySet()) {
                OsmPrimitive osmPrimitive;
                boolean bl;
                if (Main.isDebugEnabled()) {
                    Main.debug("- Assertion: " + entry);
                }
                if ((bl = Utils.exists(this.getErrorsForPrimitive(osmPrimitive = OsmUtils.createPrimitive(entry.getKey()), true), new Predicate<TestError>(){

                    @Override
                    public boolean evaluate(TestError testError) {
                        return testError.getTester().equals(tagCheck.rule);
                    }
                })) == entry.getValue()) continue;
                String string = MessageFormat.format("Expecting test ''{0}'' (i.e., {1}) to {2} {3} (i.e., {4})", tagCheck.getMessage(osmPrimitive), tagCheck.rule.selectors, entry.getValue() != false ? "match" : "not match", entry.getKey(), osmPrimitive.getKeys());
                linkedHashSet.add(string);
            }
        }
        return linkedHashSet;
    }

    @Override
    public synchronized int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.checks == null ? 0 : this.checks.hashCode());
        return n;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof MapCSSTagChecker)) {
            return false;
        }
        MapCSSTagChecker mapCSSTagChecker = (MapCSSTagChecker)object;
        return !(this.checks == null ? mapCSSTagChecker.checks != null : !this.checks.equals(mapCSSTagChecker.checks));
    }

    static class MapCSSTagCheckerAndRule
    extends MapCSSTagChecker {
        public final GroupedMapCSSRule rule;

        MapCSSTagCheckerAndRule(GroupedMapCSSRule groupedMapCSSRule) {
            this.rule = groupedMapCSSRule;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) || object instanceof TagCheck && this.rule.equals(((TagCheck)object).rule) || object instanceof GroupedMapCSSRule && this.rule.equals(object);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.rule == null ? 0 : this.rule.hashCode());
            return n;
        }
    }

    static class TagCheck
    implements Predicate<OsmPrimitive> {
        protected final GroupedMapCSSRule rule;
        protected final List<PrimitiveToTag> change = new ArrayList<PrimitiveToTag>();
        protected final Map<String, String> keyChange = new LinkedHashMap<String, String>();
        protected final List<String> alternatives = new ArrayList<String>();
        protected final Map<Instruction.AssignmentInstruction, Severity> errors = new HashMap<Instruction.AssignmentInstruction, Severity>();
        protected final Map<String, Boolean> assertions = new HashMap<String, Boolean>();
        protected boolean deletion = false;
        static final String POSSIBLE_THROWS = TagCheck.possibleThrows();

        TagCheck(GroupedMapCSSRule groupedMapCSSRule) {
            this.rule = groupedMapCSSRule;
        }

        static final String possibleThrows() {
            StringBuffer stringBuffer = new StringBuffer();
            for (Severity severity : Severity.values()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append("throw").append(severity.name().charAt(0)).append(severity.name().substring(1).toLowerCase());
            }
            return stringBuffer.toString();
        }

        static TagCheck ofMapCSSRule(GroupedMapCSSRule groupedMapCSSRule) throws IllegalDataException {
            TagCheck tagCheck = new TagCheck(groupedMapCSSRule);
            boolean bl = false;
            for (Instruction instruction : groupedMapCSSRule.declaration.instructions) {
                Object object;
                String string;
                if (!(instruction instanceof Instruction.AssignmentInstruction)) continue;
                Instruction.AssignmentInstruction assignmentInstruction = (Instruction.AssignmentInstruction)instruction;
                if (assignmentInstruction.isSetInstruction) {
                    bl = true;
                    continue;
                }
                String string2 = assignmentInstruction.val instanceof Expression ? (String)((Expression)assignmentInstruction.val).evaluate(new Environment()) : (assignmentInstruction.val instanceof String ? (String)assignmentInstruction.val : (string = assignmentInstruction.val instanceof Keyword ? ((Keyword)assignmentInstruction.val).val : null));
                if (assignmentInstruction.key.startsWith("throw")) {
                    try {
                        object = Severity.valueOf(assignmentInstruction.key.substring("throw".length()).toUpperCase());
                        tagCheck.errors.put(assignmentInstruction, (Severity)((Object)object));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Main.warn("Unsupported " + assignmentInstruction.key + " instruction. Allowed instructions are " + POSSIBLE_THROWS);
                    }
                    continue;
                }
                if ("fixAdd".equals(assignmentInstruction.key)) {
                    object = PrimitiveToTag.ofMapCSSObject(assignmentInstruction.val, false);
                    if (object != null) {
                        tagCheck.change.add((PrimitiveToTag)object);
                        continue;
                    }
                    Main.warn("Invalid value for " + assignmentInstruction.key + ": " + assignmentInstruction.val);
                    continue;
                }
                if ("fixRemove".equals(assignmentInstruction.key)) {
                    CheckParameterUtil.ensureThat(!(assignmentInstruction.val instanceof String) || string == null || !string.contains("="), "Unexpected '='. Please only specify the key to remove!");
                    object = PrimitiveToTag.ofMapCSSObject(assignmentInstruction.val, true);
                    if (object != null) {
                        tagCheck.change.add((PrimitiveToTag)object);
                        continue;
                    }
                    Main.warn("Invalid value for " + assignmentInstruction.key + ": " + assignmentInstruction.val);
                    continue;
                }
                if ("fixChangeKey".equals(assignmentInstruction.key) && string != null) {
                    CheckParameterUtil.ensureThat(string.contains("=>"), "Separate old from new key by '=>'!");
                    object = string.split("=>", 2);
                    tagCheck.keyChange.put(Tag.removeWhiteSpaces(object[0]), Tag.removeWhiteSpaces(object[1]));
                    continue;
                }
                if ("fixDeleteObject".equals(assignmentInstruction.key) && string != null) {
                    CheckParameterUtil.ensureThat(string.equals("this"), "fixDeleteObject must be followed by 'this'");
                    tagCheck.deletion = true;
                    continue;
                }
                if ("suggestAlternative".equals(assignmentInstruction.key) && string != null) {
                    tagCheck.alternatives.add(string);
                    continue;
                }
                if ("assertMatch".equals(assignmentInstruction.key) && string != null) {
                    tagCheck.assertions.put(string, true);
                    continue;
                }
                if ("assertNoMatch".equals(assignmentInstruction.key) && string != null) {
                    tagCheck.assertions.put(string, false);
                    continue;
                }
                throw new IllegalDataException("Cannot add instruction " + assignmentInstruction.key + ": " + assignmentInstruction.val + "!");
            }
            if (tagCheck.errors.isEmpty() && !bl) {
                throw new IllegalDataException("No " + POSSIBLE_THROWS + " given! You should specify a validation error message for " + groupedMapCSSRule.selectors);
            }
            if (tagCheck.errors.size() > 1) {
                throw new IllegalDataException("More than one " + POSSIBLE_THROWS + " given! You should specify a single validation error message for " + groupedMapCSSRule.selectors);
            }
            return tagCheck;
        }

        static List<TagCheck> readMapCSS(Reader reader) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(reader, "css");
            return TagCheck.readMapCSS(new MapCSSParser(reader));
        }

        static List<TagCheck> readMapCSS(MapCSSParser mapCSSParser) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(mapCSSParser, "css");
            MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource("");
            mapCSSParser.sheet(mapCSSStyleSource);
            assert (mapCSSStyleSource.getErrors().isEmpty());
            TagCheck.removeMetaRules(mapCSSStyleSource);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (MapCSSRule object : mapCSSStyleSource.rules) {
                if (!linkedHashMap.containsKey(object.declaration)) {
                    ArrayList<Selector> arrayList = new ArrayList<Selector>();
                    arrayList.add(object.selector);
                    linkedHashMap.put(object.declaration, arrayList);
                    continue;
                }
                ((List)linkedHashMap.get(object.declaration)).add(object.selector);
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                try {
                    arrayList.add(TagCheck.ofMapCSSRule(new GroupedMapCSSRule((List)entry.getValue(), (MapCSSRule.Declaration)entry.getKey())));
                }
                catch (IllegalDataException illegalDataException) {
                    Main.error("Cannot add MapCss rule: " + illegalDataException.getMessage());
                }
            }
            return arrayList;
        }

        private static void removeMetaRules(MapCSSStyleSource mapCSSStyleSource) {
            Iterator<MapCSSRule> iterator = mapCSSStyleSource.rules.iterator();
            while (iterator.hasNext()) {
                MapCSSRule mapCSSRule = iterator.next();
                if (!(mapCSSRule.selector instanceof Selector.GeneralSelector)) continue;
                Selector.GeneralSelector generalSelector = (Selector.GeneralSelector)mapCSSRule.selector;
                if (!"meta".equals(generalSelector.base) || !generalSelector.getConditions().isEmpty()) continue;
                iterator.remove();
            }
        }

        @Override
        public boolean evaluate(OsmPrimitive osmPrimitive) {
            return this.whichSelectorMatchesPrimitive(osmPrimitive) != null;
        }

        Selector whichSelectorMatchesPrimitive(OsmPrimitive osmPrimitive) {
            return this.whichSelectorMatchesEnvironment(new Environment().withPrimitive(osmPrimitive));
        }

        Selector whichSelectorMatchesEnvironment(Environment environment) {
            for (Selector selector : this.rule.selectors) {
                environment.clearSelectorMatchingInformation();
                if (!selector.matches(environment)) continue;
                return selector;
            }
            return null;
        }

        static String determineArgument(Selector.GeneralSelector generalSelector, int n, String string) {
            block6: {
                try {
                    Tag tag;
                    Condition condition = generalSelector.getConditions().get(n);
                    Tag tag2 = condition instanceof Condition.KeyCondition ? ((Condition.KeyCondition)condition).asTag() : (condition instanceof Condition.SimpleKeyValueCondition ? ((Condition.SimpleKeyValueCondition)condition).asTag() : (tag = condition instanceof Condition.KeyValueCondition ? ((Condition.KeyValueCondition)condition).asTag() : null));
                    if (tag == null) {
                        return null;
                    }
                    if ("key".equals(string)) {
                        return tag.getKey();
                    }
                    if ("value".equals(string)) {
                        return tag.getValue();
                    }
                    if ("tag".equals(string)) {
                        return tag.toString();
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (!Main.isDebugEnabled()) break block6;
                    Main.debug(indexOutOfBoundsException.getMessage());
                }
            }
            return null;
        }

        static String insertArguments(Selector selector, String string) {
            if (string != null && selector instanceof Selector.ChildOrParentSelector) {
                return TagCheck.insertArguments(((Selector.ChildOrParentSelector)selector).right, string);
            }
            if (string == null || !(selector instanceof Selector.GeneralSelector)) {
                return string;
            }
            Matcher matcher = Pattern.compile("\\{(\\d+)\\.(key|value|tag)\\}").matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = TagCheck.determineArgument((Selector.GeneralSelector)selector, Integer.parseInt(matcher.group(1)), matcher.group(2));
                try {
                    matcher.appendReplacement(stringBuffer, String.valueOf(string2).replace("^(", "").replace(")$", ""));
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                    Main.error(I18n.tr("Unable to replace argument {0} in {1}: {2}", string2, stringBuffer, runtimeException.getMessage()));
                }
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        Command fixPrimitive(OsmPrimitive osmPrimitive) {
            String string;
            Object object;
            if (this.change.isEmpty() && this.keyChange.isEmpty() && !this.deletion) {
                return null;
            }
            Selector selector = this.whichSelectorMatchesPrimitive(osmPrimitive);
            LinkedList<Command> linkedList = new LinkedList<Command>();
            for (PrimitiveToTag object2 : this.change) {
                object = (Tag)object2.apply(osmPrimitive);
                string = TagCheck.insertArguments(selector, ((Tag)object).getKey());
                String string2 = TagCheck.insertArguments(selector, ((Tag)object).getValue());
                linkedList.add(new ChangePropertyCommand(osmPrimitive, string, string2));
            }
            for (Map.Entry entry : this.keyChange.entrySet()) {
                object = TagCheck.insertArguments(selector, (String)entry.getKey());
                string = TagCheck.insertArguments(selector, (String)entry.getValue());
                linkedList.add(new ChangePropertyKeyCommand(osmPrimitive, (String)object, string));
            }
            if (this.deletion) {
                linkedList.add(new DeleteCommand(osmPrimitive));
            }
            return new SequenceCommand(I18n.tr("Fix of {0}", this.getDescriptionForMatchingSelector(osmPrimitive, selector)), linkedList);
        }

        String getMessage(OsmPrimitive osmPrimitive) {
            if (this.errors.isEmpty()) {
                return this.rule.declaration.toString();
            }
            Object object = this.errors.keySet().iterator().next().val;
            return String.valueOf(object instanceof Expression ? ((Expression)object).evaluate(new Environment().withPrimitive(osmPrimitive)) : object);
        }

        String getDescription(OsmPrimitive osmPrimitive) {
            if (this.alternatives.isEmpty()) {
                return this.getMessage(osmPrimitive);
            }
            return I18n.tr("{0}, use {1} instead", this.getMessage(osmPrimitive), Utils.join(I18n.tr(" or ", new Object[0]), this.alternatives));
        }

        String getDescriptionForMatchingSelector(OsmPrimitive osmPrimitive, Selector selector) {
            return TagCheck.insertArguments(selector, this.getDescription(osmPrimitive));
        }

        Severity getSeverity() {
            return this.errors.isEmpty() ? null : this.errors.values().iterator().next();
        }

        public String toString() {
            return this.getDescription(null);
        }

        TestError getErrorForPrimitive(OsmPrimitive osmPrimitive) {
            Environment environment = new Environment().withPrimitive(osmPrimitive);
            return this.getErrorForPrimitive(osmPrimitive, this.whichSelectorMatchesEnvironment(environment), environment);
        }

        TestError getErrorForPrimitive(OsmPrimitive osmPrimitive, Selector selector, Environment environment) {
            if (selector != null && !this.errors.isEmpty()) {
                Command command = this.fixPrimitive(osmPrimitive);
                String string = this.getDescriptionForMatchingSelector(osmPrimitive, selector);
                List<OsmPrimitive> list = environment.child != null ? Arrays.asList(osmPrimitive, environment.child) : Collections.singletonList(osmPrimitive);
                if (command != null) {
                    return new FixableTestError(null, this.getSeverity(), string, null, selector.toString(), 3000, list, command);
                }
                return new TestError(null, this.getSeverity(), string, null, selector.toString(), 3000, list);
            }
            return null;
        }

        static abstract class PrimitiveToTag
        implements Utils.Function<OsmPrimitive, Tag> {
            private PrimitiveToTag() {
            }

            static PrimitiveToTag ofMapCSSObject(final Object object, final boolean bl) {
                if (object instanceof Expression) {
                    return new PrimitiveToTag(){

                        @Override
                        public Tag apply(OsmPrimitive osmPrimitive) {
                            String string = (String)((Expression)object).evaluate(new Environment().withPrimitive(osmPrimitive));
                            return bl ? new Tag(string) : Tag.ofString(string);
                        }
                    };
                }
                if (object instanceof String) {
                    final Tag tag = bl ? new Tag((String)object) : Tag.ofString((String)object);
                    return new PrimitiveToTag(){

                        @Override
                        public Tag apply(OsmPrimitive osmPrimitive) {
                            return tag;
                        }
                    };
                }
                return null;
            }
        }
    }

    public static class GroupedMapCSSRule {
        public final List<Selector> selectors;
        public final MapCSSRule.Declaration declaration;

        public GroupedMapCSSRule(List<Selector> list, MapCSSRule.Declaration declaration) {
            this.selectors = list;
            this.declaration = declaration;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.declaration == null ? 0 : this.declaration.hashCode());
            n = 31 * n + (this.selectors == null ? 0 : this.selectors.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof GroupedMapCSSRule)) {
                return false;
            }
            GroupedMapCSSRule groupedMapCSSRule = (GroupedMapCSSRule)object;
            if (this.declaration == null ? groupedMapCSSRule.declaration != null : !this.declaration.equals(groupedMapCSSRule.declaration)) {
                return false;
            }
            return !(this.selectors == null ? groupedMapCSSRule.selectors != null : !this.selectors.equals(groupedMapCSSRule.selectors));
        }
    }
}

