/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class Addresses
extends Test {
    protected static final int HOUSE_NUMBER_WITHOUT_STREET = 2601;
    protected static final int DUPLICATE_HOUSE_NUMBER = 2602;
    protected static final int MULTIPLE_STREET_NAMES = 2603;
    protected static final int MULTIPLE_STREET_RELATIONS = 2604;
    protected static final int HOUSE_NUMBER_TOO_FAR = 2605;
    protected static final String ADDR_HOUSE_NUMBER = "addr:housenumber";
    protected static final String ADDR_INTERPOLATION = "addr:interpolation";
    protected static final String ADDR_PLACE = "addr:place";
    protected static final String ADDR_STREET = "addr:street";
    protected static final String ASSOCIATED_STREET = "associatedStreet";

    public Addresses() {
        super(I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors in addresses and associatedStreet relations.", new Object[0]));
    }

    protected List<Relation> getAndCheckAssociatedStreets(OsmPrimitive osmPrimitive) {
        List<Relation> list = OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class);
        Object object = list.iterator();
        while (object.hasNext()) {
            Relation relation = object.next();
            if (relation.hasTag("type", ASSOCIATED_STREET)) continue;
            object.remove();
        }
        if (list.size() > 1) {
            object = new ArrayList<Relation>(list);
            object.add(0, osmPrimitive);
            this.errors.add(new AddressError(2604, (Collection<OsmPrimitive>)object, I18n.tr("Multiple associatedStreet relations", new Object[0])));
        }
        return list;
    }

    protected void checkHouseNumbersWithoutStreet(OsmPrimitive osmPrimitive) {
        List<Relation> list = this.getAndCheckAssociatedStreets(osmPrimitive);
        if (osmPrimitive.hasKey(ADDR_HOUSE_NUMBER) && !osmPrimitive.hasKey(ADDR_STREET) && !osmPrimitive.hasKey(ADDR_PLACE)) {
            for (Relation osmPrimitive2 : list) {
                if (!osmPrimitive2.hasTag("type", ASSOCIATED_STREET)) continue;
                return;
            }
            for (Way way : OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Way.class)) {
                if (!way.hasKey(ADDR_INTERPOLATION) || !way.hasKey(ADDR_STREET)) continue;
                return;
            }
            this.errors.add(new AddressError(2601, osmPrimitive, I18n.tr("House number without street", new Object[0])));
        }
    }

    @Override
    public void visit(Node node) {
        this.checkHouseNumbersWithoutStreet(node);
    }

    @Override
    public void visit(Way way) {
        this.checkHouseNumbersWithoutStreet(way);
    }

    @Override
    public void visit(Relation relation) {
        this.checkHouseNumbersWithoutStreet(relation);
        if (relation.hasTag("type", ASSOCIATED_STREET)) {
            Object object;
            HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
            String string = relation.get("name");
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>();
            HashSet<Way> hashSet3 = new HashSet<Way>();
            for (RelationMember iterator : relation.getMembers()) {
                String string2 = iterator.getRole();
                object = iterator.getMember();
                if ("house".equals(string2)) {
                    hashSet2.add((OsmPrimitive)object);
                    String string3 = ((AbstractPrimitive)object).get(ADDR_HOUSE_NUMBER);
                    if (string3 != null) {
                        ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string3 = string3.trim().toUpperCase());
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>();
                            hashMap.put(string3, arrayList);
                        }
                        arrayList.add(object);
                    }
                    if (string == null || !((AbstractPrimitive)object).hasKey(ADDR_STREET) || string.equals(((AbstractPrimitive)object).get(ADDR_STREET))) continue;
                    if (hashSet.isEmpty()) {
                        hashSet.add(relation);
                    }
                    hashSet.add((OsmPrimitive)object);
                    continue;
                }
                if (!"street".equals(string2)) continue;
                if (object instanceof Way) {
                    hashSet3.add((Way)object);
                }
                if (string == null || !((AbstractPrimitive)object).hasKey("name") || string.equals(((AbstractPrimitive)object).get("name"))) continue;
                if (hashSet.isEmpty()) {
                    hashSet.add(relation);
                }
                hashSet.add((OsmPrimitive)object);
            }
            String string3 = I18n.marktr("House number ''{0}'' duplicated");
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (List)entry.getValue();
                if (object.size() <= 1) continue;
                this.errors.add(new AddressError(2602, (Collection<OsmPrimitive>)object, I18n.tr("Duplicate house numbers", new Object[0]), I18n.tr(string3, entry.getKey()), string3));
            }
            if (!hashSet.isEmpty()) {
                this.errors.add(new AddressError(2603, hashSet, I18n.tr("Multiple street names in relation", new Object[0])));
            }
            if (!hashSet3.isEmpty()) {
                for (OsmPrimitive osmPrimitive : hashSet2) {
                    if (!osmPrimitive.isUsable()) continue;
                    this.checkDistance(osmPrimitive, hashSet3);
                }
            }
        }
    }

    protected void checkDistance(OsmPrimitive osmPrimitive, Collection<Way> collection) {
        EastNorth eastNorth;
        if (osmPrimitive instanceof Node) {
            eastNorth = ((Node)osmPrimitive).getEastNorth();
        } else if (osmPrimitive instanceof Way) {
            List<Node> list = ((Way)osmPrimitive).getNodes();
            if (osmPrimitive.hasKey(ADDR_INTERPOLATION)) {
                for (Node node : list) {
                    if (!node.hasKey(ADDR_HOUSE_NUMBER)) continue;
                    this.checkDistance(node, collection);
                }
                return;
            }
            eastNorth = Geometry.getCentroid(list);
        } else {
            return;
        }
        if (eastNorth == null) {
            return;
        }
        double d = Main.pref.getDouble("validator.addresses.max_street_distance", 200.0);
        boolean bl = false;
        for (Way way : collection) {
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                EastNorth eastNorth2 = ((Node)pair.a).getEastNorth();
                EastNorth eastNorth3 = ((Node)pair.b).getEastNorth();
                if (eastNorth2 != null && eastNorth3 != null) {
                    EastNorth eastNorth4 = Geometry.closestPointToSegment(eastNorth2, eastNorth3, eastNorth);
                    if (!(eastNorth4.distance(eastNorth) <= d)) continue;
                    return;
                }
                Main.warn("Addresses test skipped chunck " + pair + " for street part " + way + " because p1 or p2 is null");
            }
            if (bl || !way.isIncomplete()) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        ArrayList<Way> arrayList = new ArrayList<Way>(collection);
        arrayList.add(0, (Way)osmPrimitive);
        this.errors.add(new AddressError(2605, (Collection<OsmPrimitive>)arrayList, I18n.tr("House number too far from street", new Object[0])));
    }

    protected class AddressError
    extends TestError {
        public AddressError(int n, OsmPrimitive osmPrimitive, String string) {
            this(n, Collections.singleton(osmPrimitive), string);
        }

        public AddressError(int n, Collection<OsmPrimitive> collection, String string) {
            this(n, collection, string, null, null);
        }

        public AddressError(int n, Collection<OsmPrimitive> collection, String string, String string2, String string3) {
            super((Test)Addresses.this, Severity.WARNING, string, string2, string3, n, collection);
        }
    }
}

