/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;

public class OsmPrimitiveComparator
implements Comparator<OsmPrimitive> {
    private final Map<OsmPrimitive, String> cache = new HashMap<OsmPrimitive, String>();
    private final boolean relationsFirst;
    private final boolean quick;

    public OsmPrimitiveComparator() {
        this(false, false);
    }

    public OsmPrimitiveComparator(boolean bl, boolean bl2) {
        this.quick = bl;
        this.relationsFirst = bl2;
    }

    private String cachedName(OsmPrimitive osmPrimitive) {
        String string = this.cache.get(osmPrimitive);
        if (string == null) {
            string = osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
            this.cache.put(osmPrimitive, string);
        }
        return string;
    }

    private int compareName(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        String string = this.cachedName(osmPrimitive);
        String string2 = this.cachedName(osmPrimitive2);
        if (Character.isDigit(string.charAt(0)) && Character.isDigit(string2.charAt(0))) {
            return string.compareTo(string2);
        }
        if (Character.isDigit(string.charAt(0)) && !Character.isDigit(string2.charAt(0))) {
            return 1;
        }
        if (!Character.isDigit(string.charAt(0)) && Character.isDigit(string2.charAt(0))) {
            return -1;
        }
        return string.compareTo(string2);
    }

    private static int compareId(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        long l;
        long l2 = osmPrimitive.getUniqueId();
        if (l2 < (l = osmPrimitive2.getUniqueId())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    private int compareType(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (this.relationsFirst) {
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                return -1;
            }
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (osmPrimitive2.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                return 1;
            }
        } else {
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return -1;
            }
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (osmPrimitive2.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (osmPrimitive.getType().equals((Object)osmPrimitive2.getType())) {
            return this.quick ? OsmPrimitiveComparator.compareId(osmPrimitive, osmPrimitive2) : this.compareName(osmPrimitive, osmPrimitive2);
        }
        return this.compareType(osmPrimitive, osmPrimitive2);
    }
}

