/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class MultipolygonBuilder {
    private static final Pair<Integer, ExecutorService> THREAD_POOL = Utils.newThreadPool("multipolygon_creation.numberOfThreads");
    public final List<JoinedPolygon> outerWays;
    public final List<JoinedPolygon> innerWays;

    public MultipolygonBuilder(List<JoinedPolygon> list, List<JoinedPolygon> list2) {
        this.outerWays = list;
        this.innerWays = list2;
    }

    public MultipolygonBuilder() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    public String makeFromWays(Collection<Way> collection) {
        try {
            List<JoinedPolygon> list = MultipolygonBuilder.joinWays(collection);
            return this.makeFromPolygons(list);
        }
        catch (JoinedPolygonCreationException joinedPolygonCreationException) {
            return joinedPolygonCreationException.getMessage();
        }
    }

    public static List<JoinedPolygon> joinWays(Collection<Way> collection) throws JoinedPolygonCreationException {
        Object object;
        ArrayList<JoinedPolygon> arrayList = new ArrayList<JoinedPolygon>();
        MultiMap<Node, Way> multiMap = new MultiMap<Node, Way>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (Way way : collection) {
            if (way.getNodesCount() < 2) {
                throw new JoinedPolygonCreationException(I18n.tr("Cannot add a way with only {0} nodes.", way.getNodesCount()));
            }
            if (way.isClosed()) {
                object = new JoinedPolygon(way);
                arrayList.add((JoinedPolygon)object);
                hashSet.add(way);
                continue;
            }
            multiMap.put(way.lastNode(), way);
            multiMap.put(way.firstNode(), way);
        }
        for (Way way : collection) {
            if (hashSet.contains(way)) continue;
            object = way.firstNode();
            ArrayList<Way> arrayList2 = new ArrayList<Way>();
            ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
            Way way2 = way;
            Object object2 = object;
            while (true) {
                boolean bl = object2 == way2.lastNode();
                Node node = bl ? way2.firstNode() : way2.lastNode();
                arrayList2.add(way2);
                arrayList3.add(bl);
                if (node == object) break;
                Set set = multiMap.get(node);
                if (set.size() != 2) {
                    throw new JoinedPolygonCreationException(I18n.tr("Each node must connect exactly 2 ways", new Object[0]));
                }
                Way way3 = null;
                for (Way way4 : set) {
                    if (way4 == way2) continue;
                    way3 = way4;
                }
                way2 = way3;
                object2 = node;
            }
            hashSet.addAll(arrayList2);
            arrayList.add(new JoinedPolygon(arrayList2, arrayList3));
        }
        return arrayList;
    }

    private String makeFromPolygons(List<JoinedPolygon> list) {
        List<PolygonLevel> list2 = MultipolygonBuilder.findOuterWaysMultiThread(list);
        if (list2 == null) {
            return I18n.tr("There is an intersection between ways.", new Object[0]);
        }
        this.outerWays.clear();
        this.innerWays.clear();
        for (PolygonLevel polygonLevel : list2) {
            if (polygonLevel.level % 2 == 0) {
                this.outerWays.add(polygonLevel.outerWay);
                continue;
            }
            this.innerWays.add(polygonLevel.outerWay);
        }
        return null;
    }

    private static Pair<Boolean, List<JoinedPolygon>> findInnerWaysCandidates(JoinedPolygon joinedPolygon, Collection<JoinedPolygon> collection) {
        boolean bl = true;
        ArrayList<JoinedPolygon> arrayList = new ArrayList<JoinedPolygon>();
        for (JoinedPolygon joinedPolygon2 : collection) {
            if (joinedPolygon2 == joinedPolygon || !joinedPolygon.bounds.intersects(joinedPolygon2.bounds)) continue;
            Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(joinedPolygon.area, joinedPolygon2.area);
            if (polygonIntersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                bl = false;
                break;
            }
            if (polygonIntersection == Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) {
                arrayList.add(joinedPolygon2);
                continue;
            }
            if (polygonIntersection != Geometry.PolygonIntersection.CROSSING) continue;
            return null;
        }
        return new Pair<Boolean, List<JoinedPolygon>>(bl, arrayList);
    }

    private static List<PolygonLevel> findOuterWaysMultiThread(List<JoinedPolygon> list) {
        ArrayList<PolygonLevel> arrayList = new ArrayList<PolygonLevel>();
        ArrayList<Worker> arrayList2 = new ArrayList<Worker>();
        int n = Math.max(32, list.size() / (Integer)MultipolygonBuilder.THREAD_POOL.a / 3);
        int n2 = (list.size() + n - 1) / n;
        boolean bl = (Integer)MultipolygonBuilder.THREAD_POOL.a == 1 || n2 == 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            int n4 = Math.min((i + 1) * n, list.size());
            ArrayList<PolygonLevel> arrayList3 = bl ? arrayList : new ArrayList<PolygonLevel>(n4 - n3);
            arrayList2.add(new Worker(list, n3, n4, arrayList3));
        }
        if (bl) {
            try {
                for (Worker worker : arrayList2) {
                    if (worker.call() != null) continue;
                    return null;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (!arrayList2.isEmpty()) {
            try {
                for (Future future : ((ExecutorService)MultipolygonBuilder.THREAD_POOL.b).invokeAll(arrayList2)) {
                    List list2 = (List)future.get();
                    if (list2 == null) {
                        return null;
                    }
                    arrayList.addAll(list2);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        }
        return arrayList;
    }

    private static class Worker
    implements Callable<List<PolygonLevel>> {
        private final List<JoinedPolygon> input;
        private final int from;
        private final int to;
        private final List<PolygonLevel> output;

        public Worker(List<JoinedPolygon> list, int n, int n2, List<PolygonLevel> list2) {
            this.input = list;
            this.from = n;
            this.to = n2;
            this.output = list2;
        }

        private static List<PolygonLevel> findOuterWaysRecursive(int n, List<JoinedPolygon> list) {
            ArrayList<PolygonLevel> arrayList = new ArrayList<PolygonLevel>();
            for (JoinedPolygon joinedPolygon : list) {
                if (Worker.processOuterWay(n, list, arrayList, joinedPolygon) != null) continue;
                return null;
            }
            return arrayList;
        }

        private static List<PolygonLevel> processOuterWay(int n, List<JoinedPolygon> list, List<PolygonLevel> list2, JoinedPolygon joinedPolygon) {
            Pair pair = MultipolygonBuilder.findInnerWaysCandidates(joinedPolygon, list);
            if (pair == null) {
                return null;
            }
            if (((Boolean)pair.a).booleanValue()) {
                PolygonLevel polygonLevel = new PolygonLevel(joinedPolygon, n);
                if (!((List)pair.b).isEmpty()) {
                    List<PolygonLevel> list3 = Worker.findOuterWaysRecursive(n + 1, (List)pair.b);
                    if (list3 == null) {
                        return null;
                    }
                    list2.addAll(list3);
                    for (PolygonLevel polygonLevel2 : list3) {
                        if (polygonLevel2.level != n + 1) continue;
                        polygonLevel.innerWays.add(polygonLevel2.outerWay);
                    }
                }
                list2.add(polygonLevel);
            }
            return list2;
        }

        @Override
        public List<PolygonLevel> call() throws Exception {
            for (int i = this.from; i < this.to; ++i) {
                if (Worker.processOuterWay(0, this.input, this.output, this.input.get(i)) != null) continue;
                return null;
            }
            return this.output;
        }
    }

    public static class JoinedPolygonCreationException
    extends RuntimeException {
        public JoinedPolygonCreationException(String string) {
            super(string);
        }
    }

    static class PolygonLevel {
        public final int level;
        public final JoinedPolygon outerWay;
        public List<JoinedPolygon> innerWays;

        public PolygonLevel(JoinedPolygon joinedPolygon, int n) {
            this.outerWay = joinedPolygon;
            this.level = n;
            this.innerWays = new ArrayList<JoinedPolygon>();
        }
    }

    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;
        public final Area area;
        public final Rectangle bounds;

        public JoinedPolygon(List<Way> list, List<Boolean> list2) {
            this.ways = list;
            this.reversed = list2;
            this.nodes = this.getNodes();
            this.area = Geometry.getArea(this.nodes);
            this.bounds = this.area.getBounds();
        }

        public JoinedPolygon(Way way) {
            this(Collections.singletonList(way), Collections.singletonList(Boolean.FALSE));
        }

        public List<Node> getNodes() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < this.ways.size(); ++i) {
                int n;
                Way way = this.ways.get(i);
                boolean bl = this.reversed.get(i);
                if (!bl) {
                    for (n = 0; n < way.getNodesCount() - 1; ++n) {
                        arrayList.add(way.getNode(n));
                    }
                    continue;
                }
                for (n = way.getNodesCount() - 1; n > 0; --n) {
                    arrayList.add(way.getNode(n));
                }
            }
            return arrayList;
        }
    }
}

