/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.types.EntryType;
import org.openstreetmap.josm.data.imagery.types.ProjectionType;
import org.openstreetmap.josm.data.imagery.types.WmsCacheType;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class WmsCache {
    private static final StringProperty PROP_CACHE_PATH = new StringProperty("imagery.wms-cache.path", "wms");
    private static final String INDEX_FILENAME = "index.xml";
    private static final String LAYERS_INDEX_FILENAME = "layers.properties";
    private final Map<String, ProjectionEntries> entries = new HashMap<String, ProjectionEntries>();
    private final File cacheDir;
    private final int tileSize;
    private int totalFileSize;
    private boolean totalFileSizeDirty;
    private Map<CacheEntry, SoftReference<BufferedImage>> memoryCache = new HashMap<CacheEntry, SoftReference<BufferedImage>>();
    private Set<ProjectionBounds> areaToCache;

    protected String cacheDirPath() {
        String string = PROP_CACHE_PATH.get();
        if (!new File(string).isAbsolute()) {
            string = Main.pref.getCacheDirectory() + File.separator + string;
        }
        return string;
    }

    public WmsCache(String string, int n) {
        File file = new File(this.cacheDirPath());
        file.mkdirs();
        this.cacheDir = new File(file, this.getCacheDirectory(string));
        this.cacheDir.mkdirs();
        this.tileSize = n;
    }

    private String getCacheDirectory(String string) {
        Object object;
        Object object22;
        String string2 = null;
        Properties properties = new Properties();
        File file = new File(this.cacheDirPath(), LAYERS_INDEX_FILENAME);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object22 = null;
            try {
                properties.load(fileInputStream);
            }
            catch (Throwable throwable) {
                object22 = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object22 != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object22).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)fileInputStream).close();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.error("Unable to load layers index for wms cache (file " + file + " not found)");
        }
        catch (IOException iOException) {
            Main.error("Unable to load layers index for wms cache");
            Main.error(iOException);
        }
        for (Object object22 : properties.keySet()) {
            object = (String)object22;
            if (!string.equals(properties.getProperty((String)object))) continue;
            string2 = object;
            break;
        }
        if (string2 == null) {
            int n = 0;
            while (properties.keySet().contains(String.valueOf(++n))) {
            }
            string2 = String.valueOf(n);
            properties.setProperty(string2, string);
            try {
                object22 = new FileOutputStream(file);
                object = null;
                try {
                    properties.store((OutputStream)object22, "");
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object22 != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)object22).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)object22).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Main.error("Unable to save layer index for wms cache");
                Main.error(iOException);
            }
        }
        return string2;
    }

    private ProjectionEntries getProjectionEntries(Projection projection) {
        return this.getProjectionEntries(projection.toCode(), projection.getCacheDirectoryName());
    }

    private ProjectionEntries getProjectionEntries(String string, String string2) {
        ProjectionEntries projectionEntries = this.entries.get(string);
        if (projectionEntries == null) {
            projectionEntries = new ProjectionEntries(string, string2);
            this.entries.put(string, projectionEntries);
        }
        return projectionEntries;
    }

    public synchronized void loadIndex() {
        File file = new File(this.cacheDir, INDEX_FILENAME);
        try {
            WmsCacheType wmsCacheType;
            JAXBContext jAXBContext = JAXBContext.newInstance((String)WmsCacheType.class.getPackage().getName(), (ClassLoader)WmsCacheType.class.getClassLoader());
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Throwable object2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                wmsCacheType = (WmsCacheType)unmarshaller.unmarshal((InputStream)fileInputStream);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
            this.totalFileSize = wmsCacheType.getTotalFileSize();
            if (wmsCacheType.getTileSize() != this.tileSize) {
                Main.info("Cache created with different tileSize, cache will be discarded");
                return;
            }
            for (ProjectionType projectionType : wmsCacheType.getProjection()) {
                ProjectionEntries projectionEntries = this.getProjectionEntries(projectionType.getName(), projectionType.getCacheDirectory());
                for (EntryType entryType : projectionType.getEntry()) {
                    CacheEntry cacheEntry = new CacheEntry(entryType.getPixelPerDegree(), entryType.getEast(), entryType.getNorth(), this.tileSize, entryType.getFilename());
                    cacheEntry.lastUsed = entryType.getLastUsed().getTimeInMillis();
                    cacheEntry.lastModified = entryType.getLastModified().getTimeInMillis();
                    projectionEntries.entries.add(cacheEntry);
                }
            }
        }
        catch (Exception exception) {
            if (file.exists()) {
                Main.error(exception);
                Main.info("Unable to load index for wms-cache, new file will be created");
            }
            Main.info("Index for wms-cache doesn't exist, new file will be created");
        }
        this.removeNonReferencedFiles();
    }

    private void removeNonReferencedFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ProjectionEntries projectionEntries : this.entries.values()) {
            hashSet.add(projectionEntries.cacheDirectory);
            File file = new File(this.cacheDir, projectionEntries.cacheDirectory);
            if (!file.exists()) continue;
            HashSet<String> serializable = new HashSet<String>();
            for (CacheEntry cacheEntry : projectionEntries.entries) {
                serializable.add(cacheEntry.filename);
            }
            for (File file2 : file.listFiles()) {
                if (serializable.contains(file2.getName())) continue;
                file2.delete();
            }
        }
        for (File file : this.cacheDir.listFiles()) {
            if (!file.isDirectory() || hashSet.contains(file.getName())) continue;
            Utils.deleteDirectory(file);
        }
    }

    private int calculateTotalFileSize() {
        int n = 0;
        for (ProjectionEntries projectionEntries : this.entries.values()) {
            Iterator<CacheEntry> iterator = projectionEntries.entries.iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry = iterator.next();
                File file = this.getImageFile(projectionEntries, cacheEntry);
                if (!file.exists()) {
                    iterator.remove();
                    continue;
                }
                n = (int)((long)n + file.length());
            }
        }
        return n;
    }

    public synchronized void saveIndex() {
        Object object;
        WmsCacheType wmsCacheType = new WmsCacheType();
        if (this.totalFileSizeDirty) {
            this.totalFileSize = this.calculateTotalFileSize();
        }
        wmsCacheType.setTileSize(this.tileSize);
        wmsCacheType.setTotalFileSize(this.totalFileSize);
        for (ProjectionEntries projectionEntries : this.entries.values()) {
            if (projectionEntries.entries.isEmpty()) continue;
            object = new ProjectionType();
            ((ProjectionType)object).setName(projectionEntries.projection);
            ((ProjectionType)object).setCacheDirectory(projectionEntries.cacheDirectory);
            wmsCacheType.getProjection().add((ProjectionType)object);
            for (CacheEntry cacheEntry : projectionEntries.entries) {
                EntryType entryType = new EntryType();
                entryType.setPixelPerDegree(cacheEntry.pixelPerDegree);
                entryType.setEast(cacheEntry.east);
                entryType.setNorth(cacheEntry.north);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(cacheEntry.lastUsed);
                entryType.setLastUsed(calendar);
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(cacheEntry.lastModified);
                entryType.setLastModified(calendar);
                entryType.setFilename(cacheEntry.filename);
                ((ProjectionType)object).getEntry().add(entryType);
            }
        }
        try {
            ProjectionEntries projectionEntries;
            JAXBContext jAXBContext = JAXBContext.newInstance((String)WmsCacheType.class.getPackage().getName(), (ClassLoader)WmsCacheType.class.getClassLoader());
            projectionEntries = jAXBContext.createMarshaller();
            object = new FileOutputStream(new File(this.cacheDir, INDEX_FILENAME));
            Object object2 = null;
            try {
                projectionEntries.marshal(wmsCacheType, (OutputStream)object);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            Main.error("Failed to save wms-cache file");
            Main.error(exception);
        }
    }

    private File getImageFile(ProjectionEntries projectionEntries, CacheEntry cacheEntry) {
        return new File(this.cacheDir, projectionEntries.cacheDirectory + "/" + cacheEntry.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage loadImage(ProjectionEntries projectionEntries, CacheEntry cacheEntry, boolean bl) throws IOException {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            BufferedImage bufferedImage;
            cacheEntry.lastUsed = System.currentTimeMillis();
            object = this.memoryCache.get(cacheEntry);
            if (object != null && (bufferedImage = ((SoftReference)object).get()) != null) {
                if (bl == ImageProvider.isTransparencyForced(bufferedImage)) {
                    return bufferedImage;
                }
                if (Main.isDebugEnabled()) {
                    Main.debug("Skipping " + cacheEntry + " from memory cache (transparency enforcement)");
                }
            }
        }
        try {
            object2 = ImageProvider.read(this.getImageFile(projectionEntries, cacheEntry), true, bl);
            object = this;
            synchronized (object) {
                if (object2 == null) {
                    projectionEntries.entries.remove(cacheEntry);
                    this.totalFileSizeDirty = true;
                }
                return object2;
            }
        }
        catch (IOException iOException) {
            object = this;
            synchronized (object) {
                projectionEntries.entries.remove(cacheEntry);
                this.totalFileSizeDirty = true;
                throw iOException;
            }
        }
    }

    private CacheEntry findEntry(ProjectionEntries projectionEntries, double d, double d2, double d3) {
        for (CacheEntry cacheEntry : projectionEntries.entries) {
            if (cacheEntry.pixelPerDegree != d || cacheEntry.east != d2 || cacheEntry.north != d3) continue;
            return cacheEntry;
        }
        return null;
    }

    public synchronized boolean hasExactMatch(Projection projection, double d, double d2, double d3) {
        ProjectionEntries projectionEntries = this.getProjectionEntries(projection);
        CacheEntry cacheEntry = this.findEntry(projectionEntries, d, d2, d3);
        return cacheEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getExactMatch(Projection projection, double d, double d2, double d3) {
        CacheEntry cacheEntry = null;
        ProjectionEntries projectionEntries = null;
        WmsCache wmsCache = this;
        synchronized (wmsCache) {
            projectionEntries = this.getProjectionEntries(projection);
            cacheEntry = this.findEntry(projectionEntries, d, d2, d3);
        }
        if (cacheEntry != null) {
            try {
                return this.loadImage(projectionEntries, cacheEntry, WMSLayer.PROP_ALPHA_CHANNEL.get());
            }
            catch (IOException iOException) {
                Main.error("Unable to load file from wms cache");
                Main.error(iOException);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getPartialMatch(Projection projection, double d, double d2, double d3) {
        ProjectionEntries projectionEntries;
        ArrayList<CacheEntry> arrayList;
        WmsCache wmsCache = this;
        synchronized (wmsCache) {
            arrayList = new ArrayList<CacheEntry>();
            double d4 = d / 5.0;
            double d5 = d * 5.0;
            projectionEntries = this.getProjectionEntries(projection);
            double d6 = (double)this.tileSize / d;
            double d7 = (double)this.tileSize * 0.01;
            ProjectionBounds projectionBounds = new ProjectionBounds(d2 + d7, d3 + d7, d2 + d6 - d7, d3 + d6 - d7);
            for (CacheEntry cacheEntry : projectionEntries.entries) {
                if (!(cacheEntry.pixelPerDegree >= d4) || !(cacheEntry.pixelPerDegree <= d5) || !cacheEntry.bounds.intersects(projectionBounds)) continue;
                cacheEntry.lastUsed = System.currentTimeMillis();
                arrayList.add(cacheEntry);
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            Collections.sort(arrayList, new Comparator<CacheEntry>(){

                @Override
                public int compare(CacheEntry cacheEntry, CacheEntry cacheEntry2) {
                    return Double.compare(cacheEntry2.pixelPerDegree, cacheEntry.pixelPerDegree);
                }
            });
        }
        boolean bl = WMSLayer.PROP_ALPHA_CHANNEL.get();
        BufferedImage bufferedImage = new BufferedImage(this.tileSize, this.tileSize, bl ? 6 : 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        boolean bl2 = false;
        HashMap<CacheEntry, SoftReference<BufferedImage>> hashMap = new HashMap<CacheEntry, SoftReference<BufferedImage>>();
        for (CacheEntry cacheEntry : arrayList) {
            BufferedImage bufferedImage2;
            try {
                bufferedImage2 = this.loadImage(projectionEntries, cacheEntry, bl);
                hashMap.put(cacheEntry, new SoftReference<BufferedImage>(bufferedImage2));
            }
            catch (IOException iOException) {
                continue;
            }
            bl2 = true;
            int n = (int)((cacheEntry.east - d2) * d);
            int n2 = (int)((cacheEntry.north - d3) * d);
            int n3 = (int)(d / cacheEntry.pixelPerDegree * (double)this.tileSize);
            int n4 = n;
            int n5 = -n3 + this.tileSize - n2;
            graphics2D.drawImage(bufferedImage2, n4, n5, n3, n3, null);
        }
        if (bl2) {
            WmsCache wmsCache2 = this;
            synchronized (wmsCache2) {
                this.memoryCache.putAll(hashMap);
            }
            return bufferedImage;
        }
        return null;
    }

    private String generateFileName(ProjectionEntries projectionEntries, double d, Projection projection, double d2, double d3, String string) {
        String string2;
        LatLon latLon = projection.eastNorth2latlon(new EastNorth(d2, d3));
        LatLon latLon2 = projection.eastNorth2latlon(new EastNorth(d2 + 100.0 / d, d3));
        LatLon latLon3 = projection.eastNorth2latlon(new EastNorth(d2 + (double)this.tileSize / d, d3 + (double)this.tileSize / d));
        double d4 = Math.abs(latLon3.lat() - latLon.lat());
        double d5 = Math.abs(latLon3.lon() - latLon.lon());
        int n = Math.max(0, -((int)Math.ceil(Math.log10(d4))) + 1);
        int n2 = Math.max(0, -((int)Math.ceil(Math.log10(d5))) + 1);
        String string3 = SystemOfMeasurement.METRIC.getDistText(latLon.greatCircleDistance(latLon2));
        String string4 = "dat";
        if (string != null) {
            switch (string) {
                case "image/jpeg": 
                case "image/jpg": {
                    string4 = "jpg";
                    break;
                }
                case "image/png": {
                    string4 = "png";
                    break;
                }
                case "image/gif": {
                    string4 = "gif";
                    break;
                }
                default: {
                    Main.warn("Unrecognized MIME type: " + string);
                }
            }
        }
        int n3 = 0;
        block11: while (true) {
            string2 = String.format("%s_%." + n + "f_%." + n2 + "f%s.%s", string3, latLon.lat(), latLon.lon(), n3 == 0 ? "" : "_" + n3, string4);
            for (CacheEntry cacheEntry : projectionEntries.entries) {
                if (!cacheEntry.filename.equals(string2)) continue;
                ++n3;
                continue block11;
            }
            break;
        }
        return string2;
    }

    public synchronized void saveToCache(BufferedImage bufferedImage, InputStream inputStream, Projection projection, double d, double d2, double d3) throws IOException {
        File file;
        Object object;
        ProjectionEntries projectionEntries = this.getProjectionEntries(projection);
        CacheEntry cacheEntry = this.findEntry(projectionEntries, d, d2, d3);
        if (cacheEntry == null) {
            object = bufferedImage != null ? "image/png" : URLConnection.guessContentTypeFromStream(inputStream);
            cacheEntry = new CacheEntry(d, d2, d3, this.tileSize, this.generateFileName(projectionEntries, d, projection, d2, d3, (String)object));
            cacheEntry.lastModified = cacheEntry.lastUsed = System.currentTimeMillis();
            projectionEntries.entries.add(cacheEntry);
            file = this.getImageFile(projectionEntries, cacheEntry);
        } else {
            file = this.getImageFile(projectionEntries, cacheEntry);
            this.totalFileSize = (int)((long)this.totalFileSize - file.length());
        }
        file.getParentFile().mkdirs();
        if (bufferedImage != null) {
            object = new BufferedImage(this.tileSize, this.tileSize, bufferedImage.getType());
            ((BufferedImage)object).createGraphics().drawImage(bufferedImage, 0, 0, this.tileSize, this.tileSize, 0, bufferedImage.getHeight() - this.tileSize, this.tileSize, bufferedImage.getHeight(), null);
            ImageIO.write((RenderedImage)object, "png", file);
            this.totalFileSize = (int)((long)this.totalFileSize + file.length());
        } else {
            object = new BufferedOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                this.totalFileSize += Utils.copyStream(inputStream, (OutputStream)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)object).close();
                    }
                }
            }
        }
    }

    public synchronized void cleanSmallFiles(int n) {
        for (ProjectionEntries projectionEntries : this.entries.values()) {
            Iterator<CacheEntry> iterator = projectionEntries.entries.iterator();
            while (iterator.hasNext()) {
                File file = this.getImageFile(projectionEntries, iterator.next());
                long l = file.length();
                if (l > (long)n) continue;
                if (l == 0L) {
                    this.totalFileSizeDirty = true;
                }
                this.totalFileSize -= n;
                file.delete();
                iterator.remove();
            }
        }
    }

    public static String printDate(Calendar calendar) {
        return DateUtils.newIsoDateFormat().format(calendar.getTime());
    }

    private boolean isInsideAreaToCache(CacheEntry cacheEntry) {
        for (ProjectionBounds projectionBounds : this.areaToCache) {
            if (!cacheEntry.bounds.intersects(projectionBounds)) continue;
            return true;
        }
        return false;
    }

    public synchronized void setAreaToCache(Set<ProjectionBounds> set) {
        this.areaToCache = set;
        Iterator<CacheEntry> iterator = this.memoryCache.keySet().iterator();
        while (iterator.hasNext()) {
            if (this.isInsideAreaToCache(iterator.next())) continue;
            iterator.remove();
        }
    }

    private static class ProjectionEntries {
        final String projection;
        final String cacheDirectory;
        final List<CacheEntry> entries = new ArrayList<CacheEntry>();

        ProjectionEntries(String string, String string2) {
            this.projection = string;
            this.cacheDirectory = string2;
        }
    }

    private static class CacheEntry {
        final double pixelPerDegree;
        final double east;
        final double north;
        final ProjectionBounds bounds;
        final String filename;
        long lastUsed;
        long lastModified;

        CacheEntry(double d, double d2, double d3, int n, String string) {
            this.pixelPerDegree = d;
            this.east = d2;
            this.north = d3;
            this.bounds = new ProjectionBounds(d2, d3, d2 + (double)n / d, d3 + (double)n / d);
            this.filename = string;
        }

        public String toString() {
            return "CacheEntry [pixelPerDegree=" + this.pixelPerDegree + ", east=" + this.east + ", north=" + this.north + ", bounds=" + this.bounds + ", filename=" + this.filename + ", lastUsed=" + this.lastUsed + ", lastModified=" + this.lastModified + "]";
        }
    }
}

