/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class DataSource {
    public final Bounds bounds;
    public final String origin;

    public DataSource(Bounds bounds, String string) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "bounds");
        this.bounds = bounds;
        this.origin = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.bounds == null ? 0 : this.bounds.hashCode());
        n = 31 * n + (this.origin == null ? 0 : this.origin.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataSource dataSource = (DataSource)object;
        if (this.bounds == null ? dataSource.bounds != null : !this.bounds.equals(dataSource.bounds)) {
            return false;
        }
        return !(this.origin == null ? dataSource.origin != null : !this.origin.equals(dataSource.origin));
    }

    public String toString() {
        return "DataSource [bounds=" + this.bounds + ", origin=" + this.origin + "]";
    }

    public static Area getDataSourceArea(Collection<DataSource> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : collection) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public static List<Bounds> getDataSourceBounds(Collection<DataSource> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Bounds> arrayList = new ArrayList<Bounds>(collection.size());
        for (DataSource dataSource : collection) {
            if (dataSource.bounds == null) continue;
            arrayList.add(dataSource.bounds);
        }
        return arrayList;
    }
}

