/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.NoteDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddNoteAction
extends MapMode {
    private NoteData noteData;

    public AddNoteAction(MapFrame mapFrame, NoteData noteData) {
        super(I18n.tr("Add a new Note", new Object[0]), "addnote.png", I18n.tr("Add note mode", new Object[0]), mapFrame, ImageProvider.getCursor("crosshair", "create_note"));
        if (noteData == null) {
            throw new IllegalArgumentException("Note data must not be null");
        }
        this.noteData = noteData;
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click the location where you wish to create a new note", new Object[0]);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Main.map.selectMapMode(Main.map.mapModeSelect);
        LatLon latLon = Main.map.mapView.getLatLon(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        JLabel jLabel = new JLabel(I18n.tr("Enter a comment for a new note", new Object[0]));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(6);
        jTextArea.setColumns(30);
        jTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Object[] objectArray = new Object[]{jLabel, jScrollPane};
        int n = JOptionPane.showConfirmDialog(Main.map, objectArray, I18n.tr("Create new note", new Object[0]), 2, -1, NoteDialog.ICON_NEW);
        if (n == 0) {
            String string = jTextArea.getText();
            if (string != null && !string.isEmpty()) {
                this.noteData.createNote(latLon, string);
            } else {
                Notification notification = new Notification("You must enter a comment to create a new note");
                notification.setIcon(2);
                notification.show();
            }
        }
    }
}

