/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.AggregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidateAction
extends JosmAction {
    private Collection<OsmPrimitive> lastSelection;

    public ValidateAction() {
        super(I18n.tr("Validation", new Object[0]), "dialogs/validator", I18n.tr("Performs the data validation", new Object[0]), Shortcut.registerShortcut("tools:validate", I18n.tr("Tool: {0}", I18n.tr("Validation", new Object[0])), 86, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doValidate(actionEvent, true);
    }

    public void doValidate(ActionEvent actionEvent, boolean bl) {
        Object object;
        Collection<OsmPrimitive> collection;
        if (Main.map == null || !Main.map.isVisible()) {
            return;
        }
        OsmValidator.initializeTests();
        OsmValidator.initializeErrorLayer();
        Collection<Test> collection2 = OsmValidator.getEnabledTests(false);
        if (collection2.isEmpty()) {
            return;
        }
        if (bl) {
            collection = Main.main.getCurrentDataSet().getAllSelected();
            if (collection.isEmpty()) {
                collection = Main.main.getCurrentDataSet().allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                object = new AggregatePrimitivesVisitor();
                collection = ((AggregatePrimitivesVisitor)object).visit(collection);
                this.lastSelection = collection;
            }
        } else {
            collection = this.lastSelection == null ? Main.main.getCurrentDataSet().allNonDeletedPrimitives() : this.lastSelection;
        }
        object = new ValidationTask(collection2, collection, this.lastSelection);
        Main.worker.submit((Runnable)object);
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(ValidateAction.getEditLayer() != null);
    }

    @Override
    public void destroy() {
    }

    static class ValidationTask
    extends PleaseWaitRunnable {
        private Collection<Test> tests;
        private Collection<OsmPrimitive> validatedPrimitives;
        private Collection<OsmPrimitive> formerValidatedPrimitives;
        private boolean canceled;
        private List<TestError> errors;

        public ValidationTask(Collection<Test> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
            super(I18n.tr("Validating", new Object[0]), false);
            this.validatedPrimitives = collection2;
            this.formerValidatedPrimitives = collection3;
            this.tests = collection;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    Main.map.validatorDialog.tree.setErrors(ValidationTask.this.errors);
                    Main.map.validatorDialog.unfurlDialog();
                    Main.main.getCurrentDataSet().fireSelectionChanged();
                }
            });
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.tests == null || this.tests.isEmpty()) {
                return;
            }
            this.errors = new ArrayList<TestError>(200);
            this.getProgressMonitor().setTicksCount(this.tests.size() * this.validatedPrimitives.size());
            int n = 0;
            for (Test object : this.tests) {
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().setCustomText(I18n.tr("Test {0}/{1}: Starting {2}", ++n, this.tests.size(), object.getName()));
                object.setPartialSelection(this.formerValidatedPrimitives != null);
                object.startTest(this.getProgressMonitor().createSubTaskMonitor(this.validatedPrimitives.size(), false));
                object.visit(this.validatedPrimitives);
                object.endTest();
                this.errors.addAll(object.getErrors());
            }
            this.tests = null;
            if (Main.pref.getBoolean("validator.ignore", true)) {
                this.getProgressMonitor().subTask(I18n.tr("Updating ignored errors ...", new Object[0]));
                for (TestError testError : this.errors) {
                    if (this.canceled) {
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(testError.getIgnoreState());
                    arrayList.add(testError.getIgnoreGroup());
                    arrayList.add(testError.getIgnoreSubGroup());
                    for (String string : arrayList) {
                        if (string == null || !OsmValidator.hasIgnoredError(string)) continue;
                        testError.setIgnored(true);
                    }
                }
            }
        }
    }
}

