/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

public class SelectNonBranchingWaySequences {
    Set<Node> outerNodes;
    Set<Node> nodes;

    public SelectNonBranchingWaySequences(Collection<Way> collection) {
        if (collection.isEmpty()) {
            this.outerNodes = null;
            this.nodes = null;
        } else {
            this.nodes = new TreeSet<Node>();
            this.outerNodes = new TreeSet<Node>();
            for (Way way : collection) {
                this.addNodes(way);
            }
        }
    }

    private void addNodes(Node node) {
        if (node == null) {
            return;
        }
        if (!this.nodes.add(node)) {
            this.outerNodes.remove(node);
        } else {
            this.outerNodes.add(node);
        }
    }

    private void addNodes(Way way) {
        this.addNodes(way.firstNode());
        this.addNodes(way.lastNode());
    }

    public boolean canExtend() {
        return this.outerNodes != null && !this.outerNodes.isEmpty();
    }

    private static Way findWay(Collection<OsmPrimitive> collection, Node node) {
        Way way = null;
        for (Way way2 : OsmPrimitive.getFilteredList(node.getReferrers(), Way.class)) {
            if (way2.getNodesCount() < 2 || !way2.isFirstLastNode(node) || collection.contains(way2)) continue;
            if (way != null) {
                return null;
            }
            way = way2;
        }
        return way;
    }

    private Way findWay(Collection<OsmPrimitive> collection) {
        for (Node node : this.outerNodes) {
            Way way = SelectNonBranchingWaySequences.findWay(collection, node);
            if (way == null) continue;
            return way;
        }
        return null;
    }

    public void extend(DataSet dataSet) {
        boolean bl = false;
        if (!this.canExtend()) {
            return;
        }
        Collection<OsmPrimitive> collection = dataSet.getSelected();
        Way way = this.findWay(collection);
        if (way == null) {
            return;
        }
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            linkedList.add(osmPrimitive);
        }
        while (linkedList.add(way)) {
            bl = true;
            this.addNodes(way);
            way = this.findWay(linkedList);
            if (way != null) continue;
        }
        if (bl) {
            dataSet.setSelected(linkedList, true);
        }
    }
}

