/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle", new Object[0]), "aligncircle", I18n.tr("Create a circle from three selected nodes.", new Object[0]), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle", new Object[0])), 79, 5005), true, "createcircle", true);
        this.putValue("help", HelpUtil.ht("/Action/CreateCircle"));
    }

    private int[] distributeNodes(PolarNode[] polarNodeArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[polarNodeArray.length];
        double[] dArray = new double[polarNodeArray.length];
        double[] dArray2 = new double[polarNodeArray.length];
        for (n3 = 0; n3 < polarNodeArray.length; ++n3) {
            dArray[n3] = polarNodeArray[(n3 + 1) % polarNodeArray.length].a - polarNodeArray[n3].a;
            if (!(dArray[n3] < 0.0)) continue;
            int n4 = n3;
            dArray[n4] = dArray[n4] + Math.PI * 2;
        }
        n3 = 0;
        for (n2 = 0; n2 < polarNodeArray.length; ++n2) {
            double d = dArray[n2] / 2.0 / Math.PI * (double)n;
            nArray[n2] = (int)Math.floor(d);
            dArray2[n2] = d - (double)nArray[n2];
            n3 += nArray[n2];
        }
        while (n3 < n) {
            n2 = 0;
            for (int i = 1; i < polarNodeArray.length; ++i) {
                if (!(dArray2[i] > dArray2[n2])) continue;
                n2 = i;
            }
            int n5 = n2;
            nArray[n5] = nArray[n5] + 1;
            dArray2[n2] = 0.0;
            ++n3;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        void var7_13;
        double d;
        double d2;
        Object object;
        Object object2;
        if (!this.isEnabled()) {
            return;
        }
        int n = Main.pref.getInteger("createcircle.nodecount", 16);
        if (n < 1) {
            n = 1;
        } else if (n > 100) {
            n = 100;
        }
        Collection<OsmPrimitive> collection = CreateCircleAction.getCurrentDataSet().getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Way way = null;
        for (OsmPrimitive object32 : collection) {
            if (!(object32 instanceof Node)) continue;
            linkedList.add((Node)object32);
        }
        if (linkedList.isEmpty() && collection.size() == 1) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!(osmPrimitive instanceof Way)) continue;
                way = (Way)osmPrimitive;
                for (Node node : ((Way)osmPrimitive).getNodes()) {
                    if (linkedList.contains(node)) continue;
                    linkedList.add(node);
                }
            }
        }
        if (linkedList.size() < 2 || linkedList.size() > 3) {
            new Notification(I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
            return;
        }
        LinkedList linkedList2 = new LinkedList();
        Object var7_10 = null;
        if (linkedList.size() == 2) {
            object2 = (Node)linkedList.get(0);
            double d3 = ((Node)object2).getEastNorth().east();
            double d4 = ((Node)object2).getEastNorth().north();
            object = (Node)linkedList.get(1);
            double d5 = ((Node)object).getEastNorth().east();
            double d6 = ((Node)object).getEastNorth().north();
            d2 = 0.5 * (d3 + d5);
            d = 0.5 * (d4 + d6);
            EastNorth eastNorth = new EastNorth(d2, d);
        } else {
            EastNorth eastNorth = Geometry.getCenter(linkedList);
            if (eastNorth == null) {
                CreateCircleAction.notifyNodesNotOnCircle();
                return;
            }
        }
        object2 = ((Node)linkedList.get(0)).getEastNorth();
        double d7 = Math.sqrt(Math.pow(var7_13.east() - ((EastNorth)object2).east(), 2.0) + Math.pow(var7_13.north() - ((EastNorth)object2).north(), 2.0));
        PolarNode[] polarNodeArray = new PolarNode[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            polarNodeArray[i] = new PolarNode((EastNorth)var7_13, (Node)linkedList.get(i));
        }
        Arrays.sort(polarNodeArray, new PolarNodeComparator());
        int[] nArray = this.distributeNodes(polarNodeArray, n >= linkedList.size() ? n - linkedList.size() : 0);
        object = new ArrayList();
        for (int i = 0; i < linkedList.size(); ++i) {
            object.add(polarNodeArray[i].node);
            double d8 = polarNodeArray[(i + 1) % linkedList.size()].a - polarNodeArray[i].a;
            if (d8 < 0.0) {
                d8 += Math.PI * 2;
            }
            for (int j = 0; j < nArray[i]; ++j) {
                d2 = polarNodeArray[i].a + (double)(j + 1) * d8 / (double)(nArray[i] + 1);
                d = var7_13.east() + d7 * Math.cos(d2);
                double d9 = var7_13.north() + d7 * Math.sin(d2);
                LatLon latLon = Main.getProjection().eastNorth2latlon(new EastNorth(d, d9));
                if (latLon.isOutSideWorld()) {
                    CreateCircleAction.notifyNodesNotOnCircle();
                    return;
                }
                Node node = new Node(latLon);
                object.add(node);
                linkedList2.add(new AddCommand(node));
            }
        }
        object.add(object.get(0));
        if (way == null) {
            Way way2 = new Way();
            way2.setNodes((List<Node>)object);
            linkedList2.add(new AddCommand(way2));
        } else {
            Way way3 = new Way(way);
            way3.setNodes((List<Node>)object);
            linkedList2.add(new ChangeCommand(way, way3));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle", new Object[0]), linkedList2));
        Main.map.repaint();
    }

    private static void notifyNodesNotOnCircle() {
        new Notification(I18n.tr("Those nodes are not in a circle. Aborting.", new Object[0])).setIcon(2).show();
    }

    @Override
    protected void updateEnabledState() {
        if (CreateCircleAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateCircleAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static class PolarNodeComparator
    implements Comparator<PolarNode> {
        private PolarNodeComparator() {
        }

        @Override
        public int compare(PolarNode polarNode, PolarNode polarNode2) {
            if (polarNode.a < polarNode2.a) {
                return -1;
            }
            if (polarNode.a == polarNode2.a) {
                return 0;
            }
            return 1;
        }
    }

    private static class PolarNode {
        double a;
        Node node;

        PolarNode(EastNorth eastNorth, Node node) {
            EastNorth eastNorth2 = node.getEastNorth();
            this.a = Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
            this.node = node;
        }
    }
}

