/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle", new Object[0]), "aligncircle", I18n.tr("Move the selected nodes into a circle.", new Object[0]), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle", new Object[0])), 79, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInCircle"));
    }

    private static double distance(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        ArrayList<Way> arrayList;
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = AlignInCircleAction.getCurrentDataSet().getSelected();
        List<Node> list = new LinkedList<Node>();
        HashSet<Node> hashSet = new HashSet<Node>();
        LinkedList<Way> linkedList = new LinkedList<Way>();
        EastNorth eastNorth = null;
        double d = 0.0;
        for (OsmPrimitive object22 : collection) {
            if (object22 instanceof Node) {
                list.add((Node)object22);
                continue;
            }
            if (!(object22 instanceof Way)) continue;
            linkedList.add((Way)object22);
        }
        if (linkedList.size() == 1 && ((Way)linkedList.get(0)).firstNode() != ((Way)linkedList.get(0)).lastNode()) {
            object = (Way)linkedList.get(0);
            hashSet.add(((Way)object).firstNode());
            hashSet.add(((Way)object).lastNode());
            hashSet.addAll(list);
            hashSet.addAll(this.collectNodesWithExternReferers(linkedList));
            Way n22 = new Way((Way)object);
            n22.addNode(((Way)object).firstNode());
            arrayList = new ArrayList<Way>(1);
            arrayList.add(n22);
            list = this.collectNodesAnticlockwise(arrayList);
        } else if (!linkedList.isEmpty() && AlignInCircleAction.checkWaysArePolygon(linkedList)) {
            object = new ArrayList();
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (Node node : list) {
                n2 = 0;
                for (Way way : linkedList) {
                    if (!way.getNodes().contains(node)) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) {
                    ((ArrayList)object).add(node);
                    continue;
                }
                arrayList2.add(node);
            }
            if (arrayList2.size() == 1 && ((ArrayList)object).isEmpty()) {
                eastNorth = ((Node)arrayList2.get(0)).getEastNorth();
            } else if (arrayList2.size() == 1 && ((ArrayList)object).size() == 1) {
                eastNorth = ((Node)arrayList2.get(0)).getEastNorth();
                d = AlignInCircleAction.distance(eastNorth, ((Node)((ArrayList)object).get(0)).getEastNorth());
            } else if (((ArrayList)object).size() == 2 && arrayList2.isEmpty()) {
                arrayList = ((Node)((ArrayList)object).get(0)).getEastNorth();
                EastNorth eastNorth2 = ((Node)((ArrayList)object).get(1)).getEastNorth();
                eastNorth = new EastNorth((((EastNorth)((Object)arrayList)).east() + eastNorth2.east()) / 2.0, (((EastNorth)((Object)arrayList)).north() + eastNorth2.north()) / 2.0);
                d = AlignInCircleAction.distance(arrayList, eastNorth2) / 2.0;
            }
            hashSet.addAll((Collection<Node>)object);
            hashSet.addAll(this.collectNodesWithExternReferers(linkedList));
            list = this.collectNodesAnticlockwise(linkedList);
            if (list.size() < 4) {
                new Notification(I18n.tr("Not enough nodes in selected ways.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
                return;
            }
        } else if (linkedList.isEmpty() && list.size() > 3) {
            hashSet.addAll(list);
        } else {
            new Notification(I18n.tr("Please select at least four nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        if (eastNorth == null && (eastNorth = Geometry.getCenter(list)) == null) {
            new Notification(I18n.tr("Cannot determine center of selected nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        if (d == 0.0) {
            for (Node node : list) {
                d += AlignInCircleAction.distance(eastNorth, node.getEastNorth());
            }
            d /= (double)list.size();
        }
        if (!this.actionAllowed(list)) {
            return;
        }
        object = new LinkedList();
        int n3 = list.size();
        int n4 = 0;
        for (n4 = 0; n4 < n3 && !hashSet.contains(list.get(n4 % n3)); ++n4) {
        }
        int n5 = n4;
        while (n < n4 + n3) {
            for (n2 = n + true; n2 < n4 + n3 && !hashSet.contains(list.get(n2 % n3)); ++n2) {
            }
            Node node = list.get((int)(n % n3));
            PolarCoor polarCoor = new PolarCoor(node.getEastNorth(), eastNorth, 0.0);
            polarCoor.radius = d;
            object.add(polarCoor.createMoveCommand(node));
            if (n2 > n + true) {
                double d2;
                if (n2 == n + n3) {
                    d2 = Math.PI * 2 / (double)n3;
                } else {
                    PolarCoor polarCoor2 = new PolarCoor(list.get(n2 % n3).getEastNorth(), eastNorth, 0.0);
                    d2 = polarCoor2.angle - polarCoor.angle;
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                    d2 /= (double)(n2 - n);
                }
                for (int i = n + 1; i < n2; ++i) {
                    PolarCoor polarCoor3 = new PolarCoor(d, polarCoor.angle + (double)(i - n) * d2, eastNorth, 0.0);
                    object.add(polarCoor3.createMoveCommand(list.get(i % n3)));
                }
            }
            n = n2;
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle", new Object[0]), (Collection<Command>)object));
        Main.map.repaint();
    }

    private List<Node> collectNodesWithExternReferers(List<Way> list) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Way way : list) {
            for (Node node : way.getNodes()) {
                if (node.getReferrers().size() <= 1) continue;
                arrayList.add(node);
            }
        }
        return arrayList;
    }

    private List<Node> collectNodesAnticlockwise(List<Way> list) {
        int n;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node = list.get(0).firstNode();
        Node node2 = null;
        Way way = null;
        block0: while (node != node2) {
            if (node2 == null) {
                node2 = node;
            }
            for (Way way2 : list) {
                List<Node> list2;
                if (way2 == way) continue;
                if (way2.firstNode() == node2) {
                    list2 = way2.getNodes();
                    for (n = 0; n < list2.size() - 1; ++n) {
                        arrayList.add(list2.get(n));
                    }
                    node2 = way2.lastNode();
                    way = way2;
                    continue block0;
                }
                if (way2.lastNode() != node2) continue;
                list2 = way2.getNodes();
                for (n = list2.size() - 1; n > 0; --n) {
                    arrayList.add(list2.get(n));
                }
                node2 = way2.firstNode();
                way = way2;
                continue block0;
            }
        }
        int n2 = arrayList.size();
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            EastNorth eastNorth = ((Node)arrayList.get(n)).getEastNorth();
            EastNorth eastNorth2 = arrayList.get((n + 1) % n2).getEastNorth();
            d += eastNorth.east() * eastNorth2.north() - eastNorth2.east() * eastNorth.north();
        }
        if (d < 0.0) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    private boolean actionAllowed(Collection<Node> collection) {
        boolean bl = false;
        for (Node node : collection) {
            if (!node.isOutsideDownloadArea()) continue;
            bl = true;
            break;
        }
        if (bl) {
            new Notification(I18n.tr("One or more nodes involved in this action is outside of the downloaded area.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
        }
        return true;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AlignInCircleAction.getCurrentDataSet() != null && !AlignInCircleAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    protected static boolean checkWaysArePolygon(Collection<Way> collection) {
        OsmPrimitive osmPrimitive22;
        for (OsmPrimitive osmPrimitive22 : collection) {
            for (Node node : osmPrimitive22.getNodes()) {
                if (node == osmPrimitive22.firstNode() || node == osmPrimitive22.lastNode()) continue;
                for (Way object : collection) {
                    if (osmPrimitive22 == object || !node.getReferrers().contains(object)) continue;
                    return false;
                }
            }
        }
        Iterator<Way> iterator = null;
        osmPrimitive22 = null;
        Object object = null;
        int n = 0;
        do {
            Object object2 = null;
            for (Way way : collection) {
                if (way.firstNode() == way.lastNode()) {
                    return collection.size() == 1;
                }
                if (way == iterator) continue;
                if (iterator == null) {
                    object2 = way;
                    osmPrimitive22 = way.firstNode();
                    object = way.lastNode();
                    break;
                }
                if (way.firstNode() == object) {
                    object2 = way;
                    object = way.lastNode();
                    break;
                }
                if (way.lastNode() != object) continue;
                object2 = way;
                object = way.firstNode();
                break;
            }
            if (object2 == null) {
                return false;
            }
            ++n;
            iterator = object2;
        } while (object != osmPrimitive22);
        return n == collection.size();
    }

    public static class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double d, double d2) {
            this(d, d2, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double d, double d2, EastNorth eastNorth, double d3) {
            this.radius = d;
            this.angle = d2;
            this.origin = eastNorth;
            this.azimuth = d3;
        }

        PolarCoor(EastNorth eastNorth) {
            this(eastNorth, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            this.radius = AlignInCircleAction.distance(eastNorth, eastNorth2);
            this.angle = Math.atan2(eastNorth.north() - eastNorth2.north(), eastNorth.east() - eastNorth2.east());
            this.origin = eastNorth2;
            this.azimuth = d;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }

        public MoveCommand createMoveCommand(Node node) {
            EastNorth eastNorth = this.toEastNorth();
            return new MoveCommand((OsmPrimitive)node, eastNorth.east() - node.getEastNorth().east(), eastNorth.north() - node.getEastNorth().north());
        }
    }
}

