/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.PentaxMakernoteDirectory;

public class PentaxMakernoteDescriptor
extends TagDescriptor<PentaxMakernoteDirectory> {
    public PentaxMakernoteDescriptor(@NotNull PentaxMakernoteDirectory pentaxMakernoteDirectory) {
        super(pentaxMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getCaptureModeDescription();
            }
            case 2: {
                return this.getQualityLevelDescription();
            }
            case 3: {
                return this.getFocusModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getIsoSpeedDescription();
            }
            case 23: {
                return this.getColourDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getColourDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(23);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Black & White";
            }
            case 3: {
                return "Sepia";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getIsoSpeedDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(20);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 10: {
                return "ISO 100";
            }
            case 16: {
                return "ISO 200";
            }
            case 100: {
                return "ISO 100";
            }
            case 200: {
                return "ISO 200";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(13);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(12);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(11);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Soft";
            }
            case 2: {
                return "Hard";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Float f = ((PentaxMakernoteDirectory)this._directory).getFloatObject(10);
        if (f == null) {
            return null;
        }
        if (f.floatValue() == 0.0f) {
            return "Off";
        }
        return Float.toString(f.floatValue());
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(7);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Shade";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Fluorescent";
            }
            case 5: {
                return "Manual";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(4);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Flash On";
            }
            case 4: {
                return "Flash Off";
            }
            case 6: {
                return "Red-eye Reduction";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusModeDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(3);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return "Custom";
            }
            case 3: {
                return "Auto";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getQualityLevelDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(2);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Good";
            }
            case 1: {
                return "Better";
            }
            case 2: {
                return "Best";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getCaptureModeDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(1);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Night-scene";
            }
            case 3: {
                return "Manual";
            }
            case 4: {
                return "Multiple";
            }
        }
        return "Unknown (" + n + ")";
    }
}

